/*
 * Decompiled with CFR 0.152.
 */
package com.cuelinks;

import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;
import android.text.Spannable;
import android.text.method.LinkMovementMethod;
import android.text.style.URLSpan;
import android.view.View;
import android.widget.TextView;
import com.cuelinks.CuelinkListener;
import com.cuelinks.CuelinkUtil;

public class CuelinkSpan
extends URLSpan {
    private static final String TAG = "CuelinkSpan";
    private static CuelinkListener mListener;
    private static String mSubId;
    public static final Parcelable.Creator<CuelinkSpan> CREATOR;

    public CuelinkSpan(String url) {
        super(url);
    }

    public CuelinkSpan(Parcel parcel) {
        super(parcel);
    }

    public void onClick(View widget) {
        String url = CuelinkUtil.getAffiliatedUrl(this.getURL(), mSubId);
        Context context = widget.getContext();
        if (mListener == null) {
            Intent intent = new Intent("android.intent.action.VIEW", Uri.parse((String)url));
            if (context != null) {
                intent.putExtra("com.android.browser.application_id", context.getPackageName());
                context.startActivity(intent);
            }
        } else {
            mListener.openUrl(url, context);
        }
    }

    private static CharSequence replaceSpan(CharSequence text, TextView view) {
        Spannable s;
        URLSpan[] spans;
        view.setAutoLinkMask(0);
        view.setMovementMethod(LinkMovementMethod.getInstance());
        if (text instanceof Spannable && (spans = (URLSpan[])(s = (Spannable)text).getSpans(0, s.length(), URLSpan.class)) != null && spans.length > 0) {
            for (int i = spans.length - 1; i >= 0; --i) {
                URLSpan span = spans[i];
                int start = s.getSpanStart((Object)span);
                int end = s.getSpanEnd((Object)span);
                int flags = s.getSpanFlags((Object)span);
                s.removeSpan((Object)span);
                s.setSpan((Object)new CuelinkSpan(span.getURL()), start, end, flags);
            }
        }
        return text;
    }

    public static CharSequence affiliateHrefUrls(CharSequence text, TextView view) {
        mListener = null;
        mSubId = null;
        return CuelinkSpan.replaceSpan(text, view);
    }

    public static CharSequence affiliateHrefUrls(CharSequence text, TextView view, CuelinkListener cuelinkListener) {
        mListener = cuelinkListener;
        mSubId = null;
        return CuelinkSpan.replaceSpan(text, view);
    }

    public static CharSequence affiliateHrefUrls(CharSequence text, TextView view, CuelinkListener cuelinkListener, String subId) {
        mListener = cuelinkListener;
        mSubId = subId;
        return CuelinkSpan.replaceSpan(text, view);
    }

    public static CharSequence affiliateHrefUrls(CharSequence text, TextView view, String subId) {
        mListener = null;
        mSubId = subId;
        return CuelinkSpan.replaceSpan(text, view);
    }

    public static CharSequence affiliateHrefUrlsFromHtml(CharSequence html, TextView view) {
        return CuelinkSpan.affiliateHrefUrls((CharSequence)CuelinkUtil.fromHtml(html.toString()), view);
    }

    public static CharSequence affiliateHrefUrlsFromHtml(CharSequence html, TextView view, String subId) {
        return CuelinkSpan.affiliateHrefUrls((CharSequence)CuelinkUtil.fromHtml(html.toString()), view, subId);
    }

    public static CharSequence affiliateHrefUrlsFromHtml(CharSequence html, TextView view, CuelinkListener cuelinkListener) {
        return CuelinkSpan.affiliateHrefUrls((CharSequence)CuelinkUtil.fromHtml(html.toString()), view, cuelinkListener);
    }

    public static CharSequence affiliateHrefUrlsFromHtml(CharSequence html, TextView view, CuelinkListener cuelinkListener, String subId) {
        return CuelinkSpan.affiliateHrefUrls((CharSequence)CuelinkUtil.fromHtml(html.toString()), view, cuelinkListener, subId);
    }

    static {
        CREATOR = new Parcelable.Creator<CuelinkSpan>(){

            public CuelinkSpan createFromParcel(Parcel in) {
                return new CuelinkSpan(in);
            }

            public CuelinkSpan[] newArray(int size) {
                return new CuelinkSpan[size];
            }
        };
    }
}

