/*
 * Decompiled with CFR 0.152.
 */
package com.ctrip.framework.apollo.mockserver;

import com.ctrip.framework.apollo.build.ApolloInjector;
import com.ctrip.framework.apollo.core.dto.ApolloConfig;
import com.ctrip.framework.apollo.core.dto.ApolloConfigNotification;
import com.ctrip.framework.apollo.core.utils.ResourceUtils;
import com.ctrip.framework.apollo.internals.ConfigServiceLocator;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import okhttp3.mockwebserver.Dispatcher;
import okhttp3.mockwebserver.MockResponse;
import okhttp3.mockwebserver.MockWebServer;
import okhttp3.mockwebserver.RecordedRequest;
import org.junit.rules.ExternalResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EmbeddedApollo
extends ExternalResource {
    private static final Logger logger = LoggerFactory.getLogger(EmbeddedApollo.class);
    private static final Type notificationType = new TypeToken<List<ApolloConfigNotification>>(){}.getType();
    private static Method CONFIG_SERVICE_LOCATOR_CLEAR;
    private static ConfigServiceLocator CONFIG_SERVICE_LOCATOR;
    private final Gson gson = new Gson();
    private final Map<String, Map<String, String>> addedOrModifiedPropertiesOfNamespace = new HashMap<String, Map<String, String>>();
    private final Map<String, Set<String>> deletedKeysOfNamespace = new HashMap<String, Set<String>>();
    private MockWebServer server;

    protected void before() throws Throwable {
        this.clear();
        this.server = new MockWebServer();
        Dispatcher dispatcher = new Dispatcher(){

            public MockResponse dispatch(RecordedRequest request) throws InterruptedException {
                if (request.getPath().startsWith("/notifications/v2")) {
                    String notifications = request.getRequestUrl().queryParameter("notifications");
                    return new MockResponse().setResponseCode(200).setBody(EmbeddedApollo.this.mockLongPollBody(notifications));
                }
                if (request.getPath().startsWith("/configs")) {
                    List pathSegments = request.getRequestUrl().pathSegments();
                    String appId = (String)pathSegments.get(1);
                    String cluster = (String)pathSegments.get(2);
                    String namespace = (String)pathSegments.get(3);
                    return new MockResponse().setResponseCode(200).setBody(EmbeddedApollo.this.loadConfigFor(namespace));
                }
                return new MockResponse().setResponseCode(404);
            }
        };
        this.server.setDispatcher(dispatcher);
        this.server.start();
        this.mockConfigServiceUrl("http://localhost:" + this.server.getPort());
        super.before();
    }

    protected void after() {
        try {
            this.clear();
            this.server.close();
        }
        catch (Exception e) {
            logger.error("stop apollo server error", (Throwable)e);
        }
    }

    private void clear() throws Exception {
        this.resetOverriddenProperties();
    }

    private void mockConfigServiceUrl(String url) throws Exception {
        System.setProperty("apollo.configService", url);
        CONFIG_SERVICE_LOCATOR_CLEAR.invoke((Object)CONFIG_SERVICE_LOCATOR, new Object[0]);
    }

    private String loadConfigFor(String namespace) {
        String filename = String.format("mockdata-%s.properties", namespace);
        Properties prop = ResourceUtils.readConfigFile((String)filename, (Properties)new Properties());
        HashMap configurations = Maps.newHashMap();
        for (String propertyName : prop.stringPropertyNames()) {
            configurations.put(propertyName, prop.getProperty(propertyName));
        }
        ApolloConfig apolloConfig = new ApolloConfig("someAppId", "someCluster", namespace, "someReleaseKey");
        Map<String, String> mergedConfigurations = this.mergeOverriddenProperties(namespace, configurations);
        apolloConfig.setConfigurations(mergedConfigurations);
        return this.gson.toJson((Object)apolloConfig);
    }

    private String mockLongPollBody(String notificationsStr) {
        List oldNotifications = (List)this.gson.fromJson(notificationsStr, notificationType);
        ArrayList<ApolloConfigNotification> newNotifications = new ArrayList<ApolloConfigNotification>();
        for (ApolloConfigNotification notification : oldNotifications) {
            newNotifications.add(new ApolloConfigNotification(notification.getNamespaceName(), notification.getNotificationId() + 1L));
        }
        return this.gson.toJson(newNotifications);
    }

    private Map<String, String> mergeOverriddenProperties(String namespace, Map<String, String> configurations) {
        if (this.addedOrModifiedPropertiesOfNamespace.containsKey(namespace)) {
            configurations.putAll(this.addedOrModifiedPropertiesOfNamespace.get(namespace));
        }
        if (this.deletedKeysOfNamespace.containsKey(namespace)) {
            for (String k : this.deletedKeysOfNamespace.get(namespace)) {
                configurations.remove(k);
            }
        }
        return configurations;
    }

    public void addOrModifyProperty(String namespace, String someKey, String someValue) {
        if (this.addedOrModifiedPropertiesOfNamespace.containsKey(namespace)) {
            this.addedOrModifiedPropertiesOfNamespace.get(namespace).put(someKey, someValue);
        } else {
            this.addedOrModifiedPropertiesOfNamespace.put(namespace, (Map<String, String>)ImmutableMap.of((Object)someKey, (Object)someValue));
        }
    }

    public void deleteProperty(String namespace, String someKey) {
        if (this.deletedKeysOfNamespace.containsKey(namespace)) {
            this.deletedKeysOfNamespace.get(namespace).add(someKey);
        } else {
            this.deletedKeysOfNamespace.put(namespace, (Set<String>)ImmutableSet.of((Object)someKey));
        }
    }

    public void resetOverriddenProperties() {
        this.addedOrModifiedPropertiesOfNamespace.clear();
        this.deletedKeysOfNamespace.clear();
    }

    static {
        try {
            System.setProperty("apollo.longPollingInitialDelayInMills", "0");
            CONFIG_SERVICE_LOCATOR = (ConfigServiceLocator)ApolloInjector.getInstance(ConfigServiceLocator.class);
            CONFIG_SERVICE_LOCATOR_CLEAR = ConfigServiceLocator.class.getDeclaredMethod("initConfigServices", new Class[0]);
            CONFIG_SERVICE_LOCATOR_CLEAR.setAccessible(true);
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
    }
}

