/*
 * Decompiled with CFR 0.152.
 */
package com.cs.googlemaproute;

import android.app.ProgressDialog;
import android.content.Context;
import android.graphics.Color;
import android.os.AsyncTask;
import android.widget.Toast;
import com.google.android.gms.maps.CameraUpdate;
import com.google.android.gms.maps.CameraUpdateFactory;
import com.google.android.gms.maps.GoogleMap;
import com.google.android.gms.maps.model.CameraPosition;
import com.google.android.gms.maps.model.LatLng;
import com.google.android.gms.maps.model.Polyline;
import com.google.android.gms.maps.model.PolylineOptions;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class DrawRoute {
    double from_lat = 24.905954;
    double from_log = 67.0803505;
    double to_lat = 24.9053485;
    double to_log = 67.079119;
    String google_key = "";
    Polyline line;
    GoogleMap g_map;
    Context context;
    float zoom_level = 13.0f;
    String color_hash = "#05b1fb";
    public onDrawRoute callInterface;
    boolean show_loader = true;
    String loader_msg = "Please wait...";

    public DrawRoute(onDrawRoute dlg, Context ctx) {
        this.context = ctx;
        this.callInterface = dlg;
    }

    public static DrawRoute getInstance(onDrawRoute dlg, Context ctx) {
        return new DrawRoute(dlg, ctx);
    }

    public DrawRoute setFromLatLong(double fromlat, double fromlog) {
        this.from_lat = fromlat;
        this.from_log = fromlog;
        return this;
    }

    public DrawRoute setToLatLong(double tolat, double tolog) {
        this.to_lat = tolat;
        this.to_log = tolog;
        return this;
    }

    public DrawRoute setGmapAndKey(String googlekey, GoogleMap gmap) {
        this.google_key = googlekey;
        this.g_map = gmap;
        return this;
    }

    public DrawRoute setZoomLevel(float zoomlevel) {
        this.zoom_level = zoomlevel;
        return this;
    }

    public DrawRoute setColorHash(String colorhash) {
        this.color_hash = colorhash;
        return this;
    }

    public DrawRoute setLoader(boolean showloader) {
        this.show_loader = showloader;
        return this;
    }

    public DrawRoute setLoaderMsg(String loadermsg) {
        this.loader_msg = loadermsg;
        return this;
    }

    public void run() {
        if (this.google_key.equals("")) {
            Toast.makeText((Context)this.context, (CharSequence)"Please set google map key", (int)0).show();
            return;
        }
        String dUrl = this.generateURL(this.from_lat, this.from_log, this.to_lat, this.to_log, this.google_key);
        new connectAsyncTask(dUrl).execute(new Void[0]);
    }

    public String generateURL(double sourcelat, double sourcelog, double destlat, double destlog, String google_key) {
        StringBuilder urlString = new StringBuilder();
        urlString.append("https://maps.googleapis.com/maps/api/directions/json");
        urlString.append("?origin=");
        urlString.append(Double.toString(sourcelat));
        urlString.append(",");
        urlString.append(Double.toString(sourcelog));
        urlString.append("&destination=");
        urlString.append(Double.toString(destlat));
        urlString.append(",");
        urlString.append(Double.toString(destlog));
        urlString.append("&sensor=false&mode=driving&alternatives=true");
        urlString.append("&key=" + google_key);
        return urlString.toString();
    }

    public void drawPath(String result) {
        try {
            JSONObject json = new JSONObject(result);
            JSONArray routeArray = json.getJSONArray("routes");
            JSONObject routes = routeArray.getJSONObject(0);
            JSONObject overviewPolylines = routes.getJSONObject("overview_polyline");
            String encodedString = overviewPolylines.getString("points");
            List<LatLng> list = this.decodePoly(encodedString);
            if (this.line != null) {
                this.line.remove();
            }
            this.line = this.g_map.addPolyline(new PolylineOptions().addAll(list).width(12.0f).color(Color.parseColor((String)this.color_hash)).geodesic(true));
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
    }

    private List<LatLng> decodePoly(String encoded) {
        ArrayList<LatLng> poly = new ArrayList<LatLng>();
        int index = 0;
        int len = encoded.length();
        int lat = 0;
        int lng = 0;
        while (index < len) {
            int b;
            int shift = 0;
            int result = 0;
            do {
                b = encoded.charAt(index++) - 63;
                result |= (b & 0x1F) << shift;
                shift += 5;
            } while (b >= 32);
            int dlat = (result & 1) != 0 ? ~(result >> 1) : result >> 1;
            lat += dlat;
            shift = 0;
            result = 0;
            do {
                b = encoded.charAt(index++) - 63;
                result |= (b & 0x1F) << shift;
                shift += 5;
            } while (b >= 32);
            int dlng = (result & 1) != 0 ? ~(result >> 1) : result >> 1;
            LatLng p = new LatLng((double)lat / 100000.0, (double)(lng += dlng) / 100000.0);
            poly.add(p);
        }
        return poly;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String readStream(InputStream in) {
        BufferedReader reader = null;
        StringBuffer response = new StringBuffer();
        try {
            reader = new BufferedReader(new InputStreamReader(in));
            String line = "";
            while ((line = reader.readLine()) != null) {
                response.append(line);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return response.toString();
    }

    private class connectAsyncTask
    extends AsyncTask<Void, Void, String> {
        private ProgressDialog progressDialog;
        String urls;

        connectAsyncTask(String urlPass) {
            this.urls = urlPass;
        }

        protected void onPreExecute() {
            super.onPreExecute();
            if (DrawRoute.this.show_loader) {
                this.progressDialog = new ProgressDialog(DrawRoute.this.context);
                this.progressDialog.setMessage((CharSequence)DrawRoute.this.loader_msg);
                this.progressDialog.setIndeterminate(true);
                this.progressDialog.show();
            }
        }

        protected String doInBackground(Void ... params) {
            String server_response = "";
            URL url = null;
            HttpURLConnection urlConnection = null;
            try {
                url = new URL(this.urls);
                urlConnection = (HttpURLConnection)url.openConnection();
                int responseCode = urlConnection.getResponseCode();
                if (responseCode == 200) {
                    server_response = DrawRoute.this.readStream(urlConnection.getInputStream());
                }
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            return server_response;
        }

        protected void onPostExecute(String result) {
            super.onPostExecute((Object)result);
            if (DrawRoute.this.show_loader) {
                this.progressDialog.hide();
            }
            if (result != null) {
                DrawRoute.this.drawPath(result);
                CameraPosition cameraPosition = new CameraPosition.Builder().target(new LatLng(DrawRoute.this.from_lat, DrawRoute.this.from_log)).zoom(DrawRoute.this.zoom_level).build();
                CameraUpdate cameraUpdate = CameraUpdateFactory.newCameraPosition((CameraPosition)cameraPosition);
                DrawRoute.this.g_map.animateCamera(cameraUpdate);
            }
            DrawRoute.this.callInterface.afterDraw("" + result);
        }
    }

    public static interface onDrawRoute {
        public void afterDraw(String var1);
    }
}

