/*
 * Decompiled with CFR 0.152.
 */
package com.rahul.media.activity;

import android.app.Activity;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.net.Uri;
import android.os.AsyncTask;
import android.os.Build;
import android.os.Bundle;
import android.os.Parcelable;
import android.support.v4.content.FileProvider;
import android.support.v7.app.AlertDialog;
import android.support.v7.app.AppCompatActivity;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.support.v7.widget.Toolbar;
import android.view.Menu;
import android.view.MenuItem;
import android.view.View;
import android.widget.AdapterView;
import android.widget.Toast;
import com.msupport.MSupport;
import com.msupport.MSupportConstants;
import com.rahul.media.R;
import com.rahul.media.adapters.ImageListRecycleAdapter;
import com.rahul.media.adapters.ImagePreviewAdapter;
import com.rahul.media.model.CustomGallery;
import com.rahul.media.model.Define;
import com.rahul.media.utils.BitmapDecoder;
import com.rahul.media.utils.MediaUtility;
import com.rahul.media.utils.ViewPagerSwipeLess;
import crop.Crop;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;

public class CameraPickActivity
extends AppCompatActivity {
    private static final int ACTION_REQUEST_CAMERA = 201;
    private ViewPagerSwipeLess mPager;
    private HashMap<String, CustomGallery> dataT;
    private ImagePreviewAdapter imagePreviewAdapter;
    private ImageListRecycleAdapter mImageListAdapter;
    private Uri userPhotoUri;
    private boolean isCrop;
    private boolean isSquareCrop;
    private int pickCount = 1;
    private AlertDialog alertDialog;
    private int aspectX;
    private int aspectY;

    private void showAlertDialog(Context mContext, String text) {
        this.alertDialog = new AlertDialog.Builder(mContext).setMessage((CharSequence)text).setCancelable(false).setPositiveButton((CharSequence)"OK", new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                CameraPickActivity.this.alertDialog.dismiss();
            }
        }).create();
        this.alertDialog.show();
    }

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.activity_camera_preview);
        Toolbar toolbar = (Toolbar)this.findViewById(R.id.toolbar);
        this.setSupportActionBar(toolbar);
        toolbar.setBackgroundColor(Define.ACTIONBAR_COLOR);
        this.getSupportActionBar().setDisplayHomeAsUpEnabled(true);
        this.mPager = (ViewPagerSwipeLess)this.findViewById(R.id.pager);
        this.dataT = new HashMap();
        this.imagePreviewAdapter = new ImagePreviewAdapter((Context)this, this.dataT);
        this.mPager.setAdapter(this.imagePreviewAdapter);
        this.mImageListAdapter = new ImageListRecycleAdapter((Context)this, this.dataT);
        RecyclerView mRecycleView = (RecyclerView)this.findViewById(R.id.image_hlistview);
        mRecycleView.setLayoutManager((RecyclerView.LayoutManager)new LinearLayoutManager((Context)this, 0, false));
        mRecycleView.setAdapter((RecyclerView.Adapter)this.mImageListAdapter);
        this.mImageListAdapter.setOnItemClickListener(new AdapterView.OnItemClickListener(){

            public void onItemClick(AdapterView<?> parent, View view, int position, long id2) {
                CameraPickActivity.this.mPager.setCurrentItem(position);
            }
        });
        try {
            this.aspectX = this.getIntent().getIntExtra("aspect_x", 1);
            this.aspectY = this.getIntent().getIntExtra("aspect_y", 1);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.isCrop = this.getIntent().getExtras().getBoolean("crop");
            this.isSquareCrop = this.getIntent().getExtras().getBoolean("isSquareCrop");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (this.getIntent().getExtras().containsKey("pickCount")) {
            this.pickCount = this.getIntent().getIntExtra("pickCount", 1);
        }
        this.openCamera(false);
    }

    public void onBackPressed() {
        Intent data2 = new Intent();
        this.setResult(0, data2);
        super.onBackPressed();
    }

    private void openCamera(boolean isPermission) {
        String[] permissionSet = new String[]{"android.permission.WRITE_EXTERNAL_STORAGE", "android.permission.CAMERA"};
        if (isPermission) {
            this.cameraIntent();
        } else {
            boolean isCameraPermissionGranted = Build.VERSION.SDK_INT >= 23 ? MSupport.checkMultiplePermission((Activity)this, permissionSet, 124) : true;
            if (isCameraPermissionGranted) {
                this.cameraIntent();
            }
        }
    }

    private void cameraIntent() {
        try {
            Intent takePictureIntent = new Intent("android.media.action.IMAGE_CAPTURE");
            if (takePictureIntent.resolveActivity(this.getPackageManager()) != null) {
                Uri imageFile = MediaUtility.createImageFile((Context)this);
                this.userPhotoUri = FileProvider.getUriForFile((Context)this, (String)Define.MEDIA_PROVIDER, (File)new File(imageFile.getPath()));
                if (Build.VERSION.SDK_INT > 23) {
                    takePictureIntent.putExtra("output", (Parcelable)this.userPhotoUri);
                    this.userPhotoUri = imageFile;
                } else {
                    this.userPhotoUri = imageFile;
                    takePictureIntent.putExtra("output", (Parcelable)this.userPhotoUri);
                }
                this.startActivityForResult(takePictureIntent, 201);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.showAlertDialog((Context)this, "Device does not support camera.");
        }
    }

    public void onRequestPermissionsResult(int requestCode, String[] permissions, int[] grantResults) {
        switch (requestCode) {
            case 124: {
                ArrayList<String> deniedPermissionList = new ArrayList<String>();
                boolean isAllPermissionGranted = true;
                for (int i = 0; i < grantResults.length; ++i) {
                    int results = grantResults[i];
                    String permission2 = permissions[i];
                    if (results == 0) continue;
                    isAllPermissionGranted = false;
                    deniedPermissionList.add(MSupportConstants.getPermissionRationaleMessage(permission2));
                }
                if (isAllPermissionGranted) {
                    this.openCamera(true);
                    break;
                }
                String message = "Requested Permission not granted";
                if (!deniedPermissionList.isEmpty()) {
                    message = "You need to grant access to " + (String)deniedPermissionList.get(0);
                    for (int i = 1; i < deniedPermissionList.size(); ++i) {
                        message = message + ", " + (String)deniedPermissionList.get(i);
                    }
                    message = message + " to access app features";
                }
                Toast.makeText((Context)this, (CharSequence)message, (int)0).show();
                this.finish();
            }
        }
    }

    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        if (resultCode == -1) {
            if (requestCode == 201) {
                if (this.pickCount == 1) {
                    this.dataT.clear();
                }
                if (this.userPhotoUri != null) {
                    new ProcessImageView().execute(new Void[0]);
                }
            } else if (requestCode == 6709) {
                try {
                    Uri mTargetImageUri = (Uri)data.getExtras().get("output");
                    if (mTargetImageUri != null) {
                        String imagePath = this.mImageListAdapter.mItems.get((int)this.mPager.getCurrentItem()).sdcardPath;
                        CustomGallery item = new CustomGallery();
                        item.sdcardPath = mTargetImageUri.getPath();
                        item.sdCardUri = mTargetImageUri;
                        this.dataT.remove(imagePath);
                        this.dataT.put(mTargetImageUri.getPath(), item);
                        this.imagePreviewAdapter.customNotify(this.dataT);
                        this.mImageListAdapter.customNotify(this.dataT);
                    }
                }
                catch (Exception e) {
                    String invalidImageText = (String)data.getExtras().get("invalid_image");
                    if (invalidImageText != null) {
                        this.showAlertDialog((Context)this, invalidImageText);
                    }
                }
            }
        } else if (this.dataT == null || this.dataT.size() == 0) {
            Intent data2 = new Intent();
            this.setResult(0, data2);
            this.finish();
        }
    }

    public boolean onCreateOptionsMenu(Menu menu2) {
        this.getMenuInflater().inflate(R.menu.menu_camera, menu2);
        menu2.findItem(R.id.action_crop).setVisible(this.isCrop);
        return true;
    }

    public boolean onOptionsItemSelected(MenuItem item) {
        int id2 = item.getItemId();
        if (id2 == R.id.action_ok) {
            ArrayList<CustomGallery> mArrayList = new ArrayList<CustomGallery>(this.dataT.values());
            if (mArrayList.size() > 0) {
                ArrayList<String> allPath = new ArrayList<String>();
                for (int i = 0; i < mArrayList.size(); ++i) {
                    allPath.add(mArrayList.get((int)i).sdcardPath);
                }
                Intent data = new Intent().putStringArrayListExtra("all_path", allPath);
                this.setResult(-1, data);
                this.finish();
            } else {
                this.showAlertDialog((Context)this, "Please select an image.");
            }
        } else if (id2 == 16908332) {
            Intent data = new Intent();
            this.setResult(0, data);
            this.finish();
        } else if (id2 == R.id.action_camera) {
            this.openCamera(false);
        } else if (id2 == R.id.action_crop && this.imagePreviewAdapter != null && this.imagePreviewAdapter.getCount() > 0) {
            String imagePath = this.mImageListAdapter.mItems.get((int)this.mPager.getCurrentItem()).sdcardPath;
            try {
                Uri destination = MediaUtility.createImageFile((Context)this);
                if (this.isSquareCrop) {
                    Crop.of(Uri.parse((String)("file://" + imagePath)), destination).asSquare().start((Activity)this);
                } else {
                    Crop.of(Uri.parse((String)("file://" + imagePath)), destination).withAspect(this.aspectX, this.aspectY).start((Activity)this);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return super.onOptionsItemSelected(item);
    }

    private class ProcessImageView
    extends AsyncTask<Void, Void, Void> {
        private ProcessImageView() {
        }

        protected void onPreExecute() {
            super.onPreExecute();
        }

        protected Void doInBackground(Void ... params) {
            CustomGallery item = new CustomGallery();
            item.sdcardPath = CameraPickActivity.this.userPhotoUri.getPath();
            item.sdCardUri = CameraPickActivity.this.userPhotoUri;
            item.sdcardPath = BitmapDecoder.getBitmap(CameraPickActivity.this.userPhotoUri.getPath(), (Context)CameraPickActivity.this);
            item.sdCardUri = Uri.parse((String)item.sdcardPath);
            CameraPickActivity.this.dataT.put(item.sdcardPath, item);
            return null;
        }

        protected void onPostExecute(Void aVoid) {
            super.onPostExecute((Object)aVoid);
            CameraPickActivity.this.imagePreviewAdapter.customNotify(CameraPickActivity.this.dataT);
            CameraPickActivity.this.mImageListAdapter.customNotify(CameraPickActivity.this.dataT);
        }
    }
}

