/*
 * Decompiled with CFR 0.152.
 */
package com.rahul.media.utils;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.media.ExifInterface;
import android.util.Log;
import com.rahul.media.utils.MediaUtility;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class BitmapDecoder {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String compressImage(String filePath, Context mContext) {
        try {
            MediaUtility.initializeImageLoader(mContext);
            String imageName = filePath.substring(filePath.lastIndexOf("/") + 1, filePath.length());
            File fileBackup = new File(MediaUtility.getUserImageDir(mContext) + "/" + imageName);
            if (fileBackup.exists()) {
                return fileBackup.getAbsolutePath();
            }
            Bitmap scaledBitmap = null;
            BitmapFactory.Options options = new BitmapFactory.Options();
            options.inJustDecodeBounds = true;
            Bitmap bmp = BitmapFactory.decodeFile((String)filePath, (BitmapFactory.Options)options);
            int actualHeight = options.outHeight;
            int actualWidth = options.outWidth;
            float maxHeight = 816.0f;
            float maxWidth = 612.0f;
            float imgRatio = actualWidth / actualHeight;
            float maxRatio = maxWidth / maxHeight;
            if ((float)actualHeight > maxHeight || (float)actualWidth > maxWidth) {
                if (imgRatio < maxRatio) {
                    imgRatio = maxHeight / (float)actualHeight;
                    actualWidth = (int)(imgRatio * (float)actualWidth);
                    actualHeight = (int)maxHeight;
                } else if (imgRatio > maxRatio) {
                    imgRatio = maxWidth / (float)actualWidth;
                    actualHeight = (int)(imgRatio * (float)actualHeight);
                    actualWidth = (int)maxWidth;
                } else {
                    actualHeight = (int)maxHeight;
                    actualWidth = (int)maxWidth;
                }
            }
            options.inSampleSize = BitmapDecoder.calculateInSampleSize(options, actualWidth, actualHeight);
            options.inJustDecodeBounds = false;
            options.inPurgeable = true;
            options.inInputShareable = true;
            options.inTempStorage = new byte[16384];
            try {
                bmp = BitmapFactory.decodeFile((String)filePath, (BitmapFactory.Options)options);
            }
            catch (OutOfMemoryError exception) {
                exception.printStackTrace();
            }
            try {
                scaledBitmap = Bitmap.createBitmap((int)actualWidth, (int)actualHeight, (Bitmap.Config)Bitmap.Config.ARGB_8888);
            }
            catch (OutOfMemoryError exception) {
                exception.printStackTrace();
            }
            float ratioX = (float)actualWidth / (float)options.outWidth;
            float ratioY = (float)actualHeight / (float)options.outHeight;
            float middleX = (float)actualWidth / 2.0f;
            float middleY = (float)actualHeight / 2.0f;
            Matrix scaleMatrix = new Matrix();
            scaleMatrix.setScale(ratioX, ratioY, middleX, middleY);
            Canvas canvas = new Canvas(scaledBitmap);
            canvas.setMatrix(scaleMatrix);
            canvas.drawBitmap(bmp, middleX - (float)(bmp.getWidth() / 2), middleY - (float)(bmp.getHeight() / 2), new Paint(2));
            try {
                ExifInterface exif = new ExifInterface(filePath);
                int orientation = exif.getAttributeInt("Orientation", 0);
                Log.d((String)"EXIF", (String)("Exif: " + orientation));
                Matrix matrix = new Matrix();
                if (orientation == 6) {
                    matrix.postRotate(90.0f);
                    Log.d((String)"EXIF", (String)("Exif: " + orientation));
                } else if (orientation == 3) {
                    matrix.postRotate(180.0f);
                    Log.d((String)"EXIF", (String)("Exif: " + orientation));
                } else if (orientation == 8) {
                    matrix.postRotate(270.0f);
                    Log.d((String)"EXIF", (String)("Exif: " + orientation));
                }
                scaledBitmap = Bitmap.createBitmap((Bitmap)scaledBitmap, (int)0, (int)0, (int)scaledBitmap.getWidth(), (int)scaledBitmap.getHeight(), (Matrix)matrix, (boolean)true);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            FileOutputStream fOut = null;
            try {
                fOut = new FileOutputStream(fileBackup);
                scaledBitmap.compress(Bitmap.CompressFormat.PNG, 80, (OutputStream)fOut);
                filePath = fileBackup.getPath();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                try {
                    if (fOut != null) {
                        fOut.close();
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                BitmapDecoder.recycleBitmap(scaledBitmap);
                BitmapDecoder.recycleBitmap(bmp);
            }
        }
        catch (Exception e) {
            Log.i((String)BitmapDecoder.class.getSimpleName(), (String)e.getLocalizedMessage());
        }
        return filePath;
    }

    private static void recycleBitmap(Bitmap scaledBitmap) {
        try {
            scaledBitmap.recycle();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static int calculateInSampleSize(BitmapFactory.Options options, int reqWidth, int reqHeight) {
        int height = options.outHeight;
        int width = options.outWidth;
        int inSampleSize = 1;
        if (height > reqHeight || width > reqWidth) {
            int widthRatio;
            int heightRatio = Math.round((float)height / (float)reqHeight);
            inSampleSize = heightRatio < (widthRatio = Math.round((float)width / (float)reqWidth)) ? heightRatio : widthRatio;
        }
        float totalPixels = width * height;
        float totalReqPixelsCap = reqWidth * reqHeight * 2;
        while (totalPixels / (float)(inSampleSize * inSampleSize) > totalReqPixelsCap) {
            ++inSampleSize;
        }
        return inSampleSize;
    }

    public static String getBitmap(String filePath, Context mContext) {
        return BitmapDecoder.compressImage(filePath, mContext);
    }
}

