/*
 * Decompiled with CFR 0.152.
 */
package com.rahul.media.imagemodule;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.database.Cursor;
import android.graphics.Bitmap;
import android.net.Uri;
import android.os.AsyncTask;
import android.os.Build;
import android.os.Bundle;
import android.os.Environment;
import android.provider.MediaStore;
import android.support.design.widget.Snackbar;
import android.support.v7.app.AppCompatActivity;
import android.support.v7.widget.Toolbar;
import android.view.Menu;
import android.view.MenuItem;
import android.view.View;
import android.widget.GridView;
import android.widget.ListAdapter;
import android.widget.Toast;
import com.bumptech.glide.Glide;
import com.cache.BitmapMemoryCache;
import com.cache.ByteImageLoader;
import com.msupport.MSupport;
import com.rahul.media.R;
import com.rahul.media.imagemodule.adapter.ImageGalleryGridAdapter;
import com.rahul.media.model.Album;
import com.rahul.media.model.Define;
import com.rahul.media.model.MediaObject;
import com.rahul.media.model.MediaType;
import java.io.File;
import java.util.ArrayList;
import java.util.Map;

public class ImageGalleryPickerActivity
extends AppCompatActivity {
    private GridView gridView;
    private ArrayList<MediaObject> mGalleryImageArrayList = new ArrayList();
    private Album a;
    ImageGalleryGridAdapter adapter;
    private String pathDir = "";
    private int pickCount;
    private ByteImageLoader byteImageLoader;

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.activity_photo_picker);
        Toolbar toolbar = (Toolbar)this.findViewById(R.id.toolbar);
        this.setSupportActionBar(toolbar);
        toolbar.setBackgroundColor(Define.ACTIONBAR_COLOR);
        this.getSupportActionBar().setDisplayHomeAsUpEnabled(true);
        this.a = (Album)this.getIntent().getSerializableExtra("album");
        this.getSupportActionBar().setTitle((CharSequence)this.a.bucketname);
        this.pickCount = this.getIntent().getIntExtra("pickCount", 1);
        this.gridView = (GridView)this.findViewById(R.id.gridview);
        if (Build.VERSION.SDK_INT >= 23) {
            boolean isStoragePermissionGiven = MSupport.checkPermissionWithRationale((Activity)this, null, "android.permission.WRITE_EXTERNAL_STORAGE", 2);
            if (isStoragePermissionGiven) {
                new DisplayImage().execute(new Void[0]);
            }
        } else {
            new DisplayImage().execute(new Void[0]);
        }
    }

    public boolean onCreateOptionsMenu(Menu menu2) {
        this.getMenuInflater().inflate(R.menu.menu_photo_album, menu2);
        return true;
    }

    public boolean onOptionsItemSelected(MenuItem item) {
        int id2 = item.getItemId();
        if (id2 == R.id.action_ok) {
            ArrayList<String> path = new ArrayList<String>();
            for (int i = 0; i < this.mGalleryImageArrayList.size(); ++i) {
                if (!this.mGalleryImageArrayList.get((int)i).isSelected) continue;
                path.add(this.mGalleryImageArrayList.get(i).getPath());
            }
            if (path.isEmpty()) {
                Snackbar.make((View)this.gridView, (CharSequence)this.getString(R.string.msg_no_slected), (int)-1).show();
            } else {
                Intent i = new Intent();
                i.putStringArrayListExtra("all_path", path);
                this.setResult(-1, i);
                this.finish();
            }
            return true;
        }
        if (id2 == 16908332) {
            this.finish();
        }
        return super.onOptionsItemSelected(item);
    }

    protected void onDestroy() {
        super.onDestroy();
        new GlideClearAsync().execute(new Void[0]);
    }

    public void onRequestPermissionsResult(int requestCode, String[] permissions, int[] grantResults) {
        switch (requestCode) {
            case 2: {
                if (grantResults[0] == 0) {
                    new DisplayImage().execute(new Void[0]);
                    break;
                }
                Toast.makeText((Context)this, (CharSequence)"Storage permission not granted", (int)0).show();
                this.finish();
            }
        }
    }

    private void getAllMediaThumbnailsPath(long id2) {
        String path = "";
        String selection = "bucket_id = ?";
        String bucketid = String.valueOf(id2);
        String sort = "_id DESC";
        String[] selectionArgs = new String[]{bucketid};
        Uri images = MediaStore.Images.Media.EXTERNAL_CONTENT_URI;
        Cursor c = !bucketid.equals("0") ? this.getContentResolver().query(images, null, selection, selectionArgs, sort) : this.getContentResolver().query(images, null, null, null, sort);
        if (c != null) {
            c.moveToFirst();
            while (true) {
                MediaObject mediaObject;
                path = c.getString(c.getColumnIndex("_data"));
                long creationDate = ImageGalleryPickerActivity.getCreationDate(path);
                if (c.isLast()) {
                    mediaObject = new MediaObject(c.getInt(0), path, MediaType.PHOTO, creationDate);
                    this.mGalleryImageArrayList.add(mediaObject);
                    c.close();
                    break;
                }
                mediaObject = new MediaObject(c.getInt(0), path, MediaType.PHOTO, creationDate);
                this.mGalleryImageArrayList.add(mediaObject);
                c.moveToNext();
            }
        }
    }

    private static long getCreationDate(String filePath) {
        File file = new File(filePath);
        return file.lastModified();
    }

    public void startFileMediaScan(String path) {
        this.sendBroadcast(new Intent("android.intent.action.MEDIA_SCANNER_SCAN_FILE", Uri.parse((String)("file://" + path))));
    }

    private void setPathDir(String path, String fileName) {
        this.pathDir = path.replace("/" + fileName, "");
    }

    private String getPathDir() {
        if (this.pathDir.equals("") || this.a.bucketid == 0L) {
            this.pathDir = Environment.getExternalStoragePublicDirectory((String)Environment.DIRECTORY_PICTURES).getAbsolutePath();
        }
        return this.pathDir;
    }

    private class GlideClearAsync
    extends AsyncTask<Void, Void, Void> {
        private GlideClearAsync() {
        }

        protected void onPreExecute() {
            super.onPreExecute();
            Glide.get((Context)ImageGalleryPickerActivity.this.getApplicationContext()).clearMemory();
        }

        protected Void doInBackground(Void ... voids) {
            Map<String, Bitmap> cache;
            BitmapMemoryCache bitmapMemoryCache;
            Glide.get((Context)ImageGalleryPickerActivity.this.getApplicationContext()).clearDiskCache();
            if (ImageGalleryPickerActivity.this.byteImageLoader != null && (bitmapMemoryCache = ImageGalleryPickerActivity.this.byteImageLoader.getBitmapMemoryCache()) != null && (cache = bitmapMemoryCache.getCache()) != null) {
                ArrayList<Bitmap> bitmapArrayList = new ArrayList<Bitmap>(cache.values());
                for (Bitmap bitmap : bitmapArrayList) {
                    if (bitmap == null || bitmap.isRecycled()) continue;
                    bitmap.recycle();
                }
                bitmapMemoryCache.clear();
                ImageGalleryPickerActivity.this.byteImageLoader.clearCache();
                ImageGalleryPickerActivity.this.byteImageLoader = null;
                System.gc();
            }
            return null;
        }
    }

    private class DisplayImage
    extends AsyncTask<Void, Void, Boolean> {
        private DisplayImage() {
        }

        protected void onPreExecute() {
            super.onPreExecute();
            Thread t = new Thread(new Runnable(){

                @Override
                public void run() {
                }
            });
            t.start();
        }

        protected Boolean doInBackground(Void ... params) {
            ImageGalleryPickerActivity.this.getAllMediaThumbnailsPath(((ImageGalleryPickerActivity)ImageGalleryPickerActivity.this).a.bucketid);
            return true;
        }

        protected void onPostExecute(Boolean result) {
            super.onPostExecute((Object)result);
            if (result != null && result.booleanValue()) {
                ImageGalleryPickerActivity.this.byteImageLoader = new ByteImageLoader((Context)ImageGalleryPickerActivity.this);
                ImageGalleryPickerActivity.this.adapter = new ImageGalleryGridAdapter((Context)ImageGalleryPickerActivity.this, ImageGalleryPickerActivity.this.mGalleryImageArrayList, ImageGalleryPickerActivity.this.getPathDir(), ImageGalleryPickerActivity.this.pickCount, ImageGalleryPickerActivity.this.getSupportActionBar(), ((ImageGalleryPickerActivity)ImageGalleryPickerActivity.this).a.bucketname, ImageGalleryPickerActivity.this.byteImageLoader);
                ImageGalleryPickerActivity.this.gridView.setAdapter((ListAdapter)ImageGalleryPickerActivity.this.adapter);
            }
        }
    }
}

