/*
 * Decompiled with CFR 0.152.
 */
package com.glidepool;

import android.graphics.Bitmap;
import com.bumptech.glide.util.Util;
import com.glidepool.BaseKeyPool;
import com.glidepool.GroupedLinkedMap;
import com.glidepool.LruPoolStrategy;
import com.glidepool.Poolable;

public class AttributeStrategy
implements LruPoolStrategy {
    private final KeyPool keyPool = new KeyPool();
    private final GroupedLinkedMap<Key, Bitmap> groupedMap = new GroupedLinkedMap();

    @Override
    public void put(Bitmap bitmap) {
        Key key = this.keyPool.get(bitmap.getWidth(), bitmap.getHeight(), bitmap.getConfig());
        this.groupedMap.put(key, bitmap);
    }

    @Override
    public Bitmap get(int width, int height, Bitmap.Config config) {
        Key key = this.keyPool.get(width, height, config);
        return this.groupedMap.get(key);
    }

    @Override
    public Bitmap removeLast() {
        return this.groupedMap.removeLast();
    }

    @Override
    public String logBitmap(Bitmap bitmap) {
        return AttributeStrategy.getBitmapString(bitmap);
    }

    @Override
    public String logBitmap(int width, int height, Bitmap.Config config) {
        return AttributeStrategy.getBitmapString(width, height, config);
    }

    @Override
    public int getSize(Bitmap bitmap) {
        return Util.getBitmapByteSize((Bitmap)bitmap);
    }

    public String toString() {
        return "AttributeStrategy:\n  " + this.groupedMap;
    }

    private static String getBitmapString(Bitmap bitmap) {
        return AttributeStrategy.getBitmapString(bitmap.getWidth(), bitmap.getHeight(), bitmap.getConfig());
    }

    private static String getBitmapString(int width, int height, Bitmap.Config config) {
        return "[" + width + "x" + height + "], " + config;
    }

    static class Key
    implements Poolable {
        private final KeyPool pool;
        private int width;
        private int height;
        private Bitmap.Config config;

        public Key(KeyPool pool) {
            this.pool = pool;
        }

        public void init(int width, int height, Bitmap.Config config) {
            this.width = width;
            this.height = height;
            this.config = config;
        }

        public boolean equals(Object o) {
            if (o instanceof Key) {
                Key other = (Key)o;
                return this.width == other.width && this.height == other.height && this.config == other.config;
            }
            return false;
        }

        public int hashCode() {
            int result = this.width;
            result = 31 * result + this.height;
            result = 31 * result + (this.config != null ? this.config.hashCode() : 0);
            return result;
        }

        public String toString() {
            return AttributeStrategy.getBitmapString(this.width, this.height, this.config);
        }

        @Override
        public void offer() {
            this.pool.offer(this);
        }
    }

    static class KeyPool
    extends BaseKeyPool<Key> {
        KeyPool() {
        }

        public Key get(int width, int height, Bitmap.Config config) {
            Key result = (Key)this.get();
            result.init(width, height, config);
            return result;
        }

        @Override
        protected Key create() {
            return new Key(this);
        }
    }
}

