/*
 * Decompiled with CFR 0.152.
 */
package com.cache;

import android.content.Context;
import android.os.Environment;
import java.io.File;

class FileCache {
    private File cacheDir;

    FileCache(Context context) {
        this.cacheDir = Environment.getExternalStorageState().equals("mounted") ? new File(Environment.getExternalStorageDirectory(), "MultiImagePicker") : context.getCacheDir();
        if (!this.cacheDir.exists()) {
            this.cacheDir.mkdirs();
        }
    }

    public File getFile(String url, String prefix) {
        String filename = String.valueOf(url.hashCode());
        return new File(this.cacheDir, prefix + filename);
    }

    public void clear() {
        File[] files = this.cacheDir.listFiles();
        if (files == null) {
            return;
        }
        for (File f : files) {
            f.delete();
        }
    }
}

