/*
 * Decompiled with CFR 0.152.
 */
package com.rahul.media.videomodule;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.database.Cursor;
import android.net.Uri;
import android.os.AsyncTask;
import android.os.Build;
import android.os.Bundle;
import android.provider.MediaStore;
import android.support.v7.app.AppCompatActivity;
import android.support.v7.widget.GridLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.support.v7.widget.Toolbar;
import android.util.Log;
import android.view.MenuItem;
import android.widget.RelativeLayout;
import android.widget.Toast;
import com.msupport.MSupport;
import com.rahul.media.R;
import com.rahul.media.model.Define;
import com.rahul.media.model.GalleryPhotoAlbum;
import com.rahul.media.utils.ItemOffsetDecoration;
import com.rahul.media.utils.MeasureUtils;
import com.rahul.media.videomodule.VideoAlbumGalleryActivity;
import com.rahul.media.videomodule.adapter.VideoAlbumListAdapter;
import java.util.ArrayList;

public class VideoAlbumActivity
extends AppCompatActivity {
    private RecyclerView recyclerView;
    private RelativeLayout noAlbum;
    private ArrayList<GalleryPhotoAlbum> arrayListAlbums = new ArrayList();
    private int pickCount;

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.activity_photo_album);
        this.pickCount = this.getIntent().getIntExtra("pickCount", 1);
        Toolbar toolbar = (Toolbar)this.findViewById(R.id.toolbar);
        this.noAlbum = (RelativeLayout)this.findViewById(R.id.no_album);
        this.setSupportActionBar(toolbar);
        toolbar.setBackgroundColor(Define.ACTIONBAR_COLOR);
        this.getSupportActionBar().setDisplayHomeAsUpEnabled(true);
        this.recyclerView = (RecyclerView)this.findViewById(R.id.recyclerview);
        this.recyclerView.setLayoutManager((RecyclerView.LayoutManager)new GridLayoutManager((Context)this, MeasureUtils.getAlbumsColumns(this.getApplicationContext())));
        this.recyclerView.addItemDecoration((RecyclerView.ItemDecoration)new ItemOffsetDecoration(4));
        if (Build.VERSION.SDK_INT >= 23) {
            boolean isStoragePermissionGiven = MSupport.checkPermissionWithRationale((Activity)this, null, "android.permission.WRITE_EXTERNAL_STORAGE", 2);
            if (isStoragePermissionGiven) {
                new GetVideoListAsync().execute(new Void[0]);
            }
        } else {
            new GetVideoListAsync().execute(new Void[0]);
        }
    }

    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        if (requestCode == Define.ENTER_ALBUM_REQUEST_CODE && resultCode == -1) {
            this.setResult(-1, data);
            this.finish();
        }
    }

    public void onRequestPermissionsResult(int requestCode, String[] permissions, int[] grantResults) {
        switch (requestCode) {
            case 2: {
                if (grantResults[0] == 0) {
                    new GetVideoListAsync().execute(new Void[0]);
                    break;
                }
                Toast.makeText((Context)this, (CharSequence)"Storage permission not granted", (int)0).show();
                this.finish();
            }
        }
    }

    private void getVideoList() {
        String[] PROJECTION_BUCKET = new String[]{"bucket_id", "bucket_display_name", "datetaken", "_data"};
        String BUCKET_GROUP_BY = "1) GROUP BY 1,(2";
        String BUCKET_ORDER_BY = "MAX(datetaken) DESC";
        Uri images = MediaStore.Video.Media.EXTERNAL_CONTENT_URI;
        Cursor cur = this.getContentResolver().query(images, PROJECTION_BUCKET, BUCKET_GROUP_BY, null, BUCKET_ORDER_BY);
        Log.v((String)"ListingImages", (String)(" query count=" + cur.getCount()));
        if (cur.moveToFirst()) {
            int bucketColumn = cur.getColumnIndex("bucket_display_name");
            int dateColumn = cur.getColumnIndex("datetaken");
            int dataColumn = cur.getColumnIndex("_data");
            int bucketIdColumn = cur.getColumnIndex("bucket_id");
            do {
                String bucket = cur.getString(bucketColumn);
                String date = cur.getString(dateColumn);
                String data = cur.getString(dataColumn);
                long bucketId = cur.getInt(bucketIdColumn);
                if (bucket == null || bucket.length() <= 0) continue;
                GalleryPhotoAlbum album = new GalleryPhotoAlbum();
                album.setBucketId(bucketId);
                album.setBucketName(bucket);
                album.setDateTaken(date);
                album.setData(data);
                this.videoCountByAlbum(album);
                this.arrayListAlbums.add(album);
                Log.v((String)"ListingImages", (String)(" bucket=" + bucket + "  date_taken=" + date + "  _data=" + data + " bucket_id=" + bucketId));
            } while (cur.moveToNext());
        }
        cur.close();
    }

    private void videoCountByAlbum(GalleryPhotoAlbum bucketName) {
        try {
            String orderBy = "datetaken";
            String searchParams = null;
            String bucket = bucketName.getBucketName();
            searchParams = "bucket_display_name = \"" + bucket + "\"";
            Cursor mVideoCursor = this.getContentResolver().query(MediaStore.Video.Media.EXTERNAL_CONTENT_URI, null, searchParams, null, "datetaken DESC");
            if (mVideoCursor != null && mVideoCursor.moveToFirst()) {
                String filePath = mVideoCursor.getString(mVideoCursor.getColumnIndex("_data"));
                bucketName.setTotalCount(mVideoCursor.getCount());
                bucketName.setFilePath(filePath);
                return;
            }
            mVideoCursor.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public boolean onOptionsItemSelected(MenuItem item) {
        switch (item.getItemId()) {
            case 16908332: {
                this.finish();
            }
        }
        return super.onOptionsItemSelected(item);
    }

    private class GetVideoListAsync
    extends AsyncTask<Void, Void, Boolean> {
        private GetVideoListAsync() {
        }

        protected Boolean doInBackground(Void ... params) {
            VideoAlbumActivity.this.arrayListAlbums.clear();
            VideoAlbumActivity.this.getVideoList();
            return !VideoAlbumActivity.this.arrayListAlbums.isEmpty();
        }

        protected void onPostExecute(Boolean result) {
            super.onPostExecute((Object)result);
            if (result.booleanValue()) {
                VideoAlbumActivity.this.noAlbum.setVisibility(8);
                VideoAlbumListAdapter galleryAlbumAdapter = new VideoAlbumListAdapter((Context)VideoAlbumActivity.this, VideoAlbumActivity.this.arrayListAlbums){

                    @Override
                    public void onItemClick(VideoAlbumListAdapter.ViewHolder holder) {
                        Intent intent = new Intent((Context)VideoAlbumActivity.this, VideoAlbumGalleryActivity.class);
                        intent.putExtra("bucketName", ((GalleryPhotoAlbum)VideoAlbumActivity.this.arrayListAlbums.get(holder.getAdapterPosition())).getBucketName());
                        intent.putExtra("pickCount", VideoAlbumActivity.this.pickCount);
                        VideoAlbumActivity.this.startActivityForResult(intent, Define.ENTER_ALBUM_REQUEST_CODE);
                    }
                };
                VideoAlbumActivity.this.recyclerView.setAdapter((RecyclerView.Adapter)galleryAlbumAdapter);
            } else {
                VideoAlbumActivity.this.noAlbum.setVisibility(0);
            }
        }
    }
}

