/*
 * Decompiled with CFR 0.152.
 */
package com.glidepool;

import android.graphics.Bitmap;
import android.os.Build;
import com.glidepool.BitmapPool;
import com.glidepool.BitmapPoolAdapter;
import com.glidepool.LruBitmapPool;
import java.util.Set;

public class GlideBitmapPool {
    private static final int DEFAULT_MAX_SIZE = 0x600000;
    private BitmapPool bitmapPool;
    private static GlideBitmapPool sInstance;

    private GlideBitmapPool(int maxSize) {
        this.bitmapPool = Build.VERSION.SDK_INT >= 11 ? new LruBitmapPool(maxSize) : new BitmapPoolAdapter();
    }

    private GlideBitmapPool(int maxSize, Set<Bitmap.Config> allowedConfigs) {
        this.bitmapPool = Build.VERSION.SDK_INT >= 11 ? new LruBitmapPool(maxSize, allowedConfigs) : new BitmapPoolAdapter();
    }

    private static GlideBitmapPool getInstance() {
        if (sInstance == null) {
            sInstance = new GlideBitmapPool(0x600000);
        }
        return sInstance;
    }

    public static void initialize(int maxSize) {
        sInstance = new GlideBitmapPool(maxSize);
    }

    public static void initialize(int maxSize, Set<Bitmap.Config> allowedConfigs) {
        sInstance = new GlideBitmapPool(maxSize, allowedConfigs);
    }

    public static void putBitmap(Bitmap bitmap) {
        GlideBitmapPool.getInstance().bitmapPool.put(bitmap);
    }

    public static Bitmap getBitmap(int width, int height, Bitmap.Config config) {
        return GlideBitmapPool.getInstance().bitmapPool.get(width, height, config);
    }

    public static Bitmap getDirtyBitmap(int width, int height, Bitmap.Config config) {
        return GlideBitmapPool.getInstance().bitmapPool.getDirty(width, height, config);
    }

    public static void clearMemory() {
        GlideBitmapPool.getInstance().bitmapPool.clearMemory();
    }

    public static void trimMemory(int level) {
        GlideBitmapPool.getInstance().bitmapPool.trimMemory(level);
    }

    public static void shutDown() {
        if (sInstance != null) {
            GlideBitmapPool.sInstance.bitmapPool.clearMemory();
            sInstance = null;
        }
    }
}

