/*
 * Decompiled with CFR 0.152.
 */
package com.rahul.media.utils;

import android.content.Context;
import android.graphics.Bitmap;
import android.media.MediaMetadataRetriever;
import android.media.ThumbnailUtils;
import android.net.Uri;
import android.os.AsyncTask;
import android.util.Log;
import android.widget.ImageView;
import android.widget.TextView;
import com.nostra13.universalimageloader.core.ImageLoader;
import com.nostra13.universalimageloader.core.ImageLoaderConfiguration;
import com.nostra13.universalimageloader.core.imageaware.ImageAware;
import com.nostra13.universalimageloader.core.imageaware.ImageViewAware;
import com.rahul.media.R;
import com.rahul.media.model.MediaType;
import com.rahul.media.utils.ImageOption;
import java.io.File;

public class ProcessGalleryFile
extends AsyncTask<Void, Void, Bitmap> {
    private static int WIDTH = 80;
    private static int HEIGHT = 80;
    ImageView photoHolder;
    TextView durationHolder;
    MediaType type;
    String filePath;
    MediaMetadataRetriever retriever = new MediaMetadataRetriever();

    public ProcessGalleryFile(ImageView photoHolder, TextView durationHolder, String filePath, MediaType type) {
        HEIGHT = WIDTH = (int)photoHolder.getContext().getResources().getDimension(R.dimen.thumbnail_width);
        this.filePath = filePath;
        this.durationHolder = durationHolder;
        this.photoHolder = photoHolder;
        this.type = type;
        try {
            ImageLoader.getInstance().init(ImageLoaderConfiguration.createDefault((Context)photoHolder.getContext()));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected Bitmap doInBackground(Void ... params) {
        Bitmap bmp = null;
        Log.d((String)((Object)((Object)this)).getClass().getSimpleName(), (String)("" + Thread.getAllStackTraces().keySet().size()));
        if (this.type != MediaType.PHOTO) {
            try {
                bmp = ImageLoader.getInstance().getMemoryCache().get(Uri.fromFile((File)new File(this.filePath)).toString() + "_");
            }
            catch (Exception e) {
                Log.e((String)ProcessGalleryFile.class.getSimpleName(), (String)("" + e));
            }
            if (bmp == null) {
                try {
                    bmp = ThumbnailUtils.createVideoThumbnail((String)this.filePath, (int)1);
                    if (bmp != null) {
                        ImageLoader.getInstance().getMemoryCache().put(Uri.fromFile((File)new File(this.filePath)).toString() + "_", bmp);
                    }
                }
                catch (Exception e) {
                    Log.e((String)((Object)((Object)this)).getClass().getSimpleName(), (String)"Exception when rotating thumbnail for gallery", (Throwable)e);
                }
                catch (OutOfMemoryError e) {
                    Log.e((String)ProcessGalleryFile.class.getSimpleName(), (String)("" + e));
                }
            }
        }
        return bmp;
    }

    protected void onPostExecute(Bitmap result) {
        super.onPostExecute((Object)result);
        if (this.type == MediaType.PHOTO) {
            this.durationHolder.setVisibility(8);
            ImageViewAware aware = new ImageViewAware(this.photoHolder){

                public int getWidth() {
                    return WIDTH;
                }

                public int getHeight() {
                    return HEIGHT;
                }
            };
            ImageLoader.getInstance().displayImage(Uri.fromFile((File)new File(this.filePath)).toString(), (ImageAware)aware, ImageOption.GALLERY_OPTIONS.getDisplayImageOptions());
        } else {
            this.durationHolder.setText((CharSequence)ProcessGalleryFile.getDurationMark(this.filePath, this.retriever));
            this.durationHolder.setVisibility(0);
            this.photoHolder.setImageBitmap(result);
        }
    }

    public static String getDurationMark(String filePath, MediaMetadataRetriever retriever) {
        try {
            retriever.setDataSource(filePath);
        }
        catch (Exception e) {
            Log.e((String)"getDurationMark", (String)e.toString());
            return "?:??";
        }
        String time = null;
        try {
            Log.e((String)"file", (String)filePath);
            time = retriever.extractMetadata(9);
        }
        catch (Exception ex) {
            Log.e((String)"getDurationMark", (String)ex.toString());
        }
        time = time == null ? "0" : (time.isEmpty() ? "0" : time);
        int timeInMillis = Integer.parseInt(time);
        int duration = timeInMillis / 1000;
        int hours = duration / 3600;
        int minutes = duration % 3600 / 60;
        int seconds = duration % 60;
        StringBuilder sb = new StringBuilder();
        if (hours > 0) {
            sb.append(hours).append(":");
        }
        if (minutes < 10) {
            sb.append("0").append(minutes);
        } else {
            sb.append(minutes);
        }
        sb.append(":");
        if (seconds < 10) {
            sb.append("0").append(seconds);
        } else {
            sb.append(seconds);
        }
        return sb.toString();
    }

    public int hashCode() {
        return this.filePath != null ? this.filePath.hashCode() : super.hashCode();
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof ProcessGalleryFile)) {
            return false;
        }
        ProcessGalleryFile file = (ProcessGalleryFile)((Object)o);
        return this.filePath != null && file.filePath != null && this.filePath.equals(file.filePath);
    }
}

