/*
 * Decompiled with CFR 0.152.
 */
package com.rahul.media.adapters;

import android.content.Context;
import android.net.Uri;
import android.support.v7.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AdapterView;
import android.widget.ImageView;
import com.bumptech.glide.Glide;
import com.bumptech.glide.load.engine.DiskCacheStrategy;
import com.rahul.media.R;
import com.rahul.media.model.CustomGallery;
import com.rahul.media.utils.MediaSingleTon;
import com.rahul.media.utils.MediaUtility;
import com.rahul.media.utils.SquareImageView;
import java.util.ArrayList;
import java.util.HashMap;

public class ImageListRecycleAdapter
extends RecyclerView.Adapter<VerticalItemHolder> {
    public ArrayList<CustomGallery> mItems;
    private AdapterView.OnItemClickListener mOnItemClickListener;

    public ImageListRecycleAdapter(Context context, HashMap<String, CustomGallery> imagesUri) {
        this.mItems = new ArrayList<CustomGallery>(imagesUri.values());
    }

    public void removeItem(int position) {
        if (position >= this.mItems.size()) {
            return;
        }
        this.mItems.remove(position);
        this.notifyItemRemoved(position);
    }

    public void customNotify(HashMap<String, CustomGallery> dataT) {
        this.mItems.clear();
        ArrayList<CustomGallery> dataT2 = new ArrayList<CustomGallery>(dataT.values());
        this.mItems.addAll(dataT2);
        this.notifyDataSetChanged();
    }

    public VerticalItemHolder onCreateViewHolder(ViewGroup container, int viewType) {
        LayoutInflater inflater = LayoutInflater.from((Context)container.getContext());
        View root = inflater.inflate(R.layout.image_strip_view, container, false);
        return new VerticalItemHolder(root, this);
    }

    public void onBindViewHolder(VerticalItemHolder itemHolder, int position) {
        CustomGallery item = this.mItems.get(position);
        itemHolder.setImage(item.sdcardPath);
    }

    public int getItemCount() {
        return this.mItems.size();
    }

    public void setOnItemClickListener(AdapterView.OnItemClickListener onItemClickListener) {
        this.mOnItemClickListener = onItemClickListener;
    }

    private void onItemHolderClick(VerticalItemHolder itemHolder) {
        if (this.mOnItemClickListener != null) {
            this.mOnItemClickListener.onItemClick(null, itemHolder.itemView, itemHolder.getAdapterPosition(), itemHolder.getItemId());
        }
    }

    class VerticalItemHolder
    extends RecyclerView.ViewHolder
    implements View.OnClickListener {
        private SquareImageView imageView;
        private ImageListRecycleAdapter mAdapter;

        VerticalItemHolder(View itemView, ImageListRecycleAdapter adapter) {
            super(itemView);
            itemView.setOnClickListener((View.OnClickListener)this);
            this.mAdapter = adapter;
            this.imageView = (SquareImageView)itemView.findViewById(R.id.strip_image);
        }

        public void onClick(View v) {
            this.mAdapter.onItemHolderClick(this);
        }

        public void setImage(String thumbPath) {
            Context mContext = this.imageView.getContext();
            byte[] imageByte = MediaSingleTon.getInstance().getImageByte(thumbPath);
            if (imageByte != null) {
                Glide.with((Context)mContext).load(imageByte).centerCrop().diskCacheStrategy(DiskCacheStrategy.RESULT).override(200, 200).into((ImageView)this.imageView);
            } else {
                byte[] thumbnail = MediaUtility.getThumbnail(thumbPath);
                if (thumbnail != null) {
                    MediaSingleTon.getInstance().putImageByte(thumbPath, thumbnail);
                    Glide.with((Context)mContext).load(thumbnail).centerCrop().diskCacheStrategy(DiskCacheStrategy.RESULT).override(200, 200).into((ImageView)this.imageView);
                } else {
                    Glide.with((Context)mContext).load(Uri.parse((String)("file://" + thumbPath))).asBitmap().diskCacheStrategy(DiskCacheStrategy.RESULT).override(200, 200).centerCrop().into((ImageView)this.imageView);
                }
            }
        }
    }
}

