/*
 * Decompiled with CFR 0.152.
 */
package com.cache;

import android.content.Context;
import android.net.Uri;
import android.os.Handler;
import android.util.Log;
import android.widget.ImageView;
import com.bumptech.glide.Glide;
import com.bumptech.glide.load.engine.DiskCacheStrategy;
import com.cache.FileCache;
import com.cache.MemoryCache;
import com.rahul.media.R;
import com.rahul.media.utils.MediaUtility;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class ByteImageLoader {
    private MemoryCache memoryCache = new MemoryCache();
    private FileCache fileCache;
    private Map<ImageView, String> imageViews = Collections.synchronizedMap(new WeakHashMap());
    private ExecutorService executorService;
    private Handler handler = new Handler();
    private final int stub_id = R.drawable.ic_empty_amoled;

    public ByteImageLoader(Context context) {
        this.fileCache = new FileCache(context);
        this.executorService = Executors.newFixedThreadPool(5);
    }

    public void DisplayImage(String url, ImageView imageView) {
        this.imageViews.put(imageView, url);
        byte[] imageByte = this.memoryCache.get(url);
        if (imageByte != null) {
            Log.i((String)"ByteImageLoader", (String)"Load from byte");
            Glide.with((Context)imageView.getContext()).load(imageByte).centerCrop().diskCacheStrategy(DiskCacheStrategy.RESULT).into(imageView);
        } else {
            this.queuePhoto(url, imageView);
            imageView.setImageResource(this.stub_id);
        }
    }

    private void queuePhoto(String url, ImageView imageView) {
        PhotoToLoad p = new PhotoToLoad(url, imageView);
        this.executorService.submit(new PhotosLoader(p));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] getBitmap(String url) {
        File f = this.fileCache.getFile(url);
        FileInputStream fin = null;
        try {
            fin = new FileInputStream(f);
            byte[] fileContent = new byte[(int)f.length()];
            fin.read(fileContent);
            Log.i((String)"ByteImageLoader", (String)("Read file from cache :- " + f.getName()));
            byte[] byArray = fileContent;
            return byArray;
        }
        catch (FileNotFoundException e) {
            System.out.println("File not found" + e);
        }
        catch (IOException ioe) {
            System.out.println("Exception while reading file " + ioe);
        }
        catch (Exception ioe) {
            System.out.println("Other File Exception while reading file " + ioe);
        }
        finally {
            try {
                if (fin != null) {
                    fin.close();
                }
            }
            catch (IOException ioe) {
                System.out.println("Error while closing stream: " + ioe);
            }
        }
        try {
            byte[] thumbnail = MediaUtility.getThumbnail(url);
            if (thumbnail != null) {
                BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(f));
                bos.write(thumbnail);
                bos.flush();
                bos.close();
                Log.i((String)"ByteImageLoader", (String)("Write to file in cache :- " + f.getName()));
            }
            return thumbnail;
        }
        catch (Throwable ex) {
            ex.printStackTrace();
            if (ex instanceof OutOfMemoryError) {
                this.memoryCache.clear();
            }
            return null;
        }
    }

    private boolean imageViewReused(PhotoToLoad photoToLoad) {
        String tag = this.imageViews.get(photoToLoad.imageView);
        return tag == null || !tag.equals(photoToLoad.url);
    }

    public void clearCache() {
        this.memoryCache.clear();
        this.fileCache.clear();
    }

    private class BitmapDisplayer
    implements Runnable {
        byte[] bitmap;
        PhotoToLoad photoToLoad;

        BitmapDisplayer(byte[] b, PhotoToLoad p) {
            this.bitmap = b;
            this.photoToLoad = p;
        }

        @Override
        public void run() {
            if (ByteImageLoader.this.imageViewReused(this.photoToLoad)) {
                return;
            }
            if (this.bitmap != null) {
                Log.i((String)"ByteImageLoader", (String)"Load from byte");
                Glide.with((Context)this.photoToLoad.imageView.getContext()).load(this.bitmap).centerCrop().diskCacheStrategy(DiskCacheStrategy.RESULT).into(this.photoToLoad.imageView);
            } else {
                Log.i((String)"ByteImageLoader", (String)"Load from uri direct");
                Glide.with((Context)this.photoToLoad.imageView.getContext()).load(Uri.parse((String)("file://" + this.photoToLoad.url))).asBitmap().diskCacheStrategy(DiskCacheStrategy.RESULT).override(200, 200).centerCrop().into(this.photoToLoad.imageView);
            }
        }
    }

    private class PhotosLoader
    implements Runnable {
        PhotoToLoad photoToLoad;

        PhotosLoader(PhotoToLoad photoToLoad) {
            this.photoToLoad = photoToLoad;
        }

        @Override
        public void run() {
            try {
                if (ByteImageLoader.this.imageViewReused(this.photoToLoad)) {
                    return;
                }
                byte[] thumbnail = ByteImageLoader.this.getBitmap(this.photoToLoad.url);
                if (thumbnail != null) {
                    ByteImageLoader.this.memoryCache.put(this.photoToLoad.url, thumbnail);
                }
                BitmapDisplayer bd = new BitmapDisplayer(thumbnail, this.photoToLoad);
                ByteImageLoader.this.handler.post((Runnable)bd);
            }
            catch (Throwable th) {
                th.printStackTrace();
            }
        }
    }

    private class PhotoToLoad {
        String url;
        ImageView imageView;

        PhotoToLoad(String u, ImageView i) {
            this.url = u;
            this.imageView = i;
        }
    }
}

