/*
 * Decompiled with CFR 0.152.
 */
package com.rahul.media.activity;

import android.app.Activity;
import android.app.ProgressDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.net.Uri;
import android.os.AsyncTask;
import android.os.Bundle;
import android.support.v4.view.PagerAdapter;
import android.support.v4.view.ViewPager;
import android.support.v7.app.AlertDialog;
import android.support.v7.app.AppCompatActivity;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.support.v7.widget.Toolbar;
import android.view.LayoutInflater;
import android.view.Menu;
import android.view.MenuItem;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AdapterView;
import android.widget.ImageView;
import android.widget.LinearLayout;
import com.bumptech.glide.Glide;
import com.rahul.media.R;
import com.rahul.media.adapters.ImageListRecycleAdapter;
import com.rahul.media.imagemodule.ImageAlbumListActivity;
import com.rahul.media.model.CustomGallery;
import com.rahul.media.model.Define;
import com.rahul.media.utils.BitmapDecoder;
import com.rahul.media.utils.MediaUtility;
import com.rahul.media.utils.SquareImageView;
import com.rahul.media.utils.ViewPagerSwipeLess;
import crop.Crop;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;

public class MultipleImagePreviewActivity
extends AppCompatActivity {
    private static final int PICK_IMAGE = 200;
    private AlertDialog alertDialog;
    private ViewPagerSwipeLess mPager;
    private HashMap<String, CustomGallery> dataT;
    private CustomPagerAdapter adapter;
    private ImageListRecycleAdapter mImageListAdapter;
    private boolean isCrop;
    private int pickCount;

    public void showAlertDialog(Context mContext, String text) {
        this.alertDialog = new AlertDialog.Builder(mContext).setMessage((CharSequence)text).setCancelable(false).setPositiveButton((CharSequence)"OK", new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                MultipleImagePreviewActivity.this.alertDialog.dismiss();
            }
        }).create();
        this.alertDialog.show();
    }

    public void onBackPressed() {
        Intent data2 = new Intent();
        this.setResult(0, data2);
        super.onBackPressed();
    }

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.activity_multiimage_preview);
        this.mPager = (ViewPagerSwipeLess)this.findViewById(R.id.pager);
        Toolbar toolbar = (Toolbar)this.findViewById(R.id.toolbar);
        this.setSupportActionBar(toolbar);
        toolbar.setBackgroundColor(Define.ACTIONBAR_COLOR);
        this.getSupportActionBar().setDisplayHomeAsUpEnabled(true);
        this.dataT = new HashMap();
        this.adapter = new CustomPagerAdapter(this.dataT);
        this.mPager.setAdapter(this.adapter);
        this.mPager.addOnPageChangeListener(new ViewPager.OnPageChangeListener(){

            public void onPageScrolled(int position, float positionOffset, int positionOffsetPixels) {
            }

            public void onPageSelected(int position) {
            }

            public void onPageScrollStateChanged(int state) {
            }
        });
        this.mImageListAdapter = new ImageListRecycleAdapter((Context)this, this.dataT);
        RecyclerView mRecycleView = (RecyclerView)this.findViewById(R.id.image_hlistview);
        mRecycleView.setLayoutManager((RecyclerView.LayoutManager)new LinearLayoutManager((Context)this, 0, false));
        mRecycleView.setAdapter((RecyclerView.Adapter)this.mImageListAdapter);
        this.mImageListAdapter.setOnItemClickListener(new AdapterView.OnItemClickListener(){

            public void onItemClick(AdapterView<?> parent, View view, int position, long id2) {
                MultipleImagePreviewActivity.this.mPager.setCurrentItem(position);
            }
        });
        try {
            this.isCrop = this.getIntent().getExtras().getBoolean("crop");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (this.getIntent().getExtras().containsKey("pickCount")) {
            this.pickCount = this.getIntent().getIntExtra("pickCount", 1);
        }
        this.openGallery();
    }

    private void openGallery() {
        Intent i = new Intent((Context)this, ImageAlbumListActivity.class);
        i.putExtra("pickCount", this.pickCount);
        this.startActivityForResult(i, 200);
    }

    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        if (resultCode == -1) {
            if (requestCode == 200) {
                ArrayList allPath = data.getStringArrayListExtra("all_path");
                if (allPath != null && !allPath.isEmpty()) {
                    if (this.pickCount == 1) {
                        this.dataT.clear();
                        new ProcessAllImages(allPath).execute(new Void[0]);
                    } else {
                        new ProcessAllImages(allPath).execute(new Void[0]);
                    }
                }
            } else if (requestCode == 6709) {
                try {
                    Uri mTargetImageUri = (Uri)data.getExtras().get("output");
                    if (mTargetImageUri != null) {
                        String imagePath = this.mImageListAdapter.mItems.get((int)this.mPager.getCurrentItem()).sdcardPath;
                        CustomGallery item = new CustomGallery();
                        item.sdcardPath = mTargetImageUri.getPath();
                        item.sdCardUri = mTargetImageUri;
                        this.dataT.remove(imagePath);
                        this.dataT.put(mTargetImageUri.getPath(), item);
                        this.adapter.customNotify(this.dataT);
                        this.mImageListAdapter.customNotify(this.dataT);
                    }
                }
                catch (Exception e) {
                    String invalidImageText = (String)data.getExtras().get("invalid_image");
                    if (invalidImageText != null) {
                        this.showAlertDialog((Context)this, invalidImageText);
                    }
                }
            }
        } else if (this.dataT == null || this.dataT.size() <= 0) {
            Intent data2 = new Intent();
            this.setResult(0, data2);
            this.finish();
        }
    }

    public boolean onCreateOptionsMenu(Menu menu2) {
        this.getMenuInflater().inflate(R.menu.menu_camera, menu2);
        menu2.findItem(R.id.action_crop).setVisible(this.isCrop);
        return true;
    }

    public boolean onOptionsItemSelected(MenuItem item) {
        int id2 = item.getItemId();
        if (id2 == R.id.action_ok) {
            ArrayList<CustomGallery> mArrayList = new ArrayList<CustomGallery>(this.dataT.values());
            if (mArrayList.size() > 0) {
                ArrayList<String> allPath = new ArrayList<String>();
                for (int i = 0; i < mArrayList.size(); ++i) {
                    allPath.add(mArrayList.get((int)i).sdcardPath);
                }
                Intent data = new Intent().putStringArrayListExtra("all_path", allPath);
                this.setResult(-1, data);
                this.finish();
            }
        } else if (id2 == 16908332) {
            Intent data = new Intent();
            this.setResult(0, data);
            this.finish();
        } else if (id2 == R.id.action_camera) {
            this.openGallery();
        } else if (id2 == R.id.action_crop && this.adapter != null && this.adapter.getCount() > 0) {
            String imagePath = this.mImageListAdapter.mItems.get((int)this.mPager.getCurrentItem()).sdcardPath;
            Uri destination = null;
            try {
                destination = MediaUtility.createImageFile((Context)this);
                Crop.of(Uri.parse((String)("file://" + imagePath)), destination).asSquare().start((Activity)this);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return super.onOptionsItemSelected(item);
    }

    private class CustomPagerAdapter
    extends PagerAdapter {
        LayoutInflater mLayoutInflater;
        ArrayList<CustomGallery> dataT;

        CustomPagerAdapter(HashMap<String, CustomGallery> dataT) {
            this.dataT = new ArrayList<CustomGallery>(dataT.values());
            this.mLayoutInflater = (LayoutInflater)MultipleImagePreviewActivity.this.getSystemService("layout_inflater");
        }

        void customNotify(HashMap<String, CustomGallery> dataHashmap) {
            this.dataT.clear();
            ArrayList<CustomGallery> dataT2 = new ArrayList<CustomGallery>(dataHashmap.values());
            this.dataT.addAll(dataT2);
            this.notifyDataSetChanged();
        }

        public int getCount() {
            return this.dataT.size();
        }

        public boolean isViewFromObject(View view, Object object) {
            return view == object;
        }

        public int getItemPosition(Object object) {
            return -2;
        }

        public Object instantiateItem(ViewGroup container, int position) {
            View itemView = this.mLayoutInflater.inflate(R.layout.image_pager_item, container, false);
            SquareImageView imageView = (SquareImageView)itemView.findViewById(R.id.full_screen_image);
            Glide.with((Context)imageView.getContext()).load("file://" + this.dataT.get((int)position).sdcardPath).asBitmap().into((ImageView)imageView);
            container.addView(itemView);
            return itemView;
        }

        public void destroyItem(ViewGroup container, int position, Object object) {
            container.removeView((View)((LinearLayout)object));
        }
    }

    private class ProcessAllImages
    extends AsyncTask<Void, Void, Void> {
        private ArrayList<String> stringArrayList;
        private ProgressDialog mProgressDialog;

        ProcessAllImages(ArrayList<String> stringArrayList) {
            this.stringArrayList = stringArrayList;
        }

        protected void onPreExecute() {
            super.onPreExecute();
            this.mProgressDialog = new ProgressDialog((Context)MultipleImagePreviewActivity.this);
            this.mProgressDialog.setMessage((CharSequence)"Processing images ...");
            this.mProgressDialog.setCancelable(false);
            this.mProgressDialog.setCanceledOnTouchOutside(false);
            this.mProgressDialog.show();
        }

        protected Void doInBackground(Void ... params) {
            for (int i = 0; i < this.stringArrayList.size(); ++i) {
                CustomGallery item = new CustomGallery();
                item.sdcardPath = this.stringArrayList.get(i);
                item.sdCardUri = Uri.parse((String)this.stringArrayList.get(i));
                item.sdcardPath = BitmapDecoder.getBitmap(this.stringArrayList.get(i), (Context)MultipleImagePreviewActivity.this);
                item.sdCardUri = Uri.parse((String)item.sdcardPath);
                MultipleImagePreviewActivity.this.dataT.put(item.sdcardPath, item);
            }
            return null;
        }

        protected void onPostExecute(Void aVoid) {
            super.onPostExecute((Object)aVoid);
            this.mProgressDialog.dismiss();
            MultipleImagePreviewActivity.this.adapter.customNotify(MultipleImagePreviewActivity.this.dataT);
            MultipleImagePreviewActivity.this.mImageListAdapter.customNotify(MultipleImagePreviewActivity.this.dataT);
        }
    }
}

