/*
 * Decompiled with CFR 0.152.
 */
package com.cache;

import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.util.Log;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;

class MemoryCache {
    private static final String TAG = "MemoryCache";
    private Map<String, byte[]> cache = Collections.synchronizedMap(new LinkedHashMap(10, 1.5f, true));
    private long size = 0L;
    private long limit = 1000000L;

    MemoryCache() {
        this.setLimit(Runtime.getRuntime().maxMemory() / 4L);
    }

    private void setLimit(long new_limit) {
        this.limit = new_limit;
        Log.i((String)TAG, (String)("MemoryCache will use up to " + (double)this.limit / 1024.0 / 1024.0 + "MB"));
    }

    public byte[] get(String id) {
        try {
            if (!this.cache.containsKey(id)) {
                return null;
            }
            return this.cache.get(id);
        }
        catch (NullPointerException ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public void put(String id, byte[] bitmap) {
        try {
            if (this.cache.containsKey(id)) {
                this.size -= this.getSizeInBytes(this.cache.get(id));
            }
            this.cache.put(id, bitmap);
            this.size += this.getSizeInBytes(bitmap);
            this.checkSize();
        }
        catch (Throwable th) {
            th.printStackTrace();
        }
    }

    private void checkSize() {
        Log.i((String)TAG, (String)("cache size=" + this.size + " length=" + this.cache.size()));
        if (this.size > this.limit) {
            Iterator<Map.Entry<String, byte[]>> iter = this.cache.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry<String, byte[]> entry = iter.next();
                this.size -= this.getSizeInBytes(entry.getValue());
                iter.remove();
                if (this.size > this.limit) continue;
                break;
            }
            Log.i((String)TAG, (String)("Clean cache. New size " + this.cache.size()));
        }
    }

    public void clear() {
        try {
            this.cache.clear();
            this.size = 0L;
        }
        catch (NullPointerException ex) {
            ex.printStackTrace();
        }
    }

    private long getSizeInBytes(byte[] imageData) {
        Bitmap bitmap = BitmapFactory.decodeByteArray((byte[])imageData, (int)0, (int)imageData.length);
        if (bitmap == null) {
            return 0L;
        }
        int i = bitmap.getRowBytes() * bitmap.getHeight();
        bitmap.recycle();
        bitmap = null;
        return i;
    }
}

