/*
 * Decompiled with CFR 0.152.
 */
package com.rahul.media.utils;

import android.content.Context;
import android.net.Uri;
import android.os.Environment;
import android.util.Log;
import com.rahul.media.activity.CameraPickActivity;
import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;

public class MediaUtility {
    public static String getUserImageDir(Context mContext) {
        return Environment.getExternalStorageDirectory().getAbsolutePath() + "/MultipleImageCache/data/" + mContext.getPackageName() + "/images";
    }

    public static File initializeImageLoader(Context mContext) {
        File cacheDir = new File(MediaUtility.getUserImageDir(mContext));
        if (!cacheDir.exists()) {
            cacheDir.mkdirs();
        }
        return cacheDir;
    }

    public static Uri createImageFile(Context mContext) throws IOException {
        File image = null;
        String timeStamp = new SimpleDateFormat("yyyyMMdd_HHmmss").format(new Date());
        String imageFileName = "JPEG_" + timeStamp + "_";
        if ("mounted".equals(Environment.getExternalStorageState())) {
            File storageDir = Environment.getExternalStoragePublicDirectory((String)Environment.DIRECTORY_PICTURES);
            image = File.createTempFile(imageFileName, ".jpg", storageDir);
        } else {
            File storageDir = mContext.getFilesDir();
            image = File.createTempFile(imageFileName, ".jpg", storageDir);
        }
        Log.d((String)CameraPickActivity.class.getSimpleName(), (String)("file:" + image.getAbsolutePath()));
        return Uri.fromFile((File)image);
    }
}

