/*
 * Decompiled with CFR 0.152.
 */
package com.rahul.media.main;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import com.rahul.media.activity.CameraPickActivity;
import com.rahul.media.activity.MultipleImagePreviewActivity;
import com.rahul.media.activity.VideoPickActivity;
import com.rahul.media.model.VideoQuality;
import com.rahul.media.utils.MediaSingleTon;
import com.rahul.media.utils.MediaUtility;
import java.util.ArrayList;

public class MediaFactory {
    private static final int MEDIA_REQUEST_CODE = 222;
    private static MediaFactory mMediaFactory;

    private MediaFactory() {
    }

    public static synchronized MediaFactory create() {
        if (mMediaFactory == null) {
            mMediaFactory = new MediaFactory();
        }
        return mMediaFactory;
    }

    public void clearCache(Context context) {
        try {
            MediaUtility.initializeImageLoader(context).delete();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public MediaFactory start(MediaBuilder mediaBuilder) {
        MediaSingleTon.getInstance();
        Bundle bundle = new Bundle();
        if (mediaBuilder.takeVideo) {
            Intent intent = new Intent(mediaBuilder.mContext, VideoPickActivity.class);
            intent.putExtra("from", mediaBuilder.fromGallery);
            intent.putExtra("videoSize", mediaBuilder.videoSize);
            intent.putExtra("videoDuration", mediaBuilder.videoDuration);
            intent.putExtra("videoQuality", mediaBuilder.videoQuality.getQuality());
            intent.putExtra("pickCount", mediaBuilder.pickCount);
            ((Activity)mediaBuilder.mContext).startActivityForResult(intent, 222);
        } else {
            bundle.putBoolean("crop", mediaBuilder.isCrop);
            bundle.putInt("pickCount", mediaBuilder.pickCount);
            if (mediaBuilder.fromGallery) {
                Intent intent = new Intent(mediaBuilder.mContext, MultipleImagePreviewActivity.class);
                intent.putExtras(bundle);
                ((Activity)mediaBuilder.mContext).startActivityForResult(intent, 222);
            } else {
                Intent intent = new Intent(mediaBuilder.mContext, CameraPickActivity.class);
                intent.putExtras(bundle);
                ((Activity)mediaBuilder.mContext).startActivityForResult(intent, 222);
            }
        }
        return mMediaFactory;
    }

    public ArrayList<String> onActivityResult(int requestCode, int resultCode, Intent data) {
        ArrayList all_path = new ArrayList();
        if (resultCode == -1 && requestCode == 222) {
            all_path = data.getStringArrayListExtra("all_path");
        }
        return all_path;
    }

    public static class MediaBuilder {
        boolean isCrop = false;
        boolean fromGallery = true;
        boolean takeVideo = false;
        long videoSize = -1L;
        long videoDuration = -1L;
        private final Context mContext;
        private VideoQuality videoQuality = VideoQuality.HIGH_QUALITY;
        private int pickCount = 1;

        public MediaBuilder(Context mContext) {
            this.mContext = mContext;
        }

        public MediaBuilder takeVideo() {
            this.takeVideo = true;
            return this;
        }

        public MediaBuilder setVideoQuality(VideoQuality videoQuality) {
            this.videoQuality = videoQuality;
            return this;
        }

        public MediaBuilder setVideoSize(int size) {
            this.videoSize = (long)size * 1000000L;
            return this;
        }

        public MediaBuilder setVideoDuration(long seconds) {
            this.videoDuration = seconds;
            return this;
        }

        public MediaBuilder fromGallery() {
            this.fromGallery = true;
            return this;
        }

        public MediaBuilder fromCamera() {
            this.fromGallery = false;
            return this;
        }

        public MediaBuilder doCropping() {
            this.isCrop = true;
            return this;
        }

        public MediaBuilder setPickCount(int count) {
            if (count <= 0) {
                count = 1;
            }
            this.pickCount = count;
            return this;
        }
    }
}

