/*
 * Decompiled with CFR 0.152.
 */
package com.rahul.media.imagemodule.adapter;

import android.content.Context;
import android.graphics.BitmapFactory;
import android.net.Uri;
import android.support.v7.app.ActionBar;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import android.widget.CheckBox;
import android.widget.TextView;
import android.widget.Toast;
import com.facebook.drawee.view.SimpleDraweeView;
import com.nostra13.universalimageloader.core.DisplayImageOptions;
import com.nostra13.universalimageloader.core.ImageLoader;
import com.nostra13.universalimageloader.core.ImageLoaderConfiguration;
import com.rahul.media.R;
import com.rahul.media.model.MediaObject;
import java.util.ArrayList;
import java.util.HashSet;

public class ImageGalleryGridAdapter
extends BaseAdapter {
    private final ArrayList<MediaObject> mediaObjectArrayList;
    private final int pickCount;
    private final Context mContext;
    private final DisplayImageOptions options;
    String saveDir;
    ActionBar actionBar;
    private String bucketTitle;
    HashSet<Integer> selectedPositions = new HashSet();

    public ImageGalleryGridAdapter(Context context, ArrayList<MediaObject> pickedImageBeans, String saveDir, int pickCount, ActionBar supportActionBar, String bucketTitle) {
        this.mContext = context;
        this.mediaObjectArrayList = pickedImageBeans;
        this.saveDir = saveDir;
        this.pickCount = pickCount;
        this.actionBar = supportActionBar;
        this.bucketTitle = bucketTitle;
        ImageLoader.getInstance().init(ImageLoaderConfiguration.createDefault((Context)context));
        BitmapFactory.Options resizeOptions = new BitmapFactory.Options();
        resizeOptions.inSampleSize = 3;
        this.options = new DisplayImageOptions.Builder().cacheInMemory(true).showImageOnLoading(R.drawable.placeholder_470x352).showImageForEmptyUri(R.drawable.placeholder_470x352).showImageOnFail(R.drawable.placeholder_470x352).decodingOptions(resizeOptions).cacheOnDisk(true).build();
    }

    public int getCount() {
        return this.mediaObjectArrayList.size();
    }

    public Object getItem(int position) {
        return null;
    }

    public long getItemId(int position) {
        return 0L;
    }

    public View getView(final int position, View convertView, ViewGroup parent) {
        ViewHolder holder;
        if (convertView == null) {
            LayoutInflater vi = LayoutInflater.from((Context)this.mContext);
            holder = new ViewHolder();
            holder.position = position;
            convertView = vi.inflate(R.layout.list_image_item_gallery, null);
            holder.imgThumb = (SimpleDraweeView)convertView.findViewById(R.id.imgThumbnail);
            holder.videoDuration = (TextView)convertView.findViewById(R.id.txtDuration);
            holder.selectIv = (CheckBox)convertView.findViewById(R.id.imgQueueMultiSelected);
            convertView.setTag((Object)holder);
        } else {
            holder = (ViewHolder)convertView.getTag();
        }
        if (this.mediaObjectArrayList.get((int)position).isSelected) {
            this.selectedPositions.add(position);
        } else {
            this.selectedPositions.remove(position);
        }
        holder.imgThumb.setImageURI(Uri.parse((String)("file://" + this.mediaObjectArrayList.get(position).getPath())));
        holder.selectIv.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                ImageGalleryGridAdapter.this.performCheck(holder, position);
            }
        });
        convertView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                ImageGalleryGridAdapter.this.performCheck(holder, position);
            }
        });
        holder.selectIv.setChecked(this.mediaObjectArrayList.get((int)position).isSelected);
        return convertView;
    }

    private void performCheck(ViewHolder holder, int position) {
        if (this.selectedPositions.size() == this.pickCount && !this.mediaObjectArrayList.get((int)position).isSelected) {
            if (this.pickCount == 1) {
                Toast.makeText((Context)this.mContext, (CharSequence)("You can select max " + this.pickCount + " image"), (int)0).show();
            } else {
                Toast.makeText((Context)this.mContext, (CharSequence)("You can select max " + this.pickCount + " images"), (int)0).show();
            }
        } else {
            if (!this.mediaObjectArrayList.get((int)position).isSelected) {
                this.selectedPositions.add(position);
            } else {
                this.selectedPositions.remove(position);
            }
            this.mediaObjectArrayList.get((int)position).isSelected = !this.mediaObjectArrayList.get((int)position).isSelected;
            this.setActionbarTitle(this.getCount());
        }
        holder.selectIv.setChecked(this.mediaObjectArrayList.get((int)position).isSelected);
    }

    private void setActionbarTitle(int total) {
        if (this.pickCount == 1) {
            this.actionBar.setTitle((CharSequence)this.bucketTitle);
        } else {
            this.actionBar.setTitle((CharSequence)(this.bucketTitle + " (" + this.selectedPositions.size() + "/" + String.valueOf(total) + ")"));
        }
    }

    private static class ViewHolder {
        CheckBox selectIv;
        SimpleDraweeView imgThumb;
        TextView videoDuration;
        public int position;

        private ViewHolder() {
        }
    }
}

