/*
 * Decompiled with CFR 0.152.
 */
package com.rahul.media.imagemodule.adapter;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.support.v7.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.facebook.drawee.view.SimpleDraweeView;
import com.rahul.media.R;
import com.rahul.media.imagemodule.ImageGalleryPickerActivity;
import com.rahul.media.model.Album;
import com.rahul.media.model.Define;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class ImageAlbumListAdapter
extends RecyclerView.Adapter<ViewHolder> {
    private final int pickCount;
    private List<Album> albumList;
    private List<String> thumbList = new ArrayList<String>();

    public ImageAlbumListAdapter(List<Album> albumList, int pickCount) {
        this.albumList = albumList;
        this.pickCount = pickCount;
    }

    public ViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        View view = LayoutInflater.from((Context)parent.getContext()).inflate(R.layout.album_item, parent, false);
        return new ViewHolder(view);
    }

    public void setThumbList(List<String> thumbList) {
        this.thumbList = thumbList;
        this.notifyDataSetChanged();
    }

    public void onBindViewHolder(final ViewHolder holder, final int position) {
        String thumbPath = "";
        if (this.thumbList != null && this.thumbList.size() > position) {
            thumbPath = this.thumbList.get(position);
        }
        this.loadImage(thumbPath, holder.imgAlbum);
        holder.areaAlbum.setTag((Object)this.albumList.get(position));
        Album a = (Album)holder.areaAlbum.getTag();
        holder.txtAlbum.setText((CharSequence)this.albumList.get((int)position).bucketname);
        holder.txtAlbumCount.setText((CharSequence)String.valueOf(a.counter));
        holder.areaAlbum.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                Album a = (Album)v.getTag();
                Intent i = new Intent(holder.areaAlbum.getContext(), ImageGalleryPickerActivity.class);
                i.putExtra("album", (Serializable)a);
                i.putExtra("album_title", ((Album)((ImageAlbumListAdapter)ImageAlbumListAdapter.this).albumList.get((int)position)).bucketname);
                i.putExtra("pickCount", ImageAlbumListAdapter.this.pickCount);
                ((Activity)holder.areaAlbum.getContext()).startActivityForResult(i, Define.ENTER_ALBUM_REQUEST_CODE);
            }
        });
    }

    private void loadImage(String thumbPath, SimpleDraweeView imgAlbum) {
        imgAlbum.setImageURI(Uri.parse((String)("file://" + thumbPath)));
    }

    public int getItemCount() {
        return this.albumList.size();
    }

    public static class ViewHolder
    extends RecyclerView.ViewHolder {
        private SimpleDraweeView imgAlbum;
        private TextView txtAlbum;
        private TextView txtAlbumCount;
        private RelativeLayout areaAlbum;

        public ViewHolder(View view) {
            super(view);
            this.imgAlbum = (SimpleDraweeView)view.findViewById(R.id.img_album);
            this.txtAlbum = (TextView)view.findViewById(R.id.txt_album);
            this.txtAlbumCount = (TextView)view.findViewById(R.id.txt_album_count);
            this.areaAlbum = (RelativeLayout)view.findViewById(R.id.area_album);
        }
    }
}

