/*
 * Decompiled with CFR 0.152.
 */
package com.sangcomz.fishbun.ui.picker;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.database.Cursor;
import android.net.Uri;
import android.os.AsyncTask;
import android.os.Build;
import android.os.Bundle;
import android.os.Environment;
import android.provider.MediaStore;
import android.support.design.widget.Snackbar;
import android.support.v7.app.AppCompatActivity;
import android.support.v7.widget.Toolbar;
import android.view.Menu;
import android.view.MenuItem;
import android.view.View;
import android.widget.GridView;
import android.widget.ListAdapter;
import android.widget.Toast;
import com.bumptech.glide.Glide;
import com.luminous.pick.R;
import com.msupport.MSupport;
import com.sangcomz.fishbun.adapter.ImageGalleryGridAdapter;
import com.sangcomz.fishbun.bean.Album;
import com.sangcomz.fishbun.bean.MediaObject;
import com.sangcomz.fishbun.bean.MediaType;
import com.sangcomz.fishbun.define.Define;
import java.io.File;
import java.util.ArrayList;

public class ImageGalleryPickerActivity
extends AppCompatActivity {
    private GridView gridView;
    private ArrayList<MediaObject> mGalleryImageArrayList = new ArrayList();
    private Album a;
    ImageGalleryGridAdapter adapter;
    private String pathDir = "";
    private int pickCount;

    protected void onDestroy() {
        super.onDestroy();
        Glide.get((Context)this).clearMemory();
    }

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.activity_photo_picker);
        Toolbar toolbar = (Toolbar)this.findViewById(R.id.toolbar);
        this.setSupportActionBar(toolbar);
        toolbar.setBackgroundColor(Define.ACTIONBAR_COLOR);
        this.getSupportActionBar().setDisplayHomeAsUpEnabled(true);
        this.a = (Album)this.getIntent().getSerializableExtra("album");
        this.getSupportActionBar().setTitle((CharSequence)this.a.bucketname);
        this.pickCount = this.getIntent().getIntExtra("pickCount", 1);
        this.gridView = (GridView)this.findViewById(R.id.gridview);
        if (Build.VERSION.SDK_INT >= 23) {
            boolean isStoragePermissionGiven = MSupport.checkPermissionWithRationale((Activity)this, null, "android.permission.WRITE_EXTERNAL_STORAGE", 2);
            if (isStoragePermissionGiven) {
                new DisplayImage().execute(new Void[0]);
            }
        } else {
            new DisplayImage().execute(new Void[0]);
        }
    }

    public boolean onCreateOptionsMenu(Menu menu2) {
        this.getMenuInflater().inflate(R.menu.menu_photo_album, menu2);
        return true;
    }

    public boolean onOptionsItemSelected(MenuItem item) {
        int id2 = item.getItemId();
        if (id2 == R.id.action_ok) {
            ArrayList<String> path = new ArrayList<String>();
            for (int i = 0; i < this.mGalleryImageArrayList.size(); ++i) {
                if (!this.mGalleryImageArrayList.get((int)i).isSelected) continue;
                path.add(this.mGalleryImageArrayList.get(i).getPath());
            }
            if (path.isEmpty()) {
                Snackbar.make((View)this.gridView, (CharSequence)this.getString(R.string.msg_no_slected), (int)-1).show();
            } else {
                Intent i = new Intent();
                i.putStringArrayListExtra("all_path", path);
                this.setResult(-1, i);
                this.finish();
            }
            return true;
        }
        if (id2 == 16908332) {
            this.finish();
        }
        return super.onOptionsItemSelected(item);
    }

    public void onRequestPermissionsResult(int requestCode, String[] permissions, int[] grantResults) {
        switch (requestCode) {
            case 2: {
                if (grantResults[0] == 0) {
                    new DisplayImage().execute(new Void[0]);
                    break;
                }
                Toast.makeText((Context)this, (CharSequence)"Storage permission not granted", (int)0).show();
                this.finish();
            }
        }
    }

    private void getAllMediaThumbnailsPath(long id2) {
        String path = "";
        String selection = "bucket_id = ?";
        String bucketid = String.valueOf(id2);
        String sort = "_id DESC";
        String[] selectionArgs = new String[]{bucketid};
        Uri images = MediaStore.Images.Media.EXTERNAL_CONTENT_URI;
        Cursor c = !bucketid.equals("0") ? this.getContentResolver().query(images, null, selection, selectionArgs, sort) : this.getContentResolver().query(images, null, null, null, sort);
        if (c != null) {
            c.moveToFirst();
            while (true) {
                MediaObject mediaObject;
                path = c.getString(c.getColumnIndex("_data"));
                long creationDate = ImageGalleryPickerActivity.getCreationDate(path);
                if (c.isLast()) {
                    mediaObject = new MediaObject(c.getInt(0), path, MediaType.PHOTO, creationDate);
                    this.mGalleryImageArrayList.add(mediaObject);
                    c.close();
                    break;
                }
                mediaObject = new MediaObject(c.getInt(0), path, MediaType.PHOTO, creationDate);
                this.mGalleryImageArrayList.add(mediaObject);
                c.moveToNext();
            }
        }
    }

    private static long getCreationDate(String filePath) {
        File file = new File(filePath);
        return file.lastModified();
    }

    public void startFileMediaScan(String path) {
        this.sendBroadcast(new Intent("android.intent.action.MEDIA_SCANNER_SCAN_FILE", Uri.parse((String)("file://" + path))));
    }

    private void setPathDir(String path, String fileName) {
        this.pathDir = path.replace("/" + fileName, "");
    }

    private String getPathDir() {
        if (this.pathDir.equals("") || this.a.bucketid == 0L) {
            this.pathDir = Environment.getExternalStoragePublicDirectory((String)Environment.DIRECTORY_PICTURES).getAbsolutePath();
        }
        return this.pathDir;
    }

    private class DisplayImage
    extends AsyncTask<Void, Void, Boolean> {
        private DisplayImage() {
        }

        protected void onPreExecute() {
            super.onPreExecute();
            Thread t = new Thread(new Runnable(){

                @Override
                public void run() {
                }
            });
            t.start();
        }

        protected Boolean doInBackground(Void ... params) {
            ImageGalleryPickerActivity.this.getAllMediaThumbnailsPath(((ImageGalleryPickerActivity)ImageGalleryPickerActivity.this).a.bucketid);
            return true;
        }

        protected void onPostExecute(Boolean result) {
            super.onPostExecute((Object)result);
            if (result != null && result.booleanValue()) {
                ImageGalleryPickerActivity.this.adapter = new ImageGalleryGridAdapter((Context)ImageGalleryPickerActivity.this, ImageGalleryPickerActivity.this.mGalleryImageArrayList, ImageGalleryPickerActivity.this.getPathDir(), ImageGalleryPickerActivity.this.pickCount, ImageGalleryPickerActivity.this.getSupportActionBar(), ((ImageGalleryPickerActivity)ImageGalleryPickerActivity.this).a.bucketname);
                ImageGalleryPickerActivity.this.gridView.setAdapter((ListAdapter)ImageGalleryPickerActivity.this.adapter);
            }
        }
    }
}

