/*
 * Decompiled with CFR 0.152.
 */
package com.sangcomz.fishbun.videomodule.adapter;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import android.widget.CheckBox;
import android.widget.TextView;
import com.luminous.pick.R;
import com.sangcomz.fishbun.bean.MediaObject;
import com.sangcomz.fishbun.util.ProcessGalleryFile;
import com.sangcomz.fishbun.util.SquareImageView;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class VideoGalleryAdapter
extends BaseAdapter {
    private Context mContext;
    private Set<ProcessGalleryFile> tasks;
    ArrayList<MediaObject> mediaObjectArrayList;
    private boolean isFirstTime;

    public VideoGalleryAdapter(Context c, ArrayList<MediaObject> mediaObjectArrayList) {
        this.mContext = c;
        this.isFirstTime = true;
        this.tasks = new HashSet<ProcessGalleryFile>();
        this.mediaObjectArrayList = mediaObjectArrayList;
        Collections.sort(mediaObjectArrayList);
    }

    public void setFirstTime(boolean firstTime) {
        this.isFirstTime = firstTime;
    }

    public ArrayList<String> getSelectedStringArray() {
        ArrayList<String> dataT = new ArrayList<String>();
        for (int i = 0; i < this.mediaObjectArrayList.size(); ++i) {
            if (!this.mediaObjectArrayList.get((int)i).isSelected) continue;
            dataT.add(this.mediaObjectArrayList.get(i).getPath());
        }
        return dataT;
    }

    public int getCount() {
        return this.mediaObjectArrayList.size();
    }

    public MediaObject getItem(int i) {
        return this.mediaObjectArrayList.get(i);
    }

    public long getItemId(int i) {
        return 0L;
    }

    public View getView(final int position, View convertView, ViewGroup parent) {
        ViewHolder holder;
        if (convertView == null) {
            LayoutInflater vi = (LayoutInflater)this.mContext.getSystemService("layout_inflater");
            holder = new ViewHolder();
            holder.position = position;
            convertView = vi.inflate(R.layout.list_item_gallery, null);
            holder.imgThumb = (SquareImageView)convertView.findViewById(R.id.imgThumbnail);
            holder.videoDuration = (TextView)convertView.findViewById(R.id.txtDuration);
            holder.selectIv = (CheckBox)convertView.findViewById(R.id.imgQueueMultiSelected);
        } else {
            holder = (ViewHolder)convertView.getTag();
        }
        holder.imgThumb.setImageResource(R.drawable.placeholder_470x352);
        holder.object = this.getItem(position);
        convertView.setTag((Object)holder);
        holder.selectIv.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                VideoGalleryAdapter.this.mediaObjectArrayList.get((int)position).isSelected = !VideoGalleryAdapter.this.mediaObjectArrayList.get((int)position).isSelected;
                holder.selectIv.setChecked(VideoGalleryAdapter.this.mediaObjectArrayList.get((int)position).isSelected);
            }
        });
        convertView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                VideoGalleryAdapter.this.mediaObjectArrayList.get((int)position).isSelected = !VideoGalleryAdapter.this.mediaObjectArrayList.get((int)position).isSelected;
                holder.selectIv.setChecked(VideoGalleryAdapter.this.mediaObjectArrayList.get((int)position).isSelected);
            }
        });
        holder.selectIv.setChecked(this.mediaObjectArrayList.get((int)position).isSelected);
        if (this.isFirstTime) {
            ProcessGalleryFile processGalleryFile = new ProcessGalleryFile(holder.imgThumb, holder.videoDuration, holder.object.getPath(), holder.object.getMediaType());
            if (this.tasks == null) {
                this.tasks = new HashSet<ProcessGalleryFile>();
            }
            if (!this.tasks.contains((Object)processGalleryFile)) {
                try {
                    processGalleryFile.execute(new Void[0]);
                    this.tasks.add(processGalleryFile);
                }
                catch (Exception ignored) {}
            }
        } else {
            try {
                this.cancelAll();
            }
            catch (Exception ignored) {
                // empty catch block
            }
            holder.videoDuration.setVisibility(4);
        }
        return convertView;
    }

    public void cancelAll() throws Exception {
        Iterator<ProcessGalleryFile> iterator = this.tasks.iterator();
        while (iterator.hasNext()) {
            iterator.next().cancel(true);
            iterator.remove();
        }
    }

    public static class ViewHolder {
        public CheckBox selectIv;
        public SquareImageView imgThumb;
        public TextView videoDuration;
        public MediaObject object;
        public int position;
    }
}

