/*
 * Decompiled with CFR 0.152.
 */
package com.sangcomz.fishbun.ui.album;

import android.app.Activity;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.database.Cursor;
import android.net.Uri;
import android.os.AsyncTask;
import android.os.Build;
import android.os.Bundle;
import android.provider.MediaStore;
import android.support.v7.app.AppCompatActivity;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.support.v7.widget.Toolbar;
import android.util.Log;
import android.view.MenuItem;
import android.widget.RelativeLayout;
import android.widget.Toast;
import com.luminous.pick.R;
import com.msupport.MSupport;
import com.sangcomz.fishbun.ItemDecoration.DividerItemDecoration;
import com.sangcomz.fishbun.adapter.ImageAlbumListAdapter;
import com.sangcomz.fishbun.bean.Album;
import com.sangcomz.fishbun.define.Define;
import java.util.ArrayList;
import java.util.List;

public class ImageAlbumListActivity
extends AppCompatActivity {
    private List<Album> albumList = new ArrayList<Album>();
    private RecyclerView recyclerView;
    private ImageAlbumListAdapter adapter;
    private List<String> thumbList;
    private RelativeLayout noAlbum;
    private int pickCount;

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.activity_photo_album);
        Toolbar toolbar = (Toolbar)this.findViewById(R.id.toolbar);
        this.noAlbum = (RelativeLayout)this.findViewById(R.id.no_album);
        this.setSupportActionBar(toolbar);
        toolbar.setBackgroundColor(Define.ACTIONBAR_COLOR);
        this.getSupportActionBar().setDisplayHomeAsUpEnabled(true);
        LinearLayoutManager linearLayoutManager = new LinearLayoutManager((Context)this);
        this.recyclerView = (RecyclerView)this.findViewById(R.id.recyclerview);
        this.recyclerView.setLayoutManager((RecyclerView.LayoutManager)linearLayoutManager);
        this.recyclerView.addItemDecoration((RecyclerView.ItemDecoration)new DividerItemDecoration((Context)this, 1));
        this.pickCount = this.getIntent().getIntExtra("pickCount", 1);
        if (Build.VERSION.SDK_INT >= 23) {
            boolean isStoragePermissionGiven = MSupport.checkPermissionWithRationale((Activity)this, null, "android.permission.WRITE_EXTERNAL_STORAGE", 2);
            if (isStoragePermissionGiven) {
                new DisplayImage().execute(new Void[0]);
            }
        } else {
            new DisplayImage().execute(new Void[0]);
        }
    }

    public void onRequestPermissionsResult(int requestCode, String[] permissions, int[] grantResults) {
        switch (requestCode) {
            case 2: {
                if (grantResults[0] == 0) {
                    new DisplayImage().execute(new Void[0]);
                    break;
                }
                Toast.makeText((Context)this, (CharSequence)"Storage permission not granted", (int)0).show();
                this.finish();
            }
        }
    }

    private String getAllMediaThumbnailsPath(long id2) {
        String path = "";
        String selection = "bucket_id = ?";
        String bucketId = String.valueOf(id2);
        String sort = "_id DESC";
        String[] selectionArgs = new String[]{bucketId};
        Uri images = MediaStore.Images.Media.EXTERNAL_CONTENT_URI;
        Cursor c = !bucketId.equals("0") ? this.getContentResolver().query(images, null, selection, selectionArgs, sort) : this.getContentResolver().query(images, null, null, null, sort);
        if (c != null) {
            if (c.moveToNext()) {
                selection = "_id = ?";
                String photoID = c.getString(c.getColumnIndex("_id"));
                selectionArgs = new String[]{photoID};
                images = MediaStore.Images.Thumbnails.EXTERNAL_CONTENT_URI;
                Cursor cursor = this.getContentResolver().query(images, null, selection, selectionArgs, sort);
                path = cursor != null && cursor.moveToNext() ? c.getString(c.getColumnIndex("_data")) : c.getString(c.getColumnIndex("_data"));
                if (cursor != null) {
                    cursor.close();
                }
            } else {
                Log.e((String)"id", (String)"from else");
            }
        }
        if (c != null) {
            c.close();
        }
        return path;
    }

    public boolean onOptionsItemSelected(MenuItem item) {
        switch (item.getItemId()) {
            case 16908332: {
                Intent i = new Intent();
                this.setResult(0, i);
                this.finish();
            }
        }
        return super.onOptionsItemSelected(item);
    }

    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        if (requestCode == Define.ENTER_ALBUM_REQUEST_CODE && resultCode == -1) {
            Intent i = new Intent();
            i.putStringArrayListExtra("all_path", data.getStringArrayListExtra("all_path"));
            this.setResult(-1, i);
            this.finish();
        }
    }

    public class DisplayThumbnail
    extends AsyncTask<Void, Void, Void> {
        protected void onPreExecute() {
            super.onPreExecute();
            ImageAlbumListActivity.this.thumbList = new ArrayList();
        }

        protected Void doInBackground(Void ... params) {
            for (int i = 0; i < ImageAlbumListActivity.this.albumList.size(); ++i) {
                Album album = (Album)ImageAlbumListActivity.this.albumList.get(i);
                String path = ImageAlbumListActivity.this.getAllMediaThumbnailsPath(album.bucketid);
                ImageAlbumListActivity.this.thumbList.add(path);
            }
            return null;
        }

        protected void onPostExecute(Void result) {
            super.onPostExecute((Object)result);
            ImageAlbumListActivity.this.adapter.setThumbList(ImageAlbumListActivity.this.thumbList);
        }
    }

    public class DisplayImage
    extends AsyncTask<Void, Void, Boolean> {
        protected Boolean doInBackground(Void ... params) {
            String orderBy = "bucket_id";
            ContentResolver resolver = ImageAlbumListActivity.this.getContentResolver();
            String[] projection = new String[]{"bucket_display_name", "bucket_id"};
            Cursor imagecursor = resolver.query(MediaStore.Images.Media.EXTERNAL_CONTENT_URI, projection, null, null, "bucket_id");
            long previousid = 0L;
            int bucketColumn = imagecursor.getColumnIndex("bucket_display_name");
            int bucketcolumnid = imagecursor.getColumnIndex("bucket_id");
            ImageAlbumListActivity.this.albumList = new ArrayList();
            Album totalAlbum = new Album();
            totalAlbum.bucketid = 0L;
            totalAlbum.bucketname = ImageAlbumListActivity.this.getString(R.string.str_all_view);
            totalAlbum.counter = 0;
            ImageAlbumListActivity.this.albumList.add(totalAlbum);
            int totalCounter = 0;
            while (imagecursor.moveToNext()) {
                ++totalCounter;
                long bucketid = imagecursor.getInt(bucketcolumnid);
                if (previousid != bucketid) {
                    Album album = new Album();
                    album.bucketid = bucketid;
                    album.bucketname = imagecursor.getString(bucketColumn);
                    ++album.counter;
                    ImageAlbumListActivity.this.albumList.add(album);
                    previousid = bucketid;
                } else if (ImageAlbumListActivity.this.albumList.size() > 0) {
                    ++((Album)((ImageAlbumListActivity)ImageAlbumListActivity.this).albumList.get((int)(((ImageAlbumListActivity)ImageAlbumListActivity.this).albumList.size() - 1))).counter;
                }
                if (!imagecursor.isLast()) continue;
                ((Album)((ImageAlbumListActivity)ImageAlbumListActivity.this).albumList.get((int)0)).counter = totalCounter;
            }
            imagecursor.close();
            if (totalCounter == 0) {
                ImageAlbumListActivity.this.albumList.clear();
                return false;
            }
            return true;
        }

        protected void onPostExecute(Boolean result) {
            super.onPostExecute((Object)result);
            if (result.booleanValue()) {
                ImageAlbumListActivity.this.noAlbum.setVisibility(8);
                ImageAlbumListActivity.this.adapter = new ImageAlbumListAdapter(ImageAlbumListActivity.this.albumList, ImageAlbumListActivity.this.pickCount);
                ImageAlbumListActivity.this.recyclerView.setAdapter((RecyclerView.Adapter)ImageAlbumListActivity.this.adapter);
                ImageAlbumListActivity.this.adapter.notifyDataSetChanged();
                new DisplayThumbnail().execute(new Void[0]);
            } else {
                ImageAlbumListActivity.this.noAlbum.setVisibility(0);
            }
        }
    }
}

