/*
 * Decompiled with CFR 0.152.
 */
package com.sangcomz.fishbun.adapter;

import android.content.Context;
import android.support.v7.app.ActionBar;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import android.widget.CheckBox;
import android.widget.ImageView;
import android.widget.TextView;
import android.widget.Toast;
import com.bumptech.glide.Glide;
import com.luminous.pick.R;
import com.sangcomz.fishbun.bean.MediaObject;
import com.sangcomz.fishbun.define.Define;
import com.sangcomz.fishbun.util.SquareImageView;
import java.util.ArrayList;
import java.util.HashSet;

public class ImageGalleryGridAdapter
extends BaseAdapter {
    private final ArrayList<MediaObject> mediaObjectArrayList;
    private final int pickCount;
    private final Context mContext;
    String saveDir;
    ActionBar actionBar;
    private String bucketTitle;
    HashSet<Integer> selectedPositions = new HashSet();

    public ImageGalleryGridAdapter(Context context, ArrayList<MediaObject> pickedImageBeans, String saveDir, int pickCount, ActionBar supportActionBar, String bucketTitle) {
        this.mContext = context;
        this.mediaObjectArrayList = pickedImageBeans;
        this.saveDir = saveDir;
        this.pickCount = pickCount;
        this.actionBar = supportActionBar;
        this.bucketTitle = bucketTitle;
    }

    public int getCount() {
        return this.mediaObjectArrayList.size();
    }

    public Object getItem(int position) {
        return null;
    }

    public long getItemId(int position) {
        return 0L;
    }

    public View getView(final int position, View convertView, ViewGroup parent) {
        ViewHolder holder;
        if (convertView == null) {
            LayoutInflater vi = (LayoutInflater)this.mContext.getSystemService("layout_inflater");
            holder = new ViewHolder();
            holder.position = position;
            convertView = vi.inflate(R.layout.list_item_gallery, null);
            holder.imgThumb = (SquareImageView)convertView.findViewById(R.id.imgThumbnail);
            holder.videoDuration = (TextView)convertView.findViewById(R.id.txtDuration);
            holder.selectIv = (CheckBox)convertView.findViewById(R.id.imgQueueMultiSelected);
            convertView.setTag((Object)holder);
        } else {
            holder = (ViewHolder)convertView.getTag();
        }
        if (this.mediaObjectArrayList.get((int)position).isSelected) {
            this.selectedPositions.add(position);
        } else {
            this.selectedPositions.remove(position);
        }
        Glide.with((Context)holder.imgThumb.getContext()).load(this.mediaObjectArrayList.get(position).getPath()).asBitmap().override(Define.ALBUM_THUMBNAIL_SIZE, Define.ALBUM_THUMBNAIL_SIZE).placeholder(R.drawable.loading_img).into((ImageView)holder.imgThumb);
        holder.selectIv.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                ImageGalleryGridAdapter.this.performCheck(holder, position);
            }
        });
        convertView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                ImageGalleryGridAdapter.this.performCheck(holder, position);
            }
        });
        holder.selectIv.setChecked(this.mediaObjectArrayList.get((int)position).isSelected);
        return convertView;
    }

    private void performCheck(ViewHolder holder, int position) {
        if (this.selectedPositions.size() == this.pickCount && !this.mediaObjectArrayList.get((int)position).isSelected) {
            if (this.pickCount == 1) {
                Toast.makeText((Context)this.mContext, (CharSequence)("You can select max " + this.pickCount + " image"), (int)0).show();
            } else {
                Toast.makeText((Context)this.mContext, (CharSequence)("You can select max " + this.pickCount + " images"), (int)0).show();
            }
        } else {
            if (!this.mediaObjectArrayList.get((int)position).isSelected) {
                this.selectedPositions.add(position);
            } else {
                this.selectedPositions.remove(position);
            }
            this.mediaObjectArrayList.get((int)position).isSelected = !this.mediaObjectArrayList.get((int)position).isSelected;
            this.setActionbarTitle(this.getCount());
        }
        holder.selectIv.setChecked(this.mediaObjectArrayList.get((int)position).isSelected);
    }

    public void setActionbarTitle(int total) {
        if (this.pickCount == 1) {
            this.actionBar.setTitle((CharSequence)this.bucketTitle);
        } else {
            this.actionBar.setTitle((CharSequence)(this.bucketTitle + " (" + this.selectedPositions.size() + "/" + String.valueOf(total) + ")"));
        }
    }

    public static class ViewHolder {
        public CheckBox selectIv;
        public SquareImageView imgThumb;
        public TextView videoDuration;
        public MediaObject object;
        public int position;
    }
}

