/*
 * Decompiled with CFR 0.152.
 */
package com.sangcomz.fishbun.adapter;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.support.v7.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.bumptech.glide.Glide;
import com.luminous.pick.R;
import com.sangcomz.fishbun.bean.Album;
import com.sangcomz.fishbun.define.Define;
import com.sangcomz.fishbun.ui.picker.ImageGalleryPickerActivity;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class ImageAlbumListAdapter
extends RecyclerView.Adapter<ViewHolder> {
    private final int pickCount;
    private List<Album> albumlist;
    private List<String> thumbList = new ArrayList<String>();
    private String thumPath;

    public ImageAlbumListAdapter(List<Album> albumList, int pickCount) {
        this.albumlist = albumList;
        this.pickCount = pickCount;
    }

    public ViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        View view = LayoutInflater.from((Context)parent.getContext()).inflate(R.layout.album_item, parent, false);
        return new ViewHolder(view);
    }

    public void setThumbList(List<String> thumbList) {
        this.thumbList = thumbList;
        this.notifyDataSetChanged();
    }

    public void onBindViewHolder(final ViewHolder holder, final int position) {
        if (this.thumbList != null && this.thumbList.size() > position) {
            this.thumPath = this.thumbList.get(position);
        }
        if (this.thumbList != null) {
            if (this.thumbList.size() > position) {
                Glide.with((Context)holder.imgAlbum.getContext()).load(this.thumPath).asBitmap().override(Define.ALBUM_THUMBNAIL_SIZE, Define.ALBUM_THUMBNAIL_SIZE).placeholder(R.drawable.loading_img).into(holder.imgAlbum);
            } else {
                Glide.with((Context)holder.imgAlbum.getContext()).load(Integer.valueOf(R.drawable.loading_img)).into(holder.imgAlbum);
            }
        }
        holder.areaAlbum.setTag((Object)this.albumlist.get(position));
        Album a = (Album)holder.areaAlbum.getTag();
        holder.txtAlbum.setText((CharSequence)this.albumlist.get((int)position).bucketname);
        holder.txtAlbumCount.setText((CharSequence)String.valueOf(a.counter));
        holder.areaAlbum.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                Album a = (Album)v.getTag();
                Intent i = new Intent(holder.areaAlbum.getContext(), ImageGalleryPickerActivity.class);
                i.putExtra("album", (Serializable)a);
                i.putExtra("album_title", ((Album)((ImageAlbumListAdapter)ImageAlbumListAdapter.this).albumlist.get((int)position)).bucketname);
                i.putExtra("pickCount", ImageAlbumListAdapter.this.pickCount);
                ((Activity)holder.areaAlbum.getContext()).startActivityForResult(i, Define.ENTER_ALBUM_REQUEST_CODE);
            }
        });
    }

    public int getItemCount() {
        return this.albumlist.size();
    }

    public static class ViewHolder
    extends RecyclerView.ViewHolder {
        private ImageView imgAlbum;
        private TextView txtAlbum;
        private TextView txtAlbumCount;
        private RelativeLayout areaAlbum;

        public ViewHolder(View view) {
            super(view);
            this.imgAlbum = (ImageView)view.findViewById(R.id.img_album);
            this.imgAlbum.setLayoutParams((ViewGroup.LayoutParams)new RelativeLayout.LayoutParams(Define.ALBUM_THUMBNAIL_SIZE, Define.ALBUM_THUMBNAIL_SIZE));
            this.txtAlbum = (TextView)view.findViewById(R.id.txt_album);
            this.txtAlbumCount = (TextView)view.findViewById(R.id.txt_album_count);
            this.areaAlbum = (RelativeLayout)view.findViewById(R.id.area_album);
        }
    }
}

