/*
 * Decompiled with CFR 0.152.
 */
package com.luminous.pick;

import android.app.Activity;
import android.app.ProgressDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.graphics.Bitmap;
import android.net.Uri;
import android.os.AsyncTask;
import android.os.Bundle;
import android.support.v4.app.FragmentActivity;
import android.support.v4.view.PagerAdapter;
import android.support.v4.view.ViewPager;
import android.support.v7.app.AlertDialog;
import android.support.v7.app.AppCompatActivity;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.support.v7.widget.Toolbar;
import android.view.LayoutInflater;
import android.view.Menu;
import android.view.MenuItem;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AdapterView;
import android.widget.ImageView;
import android.widget.LinearLayout;
import com.bumptech.glide.Glide;
import com.bumptech.glide.request.animation.GlideAnimation;
import com.bumptech.glide.request.target.SimpleTarget;
import com.bumptech.glide.request.target.Target;
import com.luminous.pick.CustomGallery;
import com.luminous.pick.ImageListRecycleAdapter;
import com.luminous.pick.R;
import com.luminous.pick.controller.MediaSingleTon;
import com.luminous.pick.utils.BitmapDecoder;
import com.luminous.pick.utils.CameraUtils;
import com.luminous.pick.utils.ViewPagerSwipeLess;
import com.sangcomz.fishbun.define.Define;
import com.sangcomz.fishbun.ui.album.ImageAlbumListActivity;
import crop.Crop;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;

public class MultipleImagePreviewActivity
extends AppCompatActivity {
    private static final int PICK_IMAGE = 200;
    private static AlertDialog alertDialog;
    private ViewPagerSwipeLess mPager;
    private HashMap<String, CustomGallery> dataT;
    private CustomPagerAdapter adapter;
    private ImageListRecycleAdapter mImageListAdapter;
    private int imageQuality;
    private boolean isCrop;
    private int pickCount;

    public static void showAlertDialog(Context mContext, String text) {
        alertDialog = new AlertDialog.Builder(mContext).setMessage((CharSequence)text).setCancelable(false).setPositiveButton((CharSequence)"OK", new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                alertDialog.dismiss();
            }
        }).create();
        alertDialog.show();
    }

    public void onBackPressed() {
        Intent data2 = new Intent();
        this.setResult(0, data2);
        super.onBackPressed();
    }

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.activity_multiimage_preview);
        this.mPager = (ViewPagerSwipeLess)this.findViewById(R.id.pager);
        Toolbar toolbar = (Toolbar)this.findViewById(R.id.toolbar);
        this.setSupportActionBar(toolbar);
        toolbar.setBackgroundColor(Define.ACTIONBAR_COLOR);
        this.dataT = new HashMap();
        this.adapter = new CustomPagerAdapter(this.dataT);
        this.mPager.setAdapter(this.adapter);
        this.mPager.addOnPageChangeListener(new ViewPager.OnPageChangeListener(){

            public void onPageScrolled(int position, float positionOffset, int positionOffsetPixels) {
            }

            public void onPageSelected(int position) {
            }

            public void onPageScrollStateChanged(int state) {
            }
        });
        this.mImageListAdapter = new ImageListRecycleAdapter((Context)this, this.dataT);
        RecyclerView mRecycleView = (RecyclerView)this.findViewById(R.id.image_hlistview);
        mRecycleView.setLayoutManager((RecyclerView.LayoutManager)new LinearLayoutManager((Context)this, 0, false));
        mRecycleView.setAdapter((RecyclerView.Adapter)this.mImageListAdapter);
        this.mImageListAdapter.setOnItemClickListener(new AdapterView.OnItemClickListener(){

            public void onItemClick(AdapterView<?> parent, View view, int position, long id2) {
                MultipleImagePreviewActivity.this.mPager.setCurrentItem(position);
            }
        });
        try {
            this.isCrop = this.getIntent().getExtras().getBoolean("crop");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.pickCount = this.getIntent().getIntExtra("pickCount", 1);
        if (this.getIntent().getExtras().containsKey("imageQuality")) {
            this.imageQuality = this.getIntent().getExtras().getInt("imageQuality");
        }
        this.openGallery();
    }

    private void openGallery() {
        Intent i = new Intent((Context)this, ImageAlbumListActivity.class);
        i.putExtra("pickCount", this.pickCount);
        this.startActivityForResult(i, 200);
    }

    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        if (resultCode == -1) {
            if (requestCode == 200) {
                ArrayList allPath = data.getStringArrayListExtra("all_path");
                if (allPath != null && !allPath.isEmpty()) {
                    if (this.pickCount == 1) {
                        this.dataT.clear();
                        new ProcessImageView().execute(new Uri[]{Uri.parse((String)((String)allPath.get(0)))});
                    } else {
                        for (String string2 : allPath) {
                            if (string2 == null) continue;
                            CustomGallery item = new CustomGallery();
                            item.sdcardPath = string2;
                            item.sdCardUri = Uri.parse((String)string2);
                            this.dataT.put(string2, item);
                        }
                    }
                    this.adapter.customNotify(this.dataT);
                    this.mImageListAdapter.customNotify(this.dataT);
                }
            } else if (requestCode == 6709) {
                try {
                    Uri mTargetImageUri = (Uri)data.getExtras().get("output");
                    if (mTargetImageUri != null) {
                        String imagePath = this.mImageListAdapter.mItems.get((int)this.mPager.getCurrentItem()).sdcardPath;
                        CustomGallery item = new CustomGallery();
                        item.sdcardPath = mTargetImageUri.getPath();
                        item.sdCardUri = mTargetImageUri;
                        this.dataT.remove(imagePath);
                        this.dataT.put(mTargetImageUri.getPath(), item);
                        this.adapter.customNotify(this.dataT);
                        this.mImageListAdapter.customNotify(this.dataT);
                    }
                }
                catch (Exception e) {
                    String invalidImageText = (String)data.getExtras().get("invalid_image");
                    if (invalidImageText != null) {
                        MultipleImagePreviewActivity.showAlertDialog((Context)this, invalidImageText);
                    }
                }
            }
        } else if (this.dataT == null || this.dataT.size() <= 0) {
            Intent data2 = new Intent();
            this.setResult(0, data2);
            this.finish();
        }
    }

    public boolean onCreateOptionsMenu(Menu menu2) {
        this.getMenuInflater().inflate(R.menu.menu_camera, menu2);
        menu2.findItem(R.id.action_crop).setVisible(this.isCrop);
        return true;
    }

    public boolean onOptionsItemSelected(MenuItem item) {
        int id2 = item.getItemId();
        if (id2 == R.id.action_ok) {
            ArrayList<CustomGallery> mArrayList = new ArrayList<CustomGallery>(this.dataT.values());
            if (mArrayList.size() > 0) {
                ArrayList<String> allPath = new ArrayList<String>();
                for (int i = 0; i < mArrayList.size(); ++i) {
                    allPath.add(mArrayList.get((int)i).sdcardPath);
                }
                Intent data = new Intent().putStringArrayListExtra("all_path", allPath);
                this.setResult(-1, data);
                this.finish();
            }
        } else if (id2 == 16908332) {
            Intent data = new Intent();
            this.setResult(0, data);
            this.finish();
        } else if (id2 == R.id.action_camera) {
            this.openGallery();
        } else if (id2 == R.id.action_crop && this.adapter != null && this.adapter.getCount() > 0) {
            String imagePath = this.mImageListAdapter.mItems.get((int)this.mPager.getCurrentItem()).sdcardPath;
            Uri destination = null;
            try {
                destination = CameraUtils.createImageFile((Context)this);
                Crop.of(Uri.parse((String)("file://" + imagePath)), destination).asSquare().start((Activity)this);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return super.onOptionsItemSelected(item);
    }

    class CustomPagerAdapter
    extends PagerAdapter {
        LayoutInflater mLayoutInflater;
        ArrayList<CustomGallery> dataT;

        public CustomPagerAdapter(HashMap<String, CustomGallery> dataT) {
            this.dataT = new ArrayList<CustomGallery>(dataT.values());
            this.mLayoutInflater = (LayoutInflater)MultipleImagePreviewActivity.this.getSystemService("layout_inflater");
        }

        public void customNotify(HashMap<String, CustomGallery> dataHashmap) {
            this.dataT.clear();
            ArrayList<CustomGallery> dataT2 = new ArrayList<CustomGallery>(dataHashmap.values());
            this.dataT.addAll(dataT2);
            this.notifyDataSetChanged();
        }

        public int getCount() {
            return this.dataT.size();
        }

        public boolean isViewFromObject(View view, Object object) {
            return view == (LinearLayout)object;
        }

        public int getItemPosition(Object object) {
            return -2;
        }

        public Object instantiateItem(ViewGroup container, final int position) {
            View itemView = this.mLayoutInflater.inflate(R.layout.image_pager_item, container, false);
            final ImageView imageView = (ImageView)itemView.findViewById(R.id.full_screen_image);
            if (MediaSingleTon.getInstance().getBitmapHashMap().containsKey(this.dataT.get((int)position).sdcardPath)) {
                imageView.setImageBitmap(MediaSingleTon.getInstance().getBitmapHashMap().get(this.dataT.get((int)position).sdcardPath));
            } else {
                Glide.with((FragmentActivity)MultipleImagePreviewActivity.this).load(Uri.parse((String)("file://" + this.dataT.get((int)position).sdcardPath))).asBitmap().into((Target)new SimpleTarget<Bitmap>(100, 100){

                    public void onResourceReady(Bitmap resource, GlideAnimation glideAnimation) {
                        MediaSingleTon.getInstance().getBitmapHashMap().put(CustomPagerAdapter.this.dataT.get((int)position).sdcardPath, resource);
                        imageView.setImageBitmap(resource);
                    }
                });
            }
            container.addView(itemView);
            return itemView;
        }

        public void destroyItem(ViewGroup container, int position, Object object) {
            container.removeView((View)((LinearLayout)object));
        }
    }

    class ProcessImageView
    extends AsyncTask<Uri, Void, Void> {
        private ProgressDialog mProgressDialog;

        ProcessImageView() {
        }

        protected void onPreExecute() {
            super.onPreExecute();
            this.mProgressDialog = new ProgressDialog((Context)MultipleImagePreviewActivity.this);
            this.mProgressDialog.setMessage((CharSequence)"Processing image ...");
            this.mProgressDialog.setCancelable(false);
            this.mProgressDialog.setCanceledOnTouchOutside(false);
            this.mProgressDialog.show();
        }

        protected Void doInBackground(Uri ... params) {
            CustomGallery item = new CustomGallery();
            item.sdcardPath = params[0].getPath();
            item.sdCardUri = params[0];
            item.sdcardPath = BitmapDecoder.getBitmap(params[0].getPath(), MultipleImagePreviewActivity.this.imageQuality, (Context)MultipleImagePreviewActivity.this);
            item.sdCardUri = Uri.parse((String)item.sdcardPath);
            MultipleImagePreviewActivity.this.dataT.put(item.sdcardPath, item);
            return null;
        }

        protected void onPostExecute(Void aVoid) {
            super.onPostExecute((Object)aVoid);
            this.mProgressDialog.dismiss();
            MultipleImagePreviewActivity.this.adapter.customNotify(MultipleImagePreviewActivity.this.dataT);
            MultipleImagePreviewActivity.this.mImageListAdapter.customNotify(MultipleImagePreviewActivity.this.dataT);
        }
    }
}

