/*
 * Decompiled with CFR 0.152.
 */
package com.luminous.pick.controller;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import com.luminous.pick.CameraPickActivity;
import com.luminous.pick.VideoPickActivity;
import com.luminous.pick.controller.MediaSingleTon;
import com.luminous.pick.utils.VideoQuality;
import com.sangcomz.fishbun.ui.album.ImageAlbumListActivity;
import com.sangcomz.fishbun.videomodule.VideoAlbumActivity;
import java.util.ArrayList;

public class MediaFactory {
    private static final int GALLERY_APP = 111;
    private static final int CAMERA_APP = 222;
    public static MediaFactory mMediaFactory;

    private MediaFactory() {
    }

    public static synchronized MediaFactory create() {
        if (mMediaFactory == null) {
            mMediaFactory = new MediaFactory();
        }
        return mMediaFactory;
    }

    public MediaFactory start(MediaBuilder mediaBuilder) {
        MediaSingleTon.getInstance();
        Bundle bundle = new Bundle();
        if (mediaBuilder.takeVideo) {
            Intent intent = mediaBuilder.fromGallery ? new Intent(mediaBuilder.mContext, VideoAlbumActivity.class) : new Intent(mediaBuilder.mContext, VideoPickActivity.class);
            intent.putExtra("from", mediaBuilder.fromGallery);
            intent.putExtra("videoSize", mediaBuilder.videoSize);
            intent.putExtra("videoDuration", mediaBuilder.videoDuration);
            intent.putExtra("videoQuality", mediaBuilder.videoQuality.getQuality());
            ((Activity)mediaBuilder.mContext).startActivityForResult(intent, 111);
        } else {
            bundle.putBoolean("crop", mediaBuilder.isCrop);
            bundle.putInt("imageQuality", mediaBuilder.imageQuality);
            bundle.putInt("pickCount", mediaBuilder.pickCount);
            if (mediaBuilder.fromGallery) {
                Intent intent = new Intent(mediaBuilder.mContext, ImageAlbumListActivity.class);
                intent.setAction(mediaBuilder.action);
                intent.putExtras(bundle);
                ((Activity)mediaBuilder.mContext).startActivityForResult(intent, 111);
            } else {
                Intent intent = new Intent(mediaBuilder.mContext, CameraPickActivity.class);
                intent.setAction(mediaBuilder.action);
                intent.putExtras(bundle);
                ((Activity)mediaBuilder.mContext).startActivityForResult(intent, 222);
            }
        }
        return mMediaFactory;
    }

    public ArrayList<String> onActivityResult(int requestCode, int resultCode, Intent data) {
        ArrayList all_path = new ArrayList();
        if (resultCode == -1 && (requestCode == 111 || requestCode == 222)) {
            all_path = data.getStringArrayListExtra("all_path");
        }
        return all_path;
    }

    public static class MediaBuilder {
        String action = "luminous.ACTION_PICK";
        boolean isCrop = false;
        boolean fromGallery = true;
        boolean takeVideo = false;
        long videoSize = -1L;
        long videoDuration = -1L;
        private final Context mContext;
        int imageQuality = 100;
        private VideoQuality videoQuality = VideoQuality.HIGH_QUALITY;
        private int pickCount = 1;

        public MediaBuilder(Context mContext) {
            this.mContext = mContext;
        }

        public MediaBuilder takeVideo() {
            this.takeVideo = true;
            return this;
        }

        public MediaBuilder setVideoQuality(VideoQuality videoQuality) {
            this.videoQuality = videoQuality;
            return this;
        }

        public MediaBuilder setVideoSize(int size) {
            this.videoSize = (long)size * 1000000L;
            return this;
        }

        public MediaBuilder setImageQuality(int imageQuality) {
            if (imageQuality < 0 || imageQuality > 100) {
                imageQuality = 100;
            }
            this.imageQuality = imageQuality;
            return this;
        }

        public MediaBuilder setVideoDuration(long seconds) {
            this.videoDuration = seconds;
            return this;
        }

        public MediaBuilder fromGallery() {
            this.fromGallery = true;
            return this;
        }

        public MediaBuilder fromCamera() {
            this.fromGallery = false;
            return this;
        }

        public MediaBuilder doCropping() {
            this.isCrop = true;
            return this;
        }

        public MediaBuilder getSingleMediaFiles() {
            this.action = "luminous.ACTION_PICK";
            return this;
        }

        public MediaBuilder setPickCount(int count) {
            if (count <= 0) {
                count = 1;
            }
            this.pickCount = count;
            return this;
        }

        public MediaBuilder getMultipleMediaFiles() {
            this.action = "luminous.ACTION_MULTIPLE_PICK";
            return this;
        }
    }
}

