/*
 * Decompiled with CFR 0.152.
 */
package com.sangcomz.fishbun.videomodule;

import android.app.Activity;
import android.content.ContentValues;
import android.content.Context;
import android.content.Intent;
import android.database.Cursor;
import android.net.Uri;
import android.os.AsyncTask;
import android.os.Build;
import android.os.Bundle;
import android.os.Environment;
import android.os.Parcelable;
import android.provider.MediaStore;
import android.support.design.widget.Snackbar;
import android.support.v7.app.AppCompatActivity;
import android.support.v7.widget.Toolbar;
import android.text.TextUtils;
import android.util.Log;
import android.view.Menu;
import android.view.MenuItem;
import android.view.View;
import android.widget.AbsListView;
import android.widget.AdapterView;
import android.widget.GridView;
import android.widget.ListAdapter;
import android.widget.RelativeLayout;
import android.widget.Toast;
import com.luminous.pick.R;
import com.msupport.MSupport;
import com.sangcomz.fishbun.bean.MediaObject;
import com.sangcomz.fishbun.bean.MediaType;
import com.sangcomz.fishbun.define.Define;
import com.sangcomz.fishbun.util.ProcessGalleryFile;
import com.sangcomz.fishbun.videomodule.adapter.VideoGalleryAdapter;
import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class VideoAlbumGalleryActivity
extends AppCompatActivity {
    private RelativeLayout noAlbum;
    private ArrayList<MediaObject> mVideoArrayList = new ArrayList();
    private String bucketName;
    private GridView mGridView;
    Set<ProcessGalleryFile> tasks = new HashSet<ProcessGalleryFile>();
    private VideoGalleryAdapter mAdapter;
    private int mPickCount = 1;
    private String pathDir;

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.activity_video_gallery);
        this.bucketName = this.getIntent().getStringExtra("bucketName");
        this.mPickCount = this.getIntent().getIntExtra("pickCount", 1);
        this.noAlbum = (RelativeLayout)this.findViewById(R.id.no_album);
        this.mGridView = (GridView)this.findViewById(R.id.gridview);
        Toolbar toolbar = (Toolbar)this.findViewById(R.id.toolbar);
        this.setSupportActionBar(toolbar);
        this.getSupportActionBar().setDisplayHomeAsUpEnabled(true);
        toolbar.setBackgroundColor(Define.ACTIONBAR_COLOR);
        if (Build.VERSION.SDK_INT >= 23) {
            boolean isStoragePermissionGiven = MSupport.checkPermissionWithRationale((Activity)this, null, "android.permission.WRITE_EXTERNAL_STORAGE", 2);
            if (isStoragePermissionGiven) {
                new GetVideoListAsync().execute(new Void[0]);
            }
        } else {
            new GetVideoListAsync().execute(new Void[0]);
        }
    }

    public void onRequestPermissionsResult(int requestCode, String[] permissions, int[] grantResults) {
        switch (requestCode) {
            case 2: {
                if (grantResults[0] == 0) {
                    new GetVideoListAsync().execute(new Void[0]);
                    break;
                }
                Toast.makeText((Context)this, (CharSequence)"Storage permission not granted", (int)0).show();
                this.finish();
            }
        }
    }

    private void getAlbumVideos(String bucketName) {
        try {
            String orderBy = "datetaken";
            String searchParams = null;
            String bucket = bucketName;
            searchParams = "bucket_display_name = \"" + bucket + "\"";
            Cursor mVideoCursor = this.getContentResolver().query(MediaStore.Video.Media.EXTERNAL_CONTENT_URI, null, searchParams, null, "datetaken DESC");
            if (mVideoCursor != null && mVideoCursor.moveToFirst()) {
                this.mVideoArrayList = new ArrayList();
                do {
                    String filePath = mVideoCursor.getString(mVideoCursor.getColumnIndex("_data"));
                    long creationDate = VideoAlbumGalleryActivity.getCreationDate(filePath);
                    this.setPathDir(filePath, mVideoCursor.getString(mVideoCursor.getColumnIndex("_display_name")));
                    MediaObject mediaObject = new MediaObject(mVideoCursor.getInt(0), filePath, MediaType.VIDEO, creationDate);
                    this.mVideoArrayList.add(mediaObject);
                } while (mVideoCursor.moveToNext());
                mVideoCursor.close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static long getCreationDate(String filePath) {
        File file = new File(filePath);
        return file.lastModified();
    }

    public boolean onCreateOptionsMenu(Menu menu2) {
        this.getMenuInflater().inflate(R.menu.menu_video_album, menu2);
        return true;
    }

    public boolean onOptionsItemSelected(MenuItem item) {
        int id2 = item.getItemId();
        if (id2 == R.id.action_ok) {
            ArrayList<String> allPath = this.mAdapter.getSelectedStringArray();
            if (!allPath.isEmpty()) {
                if (allPath.size() > this.mPickCount) {
                    Snackbar.make((View)this.findViewById(R.id.parent), (CharSequence)"You can select only 1 video", (int)-1).show();
                } else {
                    Intent data = new Intent().putStringArrayListExtra("all_path", allPath);
                    this.setResult(-1, data);
                    this.finish();
                }
            } else {
                Snackbar.make((View)this.findViewById(R.id.parent), (CharSequence)"Please select a video.", (int)-1).show();
            }
            return true;
        }
        if (id2 == 16908332) {
            Intent data = new Intent();
            this.setResult(0, data);
            this.finish();
        } else if (id2 == R.id.take_video) {
            this.openVideoFromCamera();
        }
        return super.onOptionsItemSelected(item);
    }

    private void setPathDir(String path, String fileName) {
        this.pathDir = path.replace("/" + fileName, "");
    }

    private String getPathDir() {
        if (TextUtils.isEmpty((CharSequence)this.pathDir)) {
            this.pathDir = Environment.getExternalStoragePublicDirectory((String)Environment.DIRECTORY_PICTURES).getAbsolutePath();
        }
        return this.pathDir;
    }

    public void openVideoFromCamera() {
        String filePath = this.pathDir + "/" + System.currentTimeMillis() + "_video.mp4";
        File file = new File(filePath);
        try {
            ContentValues values = new ContentValues();
            values.put("title", file.getName());
            values.put("mime_type", "video/mp4");
            values.put("bucket_display_name", this.bucketName);
            Uri videoUriFromCamera = this.getContentResolver().insert(MediaStore.Video.Media.EXTERNAL_CONTENT_URI, values);
            Log.i((String)"Inserted ", (String)(videoUriFromCamera != null ? videoUriFromCamera.getPath() : ""));
            Intent intent = new Intent("android.media.action.VIDEO_CAPTURE");
            intent.putExtra("output", (Parcelable)Uri.parse((String)("file://" + filePath)));
        }
        catch (Exception e) {
            e.printStackTrace();
            Snackbar.make((View)this.findViewById(R.id.parent), (int)R.string.sd_card_not_avail, (int)-1).show();
        }
    }

    public class GetVideoListAsync
    extends AsyncTask<Void, Void, Boolean> {
        protected Boolean doInBackground(Void ... params) {
            VideoAlbumGalleryActivity.this.mVideoArrayList.clear();
            VideoAlbumGalleryActivity.this.getAlbumVideos(VideoAlbumGalleryActivity.this.bucketName);
            return !VideoAlbumGalleryActivity.this.mVideoArrayList.isEmpty();
        }

        protected void onPostExecute(Boolean result) {
            super.onPostExecute((Object)result);
            VideoAlbumGalleryActivity.this.getPathDir();
            if (result.booleanValue()) {
                VideoAlbumGalleryActivity.this.noAlbum.setVisibility(8);
                VideoAlbumGalleryActivity.this.mAdapter = new VideoGalleryAdapter((Context)VideoAlbumGalleryActivity.this, VideoAlbumGalleryActivity.this.mVideoArrayList);
                VideoAlbumGalleryActivity.this.mGridView.setAdapter((ListAdapter)VideoAlbumGalleryActivity.this.mAdapter);
                VideoAlbumGalleryActivity.this.mGridView.setOnScrollListener(new AbsListView.OnScrollListener(){

                    public void onScroll(AbsListView view, int firstVisibleItem, int visibleItemCount, int totalItemCount) {
                    }

                    public void onScrollStateChanged(AbsListView view, int scrollState) {
                        if (scrollState == 0) {
                            VideoAlbumGalleryActivity.this.mAdapter.setFirstTime(false);
                            int count = view.getChildCount();
                            for (int i = 0; i < count; ++i) {
                                View convertView = view.getChildAt(i);
                                VideoGalleryAdapter.ViewHolder holder = (VideoGalleryAdapter.ViewHolder)convertView.getTag();
                                if (holder == null) {
                                    return;
                                }
                                ProcessGalleryFile processGalleryFile = new ProcessGalleryFile(holder.imgThumb, holder.videoDuration, holder.object.getPath(), holder.object.getMediaType());
                                if (VideoAlbumGalleryActivity.this.tasks == null) {
                                    VideoAlbumGalleryActivity.this.tasks = new HashSet<ProcessGalleryFile>();
                                }
                                if (VideoAlbumGalleryActivity.this.tasks.contains((Object)processGalleryFile)) continue;
                                try {
                                    processGalleryFile.execute(new Void[0]);
                                    VideoAlbumGalleryActivity.this.tasks.add(processGalleryFile);
                                    continue;
                                }
                                catch (Exception ignored) {
                                    // empty catch block
                                }
                            }
                        } else {
                            try {
                                this.cancelAll();
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                    }

                    public void cancelAll() throws Exception {
                        Iterator<ProcessGalleryFile> iterator = VideoAlbumGalleryActivity.this.tasks.iterator();
                        while (iterator.hasNext()) {
                            iterator.next().cancel(true);
                            iterator.remove();
                        }
                    }
                });
                VideoAlbumGalleryActivity.this.mGridView.setAdapter((ListAdapter)VideoAlbumGalleryActivity.this.mAdapter);
                VideoAlbumGalleryActivity.this.mGridView.setOnItemClickListener(new AdapterView.OnItemClickListener(){

                    public void onItemClick(AdapterView<?> adapterView, View view, int i, long l) {
                    }
                });
            } else {
                VideoAlbumGalleryActivity.this.noAlbum.setVisibility(0);
            }
        }
    }
}

