/*
 * Decompiled with CFR 0.152.
 */
package com.luminous.pick;

import android.annotation.SuppressLint;
import android.app.ProgressDialog;
import android.content.ActivityNotFoundException;
import android.content.ContentValues;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.database.Cursor;
import android.graphics.Bitmap;
import android.media.ThumbnailUtils;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.provider.DocumentsContract;
import android.provider.MediaStore;
import android.support.v4.app.FragmentActivity;
import android.support.v4.view.PagerAdapter;
import android.support.v7.app.AlertDialog;
import android.support.v7.app.AppCompatActivity;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.support.v7.widget.Toolbar;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.Menu;
import android.view.MenuItem;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AdapterView;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.Toast;
import com.bumptech.glide.Glide;
import com.bumptech.glide.request.animation.GlideAnimation;
import com.bumptech.glide.request.target.SimpleTarget;
import com.bumptech.glide.request.target.Target;
import com.luminous.pick.CustomGallery;
import com.luminous.pick.ImageListRecycleAdapter;
import com.luminous.pick.R;
import com.luminous.pick.controller.MediaSingleTon;
import com.luminous.pick.utils.VideoQuality;
import com.luminous.pick.utils.ViewPagerSwipeLess;
import com.sangcomz.fishbun.define.Define;
import java.util.ArrayList;
import java.util.HashMap;

public class VideoPickActivity
extends AppCompatActivity {
    private static final int ACTION_REQUEST_VIDEO_FROM_CAMERA = 201;
    private static final int ACTION_REQUEST_VIDEO_FROM_GALLERY = 202;
    private static AlertDialog alertDialog;
    String action = "luminous.ACTION_PICK";
    private ViewPagerSwipeLess mPager;
    private HashMap<String, CustomGallery> dataT;
    private CustomPagerAdapter adapter;
    private ImageListRecycleAdapter mImageListAdapter;
    private long videoSize;
    private int videoDuration;
    private int videoQuality = VideoQuality.HIGH_QUALITY.getQuality();
    Bitmap thumbnail = null;
    ProgressDialog progressDialog;

    public static void showAlertDialog(Context mContext, String text) {
        alertDialog = new AlertDialog.Builder(mContext).setMessage((CharSequence)text).setCancelable(false).setPositiveButton((CharSequence)"OK", new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                alertDialog.dismiss();
            }
        }).create();
        alertDialog.show();
    }

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.activity_video_preview);
        Toolbar toolbar = (Toolbar)this.findViewById(R.id.toolbar);
        this.setSupportActionBar(toolbar);
        toolbar.setBackgroundColor(Define.ACTIONBAR_COLOR);
        this.getSupportActionBar().setDisplayHomeAsUpEnabled(true);
        this.progressDialog = new ProgressDialog((Context)this);
        this.progressDialog.setMessage((CharSequence)"Please wait ...");
        this.progressDialog.setCancelable(false);
        this.mPager = (ViewPagerSwipeLess)this.findViewById(R.id.pager);
        this.dataT = new HashMap();
        this.adapter = new CustomPagerAdapter(this.dataT);
        this.mPager.setAdapter(this.adapter);
        this.mImageListAdapter = new ImageListRecycleAdapter((Context)this, this.dataT);
        RecyclerView mRecycleView = (RecyclerView)this.findViewById(R.id.image_hlistview);
        mRecycleView.setLayoutManager((RecyclerView.LayoutManager)new LinearLayoutManager((Context)this, 0, false));
        mRecycleView.setAdapter((RecyclerView.Adapter)this.mImageListAdapter);
        this.mImageListAdapter.setOnItemClickListener(new AdapterView.OnItemClickListener(){

            public void onItemClick(AdapterView<?> parent, View view, int position, long id2) {
                VideoPickActivity.this.mPager.setCurrentItem(position);
            }
        });
        if (this.getIntent().getAction() != null) {
            this.action = this.getIntent().getAction();
        }
        try {
            this.videoSize = this.getIntent().getExtras().getLong("videoSize");
            this.videoDuration = (int)this.getIntent().getExtras().getLong("videoDuration");
            this.videoQuality = this.getIntent().getExtras().getInt("videoQuality");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.openVideoFromCamera();
    }

    private void showVideoChooserDialog() {
        AlertDialog alertDialog = new AlertDialog.Builder((Context)this).create();
        alertDialog.setTitle((CharSequence)"Select Video");
        alertDialog.setMessage((CharSequence)"Select video source.");
        alertDialog.setIcon(R.drawable.ic_launcher);
        alertDialog.setButton(-2, (CharSequence)"Gallery", new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int id2) {
            }
        });
        alertDialog.setButton(-1, (CharSequence)"Camera", new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int id2) {
                VideoPickActivity.this.openVideoFromCamera();
            }
        });
        alertDialog.show();
    }

    public void openVideoFromCamera() {
        ContentValues values = new ContentValues();
        String fileName = System.currentTimeMillis() + ".mp4";
        values.put("title", fileName);
        values.put("mime_type", "video/mp4");
        try {
            Uri videoUriFromCamera = this.getContentResolver().insert(MediaStore.Video.Media.EXTERNAL_CONTENT_URI, values);
            Intent intent = new Intent("android.media.action.VIDEO_CAPTURE");
            intent.putExtra("android.intent.extra.videoQuality", this.videoQuality);
            if (this.videoSize != -1L) {
                intent.putExtra("android.intent.extra.sizeLimit", this.videoSize);
            }
            if (this.videoDuration != -1) {
                intent.putExtra("android.intent.extra.durationLimit", this.videoDuration);
            }
            this.startActivityForResult(intent, 201);
        }
        catch (Exception e) {
            e.printStackTrace();
            Toast.makeText((Context)this, (CharSequence)"SD-Card not available", (int)1).show();
        }
    }

    void openVideoFromGallery() {
        try {
            Intent intent = new Intent();
            intent.setType("video/*");
            intent.setAction("android.intent.action.GET_CONTENT");
            this.startActivityForResult(Intent.createChooser((Intent)intent, (CharSequence)"Select Video"), 202);
        }
        catch (Exception e) {
            VideoPickActivity.showAlertDialog((Context)this, "Device does not support video pick.");
        }
    }

    void getBitmapFromPath(final CustomGallery item) {
        this.progressDialog.show();
        try {
            Handler mHandler = new Handler();
            mHandler.post(new Runnable(){

                @Override
                public void run() {
                    try {
                        item.bitmap = VideoPickActivity.this.thumbnail = ThumbnailUtils.createVideoThumbnail((String)item.sdcardPath, (int)1);
                        VideoPickActivity.this.dataT.put(item.sdcardPath, item);
                        VideoPickActivity.this.mImageListAdapter.customNotify(VideoPickActivity.this.dataT);
                        VideoPickActivity.this.adapter.customNotify(VideoPickActivity.this.dataT);
                        VideoPickActivity.this.progressDialog.dismiss();
                    }
                    catch (Exception e) {
                        VideoPickActivity.this.progressDialog.dismiss();
                        e.printStackTrace();
                    }
                }
            });
            Log.w((String)"videoPath", (String)item.sdcardPath);
        }
        catch (Exception e) {
            this.progressDialog.dismiss();
            e.printStackTrace();
        }
    }

    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        if (resultCode == -1) {
            String videoUriFromCamera = "";
            if (this.action.equals("luminous.ACTION_PICK")) {
                this.dataT.clear();
            }
            if (requestCode == 201) {
                String[] projection = new String[]{"_data"};
                Cursor cursor = this.getContentResolver().query(data.getData(), projection, null, null, null);
                int column_index_data = cursor.getColumnIndexOrThrow("_data");
                cursor.moveToFirst();
                videoUriFromCamera = cursor.getString(column_index_data);
            } else if (requestCode == 202) {
                Cursor cursor = this.getContentResolver().query(data.getData(), new String[]{"_data", "duration", "_size"}, null, null, null);
                cursor.moveToFirst();
                videoUriFromCamera = cursor.getString(cursor.getColumnIndexOrThrow("_data"));
                if (videoUriFromCamera == null) {
                    videoUriFromCamera = this.getPath(data.getData(), (Context)this);
                }
            }
            if (videoUriFromCamera != null) {
                CustomGallery item = new CustomGallery();
                item.sdcardPath = videoUriFromCamera;
                item.sdCardUri = Uri.parse((String)videoUriFromCamera);
                this.getBitmapFromPath(item);
            }
        } else if (this.dataT == null || this.dataT.size() == 0) {
            Intent data2 = new Intent();
            this.setResult(0, data2);
            this.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressLint(value={"NewApi"})
    private String getPath(Uri uri, Context context) {
        Cursor cursor;
        if (uri == null) {
            return null;
        }
        String[] projection = new String[]{"_data"};
        if (Build.VERSION.SDK_INT > 19) {
            String wholeID = DocumentsContract.getDocumentId((Uri)uri);
            String id2 = wholeID.split(":")[1];
            String sel = "_id=?";
            cursor = context.getContentResolver().query(MediaStore.Video.Media.EXTERNAL_CONTENT_URI, projection, sel, new String[]{id2}, null);
        } else {
            cursor = context.getContentResolver().query(uri, projection, null, null, null);
        }
        String path = null;
        try {
            int column_index = cursor.getColumnIndex("_data");
            cursor.moveToFirst();
            path = cursor.getString(column_index);
        }
        catch (NullPointerException e) {
            e.printStackTrace();
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
        }
        return path;
    }

    protected void onDestroy() {
        super.onDestroy();
        if (this.dataT != null && this.dataT.size() > 0) {
            ArrayList<CustomGallery> dataT2 = new ArrayList<CustomGallery>(this.dataT.values());
            for (int i = 0; i < dataT2.size(); ++i) {
                if (null == dataT2.get((int)i).bitmap) continue;
                dataT2.get((int)i).bitmap.recycle();
            }
        }
    }

    public boolean onCreateOptionsMenu(Menu menu2) {
        this.getMenuInflater().inflate(R.menu.menu_video_pick, menu2);
        return true;
    }

    public boolean onOptionsItemSelected(MenuItem item) {
        String imagePath;
        CustomGallery customGallery;
        int id2 = item.getItemId();
        if (id2 == R.id.action_ok) {
            ArrayList<CustomGallery> mArrayList = new ArrayList<CustomGallery>(this.dataT.values());
            if (mArrayList.size() > 0) {
                ArrayList<String> allPath = new ArrayList<String>();
                for (int i = 0; i < mArrayList.size(); ++i) {
                    allPath.add(mArrayList.get((int)i).sdcardPath);
                }
                Intent data = new Intent().putStringArrayListExtra("all_path", allPath);
                this.setResult(-1, data);
                this.finish();
            } else {
                VideoPickActivity.showAlertDialog((Context)this, "Please select a video.");
            }
        } else if (id2 == 16908332) {
            Intent data = new Intent();
            this.setResult(0, data);
            this.finish();
        } else if (id2 == R.id.action_pick) {
            this.openVideoFromCamera();
        } else if (id2 == R.id.delete && this.adapter != null && this.adapter.getCount() > 0 && (customGallery = this.dataT.remove(imagePath = this.mImageListAdapter.mItems.get((int)this.mPager.getCurrentItem()).sdcardPath)) != null) {
            this.mImageListAdapter.customNotify(this.dataT);
            this.adapter.customNotify(this.dataT);
        }
        return super.onOptionsItemSelected(item);
    }

    class CustomPagerAdapter
    extends PagerAdapter {
        LayoutInflater mLayoutInflater;
        ArrayList<CustomGallery> dataT;

        public CustomPagerAdapter(HashMap<String, CustomGallery> dataT) {
            this.dataT = new ArrayList<CustomGallery>(dataT.values());
            this.mLayoutInflater = (LayoutInflater)VideoPickActivity.this.getSystemService("layout_inflater");
        }

        public void customNotify(HashMap<String, CustomGallery> dataHashmap) {
            this.dataT.clear();
            ArrayList<CustomGallery> dataT2 = new ArrayList<CustomGallery>(dataHashmap.values());
            this.dataT.addAll(dataT2);
            this.notifyDataSetChanged();
        }

        public int getCount() {
            return this.dataT.size();
        }

        public boolean isViewFromObject(View view, Object object) {
            return view == (FrameLayout)object;
        }

        public int getItemPosition(Object object) {
            return -2;
        }

        public Object instantiateItem(ViewGroup container, final int position) {
            View itemView = this.mLayoutInflater.inflate(R.layout.video_image_pager_item, container, false);
            final ImageView imageView = (ImageView)itemView.findViewById(R.id.full_screen_image);
            if (this.dataT.get((int)position).bitmap != null) {
                imageView.setImageBitmap(this.dataT.get((int)position).bitmap);
            } else if (MediaSingleTon.getInstance().getBitmapHashMap().containsKey(this.dataT.get((int)position).sdcardPath)) {
                imageView.setImageBitmap(MediaSingleTon.getInstance().getBitmapHashMap().get(this.dataT.get((int)position).sdcardPath));
            } else {
                Glide.with((FragmentActivity)VideoPickActivity.this).load(Uri.parse((String)("file://" + this.dataT.get((int)position).sdcardPath))).asBitmap().into((Target)new SimpleTarget<Bitmap>(100, 100){

                    public void onResourceReady(Bitmap resource, GlideAnimation glideAnimation) {
                        MediaSingleTon.getInstance().getBitmapHashMap().put(CustomPagerAdapter.this.dataT.get((int)position).sdcardPath, resource);
                        imageView.setImageBitmap(resource);
                    }
                });
            }
            container.addView(itemView);
            itemView.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    block2: {
                        try {
                            Intent intent = new Intent("android.intent.action.VIEW");
                            intent.setDataAndType(Uri.parse((String)CustomPagerAdapter.this.dataT.get((int)position).sdcardPath), "video/*");
                            VideoPickActivity.this.startActivity(Intent.createChooser((Intent)intent, (CharSequence)"Complete action using .."));
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            if (!(e instanceof ActivityNotFoundException)) break block2;
                            VideoPickActivity.showAlertDialog((Context)VideoPickActivity.this, "Video Player not found");
                        }
                    }
                }
            });
            return itemView;
        }

        public void destroyItem(ViewGroup container, int position, Object object) {
            container.removeView((View)((FrameLayout)object));
        }
    }
}

