/*
 * Decompiled with CFR 0.152.
 */
package com.luminous.pick;

import android.app.Activity;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.graphics.Bitmap;
import android.net.Uri;
import android.os.AsyncTask;
import android.os.Bundle;
import android.support.v4.view.PagerAdapter;
import android.support.v4.view.ViewPager;
import android.support.v7.app.AlertDialog;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AdapterView;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.bumptech.glide.Glide;
import com.bumptech.glide.request.animation.GlideAnimation;
import com.bumptech.glide.request.target.SimpleTarget;
import com.bumptech.glide.request.target.Target;
import com.luminous.pick.CustomGallery;
import com.luminous.pick.CustomGalleryActivity;
import com.luminous.pick.ImageListRecycleAdapter;
import com.luminous.pick.R;
import com.luminous.pick.controller.MediaSingleTon;
import com.luminous.pick.utils.BitmapDecoder;
import com.luminous.pick.utils.CameraUtils;
import com.luminous.pick.utils.ViewPagerSwipeLess;
import crop.Crop;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;

public class MultipleImagePreviewActivity
extends Activity {
    private static final int PICK_IMAGE = 200;
    private static AlertDialog alertDialog;
    String action = "luminous.ACTION_PICK";
    private ViewPagerSwipeLess mPager;
    private HashMap<String, CustomGallery> dataT;
    private CustomPagerAdapter adapter;
    private ImageListRecycleAdapter mImageListAdapter;
    private FrameLayout mDone;
    private int imageQuality;

    public static void showAlertDialog(Context mContext, String text) {
        alertDialog = new AlertDialog.Builder(mContext).setMessage((CharSequence)text).setCancelable(false).setPositiveButton((CharSequence)"OK", new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                alertDialog.dismiss();
            }
        }).create();
        alertDialog.show();
    }

    public void onBackPressed() {
        Intent data2 = new Intent();
        this.setResult(0, data2);
        super.onBackPressed();
    }

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.activity_multiimage_preview);
        this.mPager = (ViewPagerSwipeLess)this.findViewById(R.id.pager);
        this.mDone = (FrameLayout)this.findViewById(R.id.btn_done);
        this.dataT = new HashMap();
        this.adapter = new CustomPagerAdapter(this.dataT);
        this.mPager.setAdapter(this.adapter);
        this.mPager.setOnPageChangeListener(new ViewPager.OnPageChangeListener(){

            public void onPageScrolled(int position, float positionOffset, int positionOffsetPixels) {
            }

            public void onPageSelected(int position) {
            }

            public void onPageScrollStateChanged(int state) {
            }
        });
        this.mImageListAdapter = new ImageListRecycleAdapter((Context)this, this.dataT);
        RecyclerView mRecycleView = (RecyclerView)this.findViewById(R.id.image_hlistview);
        mRecycleView.setLayoutManager((RecyclerView.LayoutManager)new LinearLayoutManager((Context)this, 0, false));
        mRecycleView.setAdapter((RecyclerView.Adapter)this.mImageListAdapter);
        this.mImageListAdapter.setOnItemClickListener(new AdapterView.OnItemClickListener(){

            public void onItemClick(AdapterView<?> parent, View view, int position, long id2) {
                MultipleImagePreviewActivity.this.mPager.setCurrentItem(position);
            }
        });
        this.findViewById(R.id.navigate_crop).setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (MultipleImagePreviewActivity.this.adapter != null && MultipleImagePreviewActivity.this.adapter.getCount() > 0) {
                    String imagePath = ((MultipleImagePreviewActivity)MultipleImagePreviewActivity.this).mImageListAdapter.mItems.get((int)((MultipleImagePreviewActivity)MultipleImagePreviewActivity.this).mPager.getCurrentItem()).sdcardPath;
                    Uri destination = null;
                    try {
                        destination = CameraUtils.createImageFile((Context)MultipleImagePreviewActivity.this);
                        Crop.of(Uri.parse((String)("file://" + imagePath)), destination).asSquare().start(MultipleImagePreviewActivity.this);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        });
        this.findViewById(R.id.add_image_navigate).setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                Intent i = new Intent((Context)MultipleImagePreviewActivity.this, CustomGalleryActivity.class);
                i.setAction(MultipleImagePreviewActivity.this.action);
                MultipleImagePreviewActivity.this.startActivityForResult(i, 200);
            }
        });
        this.findViewById(R.id.btn_cancel).setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                Intent data2 = new Intent();
                MultipleImagePreviewActivity.this.setResult(0, data2);
                MultipleImagePreviewActivity.this.finish();
            }
        });
        ((TextView)this.findViewById(R.id.btn_done_text)).setText((CharSequence)this.getString(R.string.crop__done));
        this.findViewById(R.id.btn_done).setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                ArrayList mArrayList = new ArrayList(MultipleImagePreviewActivity.this.dataT.values());
                if (mArrayList.size() > 0) {
                    String[] allPath = new String[mArrayList.size()];
                    for (int i = 0; i < allPath.length; ++i) {
                        allPath[i] = ((CustomGallery)mArrayList.get((int)i)).sdcardPath;
                    }
                    Intent data = new Intent().putExtra("all_path", allPath);
                    MultipleImagePreviewActivity.this.setResult(-1, data);
                    MultipleImagePreviewActivity.this.finish();
                } else {
                    MultipleImagePreviewActivity.showAlertDialog((Context)MultipleImagePreviewActivity.this, "Please select an image.");
                }
            }
        });
        try {
            boolean isCrop = this.getIntent().getExtras().getBoolean("crop");
            if (isCrop) {
                this.findViewById(R.id.navigate_crop).setVisibility(0);
            } else {
                this.findViewById(R.id.navigate_crop).setVisibility(8);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        Intent i = new Intent((Context)this, CustomGalleryActivity.class);
        if (this.getIntent().getExtras().containsKey("imageQuality")) {
            this.imageQuality = this.getIntent().getExtras().getInt("imageQuality");
        }
        if (this.getIntent().getAction() != null) {
            this.action = this.getIntent().getAction();
        }
        i.setAction(this.action);
        this.startActivityForResult(i, 200);
    }

    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        if (resultCode == -1) {
            if (this.action.equals("luminous.ACTION_PICK")) {
                this.dataT.clear();
            }
            if (requestCode == 200) {
                String[] all_path = data.getStringArrayExtra("all_path");
                if (all_path != null) {
                    if (this.action.equals("luminous.ACTION_PICK") && all_path.length > 0) {
                        new ProcessImageView().execute(new Uri[]{Uri.parse((String)all_path[0])});
                    } else {
                        for (String string2 : all_path) {
                            if (string2 == null) continue;
                            CustomGallery item = new CustomGallery();
                            item.sdcardPath = string2;
                            item.sdCardUri = Uri.parse((String)string2);
                            this.dataT.put(string2, item);
                        }
                    }
                    this.adapter.customNotify(this.dataT);
                    this.mImageListAdapter.customNotify(this.dataT);
                }
            } else if (requestCode == 6709) {
                try {
                    Uri mTargetImageUri = (Uri)data.getExtras().get("output");
                    if (mTargetImageUri != null) {
                        String imagePath = this.mImageListAdapter.mItems.get((int)this.mPager.getCurrentItem()).sdcardPath;
                        CustomGallery item = new CustomGallery();
                        item.sdcardPath = mTargetImageUri.getPath();
                        item.sdCardUri = mTargetImageUri;
                        this.dataT.remove(imagePath);
                        this.dataT.put(mTargetImageUri.getPath(), item);
                        this.adapter.customNotify(this.dataT);
                        this.mImageListAdapter.customNotify(this.dataT);
                    }
                }
                catch (Exception e) {
                    String invalidImageText = (String)data.getExtras().get("invalid_image");
                    if (invalidImageText != null) {
                        MultipleImagePreviewActivity.showAlertDialog((Context)this, invalidImageText);
                    }
                }
            }
        } else if (this.dataT == null || this.dataT.size() <= 0) {
            Intent data2 = new Intent();
            this.setResult(0, data2);
            this.finish();
        }
    }

    class CustomPagerAdapter
    extends PagerAdapter {
        LayoutInflater mLayoutInflater;
        ArrayList<CustomGallery> dataT;

        public CustomPagerAdapter(HashMap<String, CustomGallery> dataT) {
            this.dataT = new ArrayList<CustomGallery>(dataT.values());
            this.mLayoutInflater = (LayoutInflater)MultipleImagePreviewActivity.this.getSystemService("layout_inflater");
        }

        public void customNotify(HashMap<String, CustomGallery> dataHashmap) {
            this.dataT.clear();
            ArrayList<CustomGallery> dataT2 = new ArrayList<CustomGallery>(dataHashmap.values());
            this.dataT.addAll(dataT2);
            this.notifyDataSetChanged();
        }

        public int getCount() {
            return this.dataT.size();
        }

        public boolean isViewFromObject(View view, Object object) {
            return view == (LinearLayout)object;
        }

        public int getItemPosition(Object object) {
            return -2;
        }

        public Object instantiateItem(ViewGroup container, final int position) {
            View itemView = this.mLayoutInflater.inflate(R.layout.image_pager_item, container, false);
            final ImageView imageView = (ImageView)itemView.findViewById(R.id.full_screen_image);
            if (MediaSingleTon.getInstance().getBitmapHashMap().containsKey(this.dataT.get((int)position).sdcardPath)) {
                imageView.setImageBitmap(MediaSingleTon.getInstance().getBitmapHashMap().get(this.dataT.get((int)position).sdcardPath));
            } else {
                Glide.with((Activity)MultipleImagePreviewActivity.this).load(Uri.parse((String)("file://" + this.dataT.get((int)position).sdcardPath))).asBitmap().into((Target)new SimpleTarget<Bitmap>(100, 100){

                    public void onResourceReady(Bitmap resource, GlideAnimation glideAnimation) {
                        MediaSingleTon.getInstance().getBitmapHashMap().put(CustomPagerAdapter.this.dataT.get((int)position).sdcardPath, resource);
                        imageView.setImageBitmap(resource);
                    }
                });
            }
            container.addView(itemView);
            return itemView;
        }

        public void destroyItem(ViewGroup container, int position, Object object) {
            container.removeView((View)((LinearLayout)object));
        }
    }

    class ProcessImageView
    extends AsyncTask<Uri, Void, Void> {
        ProcessImageView() {
        }

        protected Void doInBackground(Uri ... params) {
            CustomGallery item = new CustomGallery();
            item.sdcardPath = params[0].getPath();
            item.sdCardUri = params[0];
            item.sdcardPath = BitmapDecoder.getBitmap(params[0].getPath(), MultipleImagePreviewActivity.this.imageQuality, (Context)MultipleImagePreviewActivity.this);
            item.sdCardUri = Uri.parse((String)item.sdcardPath);
            MultipleImagePreviewActivity.this.dataT.put(item.sdcardPath, item);
            return null;
        }

        protected void onPreExecute() {
            super.onPreExecute();
            MultipleImagePreviewActivity.this.mDone.setEnabled(false);
            MultipleImagePreviewActivity.this.mDone.setClickable(false);
        }

        protected void onPostExecute(Void aVoid) {
            super.onPostExecute((Object)aVoid);
            MultipleImagePreviewActivity.this.adapter.customNotify(MultipleImagePreviewActivity.this.dataT);
            MultipleImagePreviewActivity.this.mImageListAdapter.customNotify(MultipleImagePreviewActivity.this.dataT);
            MultipleImagePreviewActivity.this.mDone.setEnabled(true);
            MultipleImagePreviewActivity.this.mDone.setClickable(true);
        }
    }
}

