/*
 * Decompiled with CFR 0.152.
 */
package com.luminous.pick.utils;

import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.BitmapRegionDecoder;
import android.graphics.Matrix;
import android.graphics.Rect;
import android.media.ExifInterface;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class BitmapDecoder {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getBitmap(String filePath, int outputQuality) {
        if (filePath != null) {
            FileInputStream stream = null;
            File file = null;
            try {
                file = new File(filePath);
                stream = new FileInputStream(file);
            }
            catch (FileNotFoundException e2) {
                e2.printStackTrace();
            }
            BitmapFactory.Options tmpOptions = new BitmapFactory.Options();
            tmpOptions.inJustDecodeBounds = true;
            tmpOptions.inSampleSize = 2;
            BitmapRegionDecoder decoder = null;
            try {
                decoder = BitmapRegionDecoder.newInstance((InputStream)stream, (boolean)false);
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
            finally {
                try {
                    if (stream != null) {
                        stream.close();
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (decoder != null) {
                Bitmap region = decoder.getWidth() > 2000 ? decoder.decodeRegion(new Rect(0, 0, decoder.getWidth(), decoder.getHeight()), tmpOptions) : decoder.decodeRegion(new Rect(0, 0, decoder.getWidth(), decoder.getHeight()), null);
                ExifInterface ei = null;
                try {
                    ei = new ExifInterface(file.getAbsolutePath());
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                int orientation = 0;
                if (ei != null) {
                    orientation = ei.getAttributeInt("Orientation", 1);
                }
                switch (orientation) {
                    case 6: {
                        region = BitmapDecoder.rotateImage(region, 90);
                        break;
                    }
                    case 3: {
                        region = BitmapDecoder.rotateImage(region, 180);
                        break;
                    }
                    case 8: {
                        region = BitmapDecoder.rotateImage(region, 270);
                    }
                }
                FileOutputStream fOut = null;
                try {
                    fOut = new FileOutputStream(file);
                    region.compress(Bitmap.CompressFormat.JPEG, outputQuality, (OutputStream)fOut);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                finally {
                    try {
                        if (fOut != null) {
                            fOut.close();
                        }
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                return filePath;
            }
        }
        return filePath;
    }

    private static Bitmap rotateImage(Bitmap source, int angle) {
        Matrix matrix = new Matrix();
        matrix.postRotate((float)angle);
        source = Bitmap.createBitmap((Bitmap)source, (int)0, (int)0, (int)source.getWidth(), (int)source.getHeight(), (Matrix)matrix, (boolean)true);
        return source;
    }
}

