/*
 * Decompiled with CFR 0.152.
 */
package com.luminous.pick;

import android.content.Context;
import android.graphics.Bitmap;
import android.net.Uri;
import android.support.v7.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AdapterView;
import android.widget.ImageView;
import com.bumptech.glide.Glide;
import com.bumptech.glide.request.animation.GlideAnimation;
import com.bumptech.glide.request.target.SimpleTarget;
import com.bumptech.glide.request.target.Target;
import com.luminous.pick.CustomGallery;
import com.luminous.pick.R;
import com.luminous.pick.controller.MediaSingleTon;
import java.util.ArrayList;
import java.util.HashMap;

public class ImageListRecycleAdapter
extends RecyclerView.Adapter<VerticalItemHolder> {
    private final Context mContext;
    public ArrayList<CustomGallery> mItems;
    MediaSingleTon mediaSingleTon;
    private AdapterView.OnItemClickListener mOnItemClickListener;

    public ImageListRecycleAdapter(Context context, HashMap<String, CustomGallery> imagesUri) {
        this.mContext = context;
        this.mItems = new ArrayList<CustomGallery>(imagesUri.values());
        this.mediaSingleTon = MediaSingleTon.getInstance();
    }

    public void removeItem(int position) {
        if (position >= this.mItems.size()) {
            return;
        }
        this.mItems.remove(position);
        this.notifyItemRemoved(position);
    }

    public void customNotify(HashMap<String, CustomGallery> dataT) {
        this.mItems.clear();
        ArrayList<CustomGallery> dataT2 = new ArrayList<CustomGallery>(dataT.values());
        this.mItems.addAll(dataT2);
        this.notifyDataSetChanged();
    }

    public VerticalItemHolder onCreateViewHolder(ViewGroup container, int viewType) {
        LayoutInflater inflater = LayoutInflater.from((Context)container.getContext());
        View root = inflater.inflate(R.layout.image_strip_view, container, false);
        return new VerticalItemHolder(root, this);
    }

    public void onBindViewHolder(VerticalItemHolder itemHolder, int position) {
        CustomGallery item = this.mItems.get(position);
        if (item.bitmap != null) {
            itemHolder.imageView.setImageBitmap(item.bitmap);
        } else {
            itemHolder.setImage(item.sdcardPath);
        }
    }

    public int getItemCount() {
        return this.mItems.size();
    }

    public void setOnItemClickListener(AdapterView.OnItemClickListener onItemClickListener) {
        this.mOnItemClickListener = onItemClickListener;
    }

    private void onItemHolderClick(VerticalItemHolder itemHolder) {
        if (this.mOnItemClickListener != null) {
            this.mOnItemClickListener.onItemClick(null, itemHolder.itemView, itemHolder.getAdapterPosition(), itemHolder.getItemId());
        }
    }

    class VerticalItemHolder
    extends RecyclerView.ViewHolder
    implements View.OnClickListener {
        private ImageView imageView;
        private ImageListRecycleAdapter mAdapter;

        public VerticalItemHolder(View itemView, ImageListRecycleAdapter adapter) {
            super(itemView);
            itemView.setOnClickListener((View.OnClickListener)this);
            this.mAdapter = adapter;
            this.imageView = (ImageView)itemView.findViewById(R.id.strip_image);
        }

        public void onClick(View v) {
            this.mAdapter.onItemHolderClick(this);
        }

        public void setImage(final String url) {
            if (MediaSingleTon.getInstance().getBitmapHashMap().containsKey(url)) {
                this.imageView.setImageBitmap(MediaSingleTon.getInstance().getBitmapHashMap().get(url));
            } else {
                Glide.with((Context)ImageListRecycleAdapter.this.mContext).load(Uri.parse((String)("file://" + url))).asBitmap().into((Target)new SimpleTarget<Bitmap>(100, 100){

                    public void onResourceReady(Bitmap resource, GlideAnimation glideAnimation) {
                        MediaSingleTon.getInstance().getBitmapHashMap().put(url, resource);
                        VerticalItemHolder.this.imageView.setImageBitmap(resource);
                    }
                });
            }
        }
    }
}

