/*
 * Decompiled with CFR 0.152.
 */
package com.luminous.pick;

import android.app.Activity;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.graphics.Bitmap;
import android.net.Uri;
import android.os.AsyncTask;
import android.os.Bundle;
import android.os.Environment;
import android.os.Parcelable;
import android.support.v4.view.PagerAdapter;
import android.support.v7.app.AlertDialog;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AdapterView;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.bumptech.glide.Glide;
import com.bumptech.glide.request.animation.GlideAnimation;
import com.bumptech.glide.request.target.SimpleTarget;
import com.bumptech.glide.request.target.Target;
import com.luminous.pick.CustomGallery;
import com.luminous.pick.ImageListRecycleAdapter;
import com.luminous.pick.R;
import com.luminous.pick.controller.MediaSingleTon;
import com.luminous.pick.utils.BitmapDecoder;
import com.luminous.pick.utils.CameraUtils;
import com.luminous.pick.utils.ViewPagerSwipeLess;
import crop.Crop;
import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;

public class CameraPickActivity
extends Activity {
    private static final int ACTION_REQUEST_CAMERA = 201;
    private static AlertDialog alertDialog;
    String action = "luminous.ACTION_PICK";
    private ViewPagerSwipeLess mPager;
    private HashMap<String, CustomGallery> dataT;
    private CustomPagerAdapter adapter;
    private ImageListRecycleAdapter mImageListAdapter;
    private Uri userPhotoUri;
    private int imageQuality;

    public static void showAlertDialog(Context mContext, String text) {
        alertDialog = new AlertDialog.Builder(mContext).setMessage((CharSequence)text).setCancelable(false).setPositiveButton((CharSequence)"OK", new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                alertDialog.dismiss();
            }
        }).create();
        alertDialog.show();
    }

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.activity_camera_preview);
        this.mPager = (ViewPagerSwipeLess)this.findViewById(R.id.pager);
        this.dataT = new HashMap();
        this.adapter = new CustomPagerAdapter(this.dataT);
        this.mPager.setAdapter(this.adapter);
        this.mImageListAdapter = new ImageListRecycleAdapter((Context)this, this.dataT);
        RecyclerView mRecycleView = (RecyclerView)this.findViewById(R.id.image_hlistview);
        mRecycleView.setLayoutManager((RecyclerView.LayoutManager)new LinearLayoutManager((Context)this, 0, false));
        mRecycleView.setAdapter((RecyclerView.Adapter)this.mImageListAdapter);
        this.mImageListAdapter.setOnItemClickListener(new AdapterView.OnItemClickListener(){

            public void onItemClick(AdapterView<?> parent, View view, int position, long id2) {
                CameraPickActivity.this.mPager.setCurrentItem(position);
            }
        });
        this.findViewById(R.id.navigate_crop).setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (CameraPickActivity.this.adapter != null && CameraPickActivity.this.adapter.getCount() > 0) {
                    String imagePath = ((CameraPickActivity)CameraPickActivity.this).mImageListAdapter.mItems.get((int)((CameraPickActivity)CameraPickActivity.this).mPager.getCurrentItem()).sdcardPath;
                    Uri destination = null;
                    try {
                        destination = CameraUtils.createImageFile((Context)CameraPickActivity.this);
                        Crop.of(Uri.parse((String)("file://" + imagePath)), destination).asSquare().start(CameraPickActivity.this);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        });
        this.findViewById(R.id.add_image_navigate).setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                CameraPickActivity.this.openCamera();
            }
        });
        this.findViewById(R.id.btn_cancel).setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                Intent data2 = new Intent();
                CameraPickActivity.this.setResult(0, data2);
                CameraPickActivity.this.finish();
            }
        });
        ((TextView)this.findViewById(R.id.btn_done_text)).setText((CharSequence)this.getString(R.string.crop__done));
        this.findViewById(R.id.btn_done).setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                ArrayList mArrayList = new ArrayList(CameraPickActivity.this.dataT.values());
                if (mArrayList.size() > 0) {
                    String[] allPath = new String[mArrayList.size()];
                    for (int i = 0; i < allPath.length; ++i) {
                        allPath[i] = ((CustomGallery)mArrayList.get((int)i)).sdcardPath;
                    }
                    Intent data = new Intent().putExtra("all_path", allPath);
                    CameraPickActivity.this.setResult(-1, data);
                    CameraPickActivity.this.finish();
                } else {
                    CameraPickActivity.showAlertDialog((Context)CameraPickActivity.this, "Please select an image.");
                }
            }
        });
        try {
            boolean isCrop = this.getIntent().getExtras().getBoolean("crop");
            if (isCrop) {
                this.findViewById(R.id.navigate_crop).setVisibility(0);
            } else {
                this.findViewById(R.id.navigate_crop).setVisibility(8);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (this.getIntent().getExtras().containsKey("imageQuality")) {
            this.imageQuality = this.getIntent().getExtras().getInt("imageQuality");
        }
        if (this.getIntent().getAction() != null) {
            this.action = this.getIntent().getAction();
        }
        this.openCamera();
    }

    public void onBackPressed() {
        Intent data2 = new Intent();
        this.setResult(0, data2);
        super.onBackPressed();
    }

    void openCamera() {
        try {
            Intent takePictureIntent = new Intent("android.media.action.IMAGE_CAPTURE");
            if (takePictureIntent.resolveActivity(this.getPackageManager()) != null) {
                this.createImageFile();
                takePictureIntent.putExtra("output", (Parcelable)this.userPhotoUri);
                this.startActivityForResult(takePictureIntent, 201);
            }
        }
        catch (Exception e) {
            CameraPickActivity.showAlertDialog((Context)this, "Device does not support camera.");
        }
    }

    private void createImageFile() throws IOException {
        File image = null;
        String timeStamp = new SimpleDateFormat("yyyyMMdd_HHmmss").format(new Date());
        String imageFileName = "JPEG_" + timeStamp + "_";
        if ("mounted".equals(Environment.getExternalStorageState())) {
            File storageDir = Environment.getExternalStoragePublicDirectory((String)Environment.DIRECTORY_PICTURES);
            image = File.createTempFile(imageFileName, ".jpg", storageDir);
        } else {
            File storageDir = this.getFilesDir();
            image = File.createTempFile(imageFileName, ".jpg", storageDir);
        }
        Log.d((String)CameraPickActivity.class.getSimpleName(), (String)("file:" + image.getAbsolutePath()));
        this.userPhotoUri = Uri.fromFile((File)image);
    }

    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        if (resultCode == -1) {
            if (requestCode == 201) {
                if (this.action.equals("luminous.ACTION_PICK")) {
                    this.dataT.clear();
                }
                if (this.userPhotoUri != null) {
                    new ProcessImageView().execute(new Void[0]);
                }
            } else if (requestCode == 6709) {
                try {
                    Uri mTargetImageUri = (Uri)data.getExtras().get("output");
                    if (mTargetImageUri != null) {
                        String imagePath = this.mImageListAdapter.mItems.get((int)this.mPager.getCurrentItem()).sdcardPath;
                        CustomGallery item = new CustomGallery();
                        item.sdcardPath = mTargetImageUri.getPath();
                        item.sdCardUri = mTargetImageUri;
                        this.dataT.remove(imagePath);
                        this.dataT.put(mTargetImageUri.getPath(), item);
                        this.adapter.customNotify(this.dataT);
                        this.mImageListAdapter.customNotify(this.dataT);
                    }
                }
                catch (Exception e) {
                    String invalidImageText = (String)data.getExtras().get("invalid_image");
                    if (invalidImageText != null) {
                        CameraPickActivity.showAlertDialog((Context)this, invalidImageText);
                    }
                }
            }
        } else if (this.dataT == null || this.dataT.size() == 0) {
            Intent data2 = new Intent();
            this.setResult(0, data2);
            this.finish();
        }
    }

    class CustomPagerAdapter
    extends PagerAdapter {
        LayoutInflater mLayoutInflater;
        ArrayList<CustomGallery> dataT;
        MediaSingleTon mediaSingleTon;

        public CustomPagerAdapter(HashMap<String, CustomGallery> dataT) {
            this.dataT = new ArrayList<CustomGallery>(dataT.values());
            this.mLayoutInflater = (LayoutInflater)CameraPickActivity.this.getSystemService("layout_inflater");
            this.mediaSingleTon = MediaSingleTon.getInstance();
        }

        public void customNotify(HashMap<String, CustomGallery> dataHashmap) {
            this.dataT.clear();
            ArrayList<CustomGallery> dataT2 = new ArrayList<CustomGallery>(dataHashmap.values());
            this.dataT.addAll(dataT2);
            this.notifyDataSetChanged();
        }

        public int getCount() {
            return this.dataT.size();
        }

        public boolean isViewFromObject(View view, Object object) {
            return view == (LinearLayout)object;
        }

        public int getItemPosition(Object object) {
            return -2;
        }

        public Object instantiateItem(ViewGroup container, final int position) {
            View itemView = this.mLayoutInflater.inflate(R.layout.image_pager_item, container, false);
            final ImageView imageView = (ImageView)itemView.findViewById(R.id.full_screen_image);
            if (this.mediaSingleTon.getBitmapHashMap().containsKey(this.dataT.get((int)position).sdcardPath)) {
                imageView.setImageBitmap(this.mediaSingleTon.getBitmapHashMap().get(this.dataT.get((int)position).sdcardPath));
            } else {
                Glide.with((Activity)CameraPickActivity.this).load(Uri.parse((String)("file://" + this.dataT.get((int)position).sdcardPath))).asBitmap().into((Target)new SimpleTarget<Bitmap>(100, 100){

                    public void onResourceReady(Bitmap resource, GlideAnimation glideAnimation) {
                        CustomPagerAdapter.this.mediaSingleTon.getBitmapHashMap().put(CustomPagerAdapter.this.dataT.get((int)position).sdcardPath, resource);
                        imageView.setImageBitmap(resource);
                    }
                });
            }
            container.addView(itemView);
            return itemView;
        }

        public void destroyItem(ViewGroup container, int position, Object object) {
            container.removeView((View)((LinearLayout)object));
        }
    }

    class ProcessImageView
    extends AsyncTask<Void, Void, Void> {
        ProcessImageView() {
        }

        protected Void doInBackground(Void ... params) {
            CustomGallery item = new CustomGallery();
            item.sdcardPath = CameraPickActivity.this.userPhotoUri.getPath();
            item.sdCardUri = CameraPickActivity.this.userPhotoUri;
            item.sdcardPath = BitmapDecoder.getBitmap(CameraPickActivity.this.userPhotoUri.getPath(), CameraPickActivity.this.imageQuality);
            item.sdCardUri = Uri.parse((String)item.sdcardPath);
            CameraPickActivity.this.dataT.put(item.sdcardPath, item);
            return null;
        }

        protected void onPostExecute(Void aVoid) {
            super.onPostExecute((Object)aVoid);
            CameraPickActivity.this.adapter.customNotify(CameraPickActivity.this.dataT);
            CameraPickActivity.this.mImageListAdapter.customNotify(CameraPickActivity.this.dataT);
        }
    }
}

