/*
 * Decompiled with CFR 0.152.
 */
package com.luminous.pick;

import android.app.Activity;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.database.Cursor;
import android.graphics.Bitmap;
import android.os.Bundle;
import android.os.Environment;
import android.os.Handler;
import android.os.Looper;
import android.provider.MediaStore;
import android.support.v7.app.AlertDialog;
import android.view.View;
import android.widget.AbsListView;
import android.widget.AdapterView;
import android.widget.FrameLayout;
import android.widget.GridView;
import android.widget.ImageView;
import android.widget.ListAdapter;
import com.luminous.pick.CustomGallery;
import com.luminous.pick.GalleryAdapter;
import com.luminous.pick.R;
import com.nostra13.universalimageloader.cache.disc.DiskCache;
import com.nostra13.universalimageloader.cache.disc.impl.UnlimitedDiscCache;
import com.nostra13.universalimageloader.cache.memory.MemoryCache;
import com.nostra13.universalimageloader.cache.memory.impl.WeakMemoryCache;
import com.nostra13.universalimageloader.core.DisplayImageOptions;
import com.nostra13.universalimageloader.core.ImageLoader;
import com.nostra13.universalimageloader.core.ImageLoaderConfiguration;
import com.nostra13.universalimageloader.core.assist.ImageScaleType;
import com.nostra13.universalimageloader.core.listener.PauseOnScrollListener;
import com.nostra13.universalimageloader.utils.StorageUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;

public class CustomGalleryActivity
extends Activity {
    GridView gridGallery;
    Handler handler;
    GalleryAdapter adapter;
    ImageView imgNoMedia;
    FrameLayout btnGalleryOk;
    String action;
    View.OnClickListener mOkClickListener = new View.OnClickListener(){

        public void onClick(View v) {
            String[] allPath = CustomGalleryActivity.this.adapter.getSelectedStringArray();
            if (allPath.length > 0) {
                if (allPath.length > 10) {
                    CustomGalleryActivity.this.showAlertDialog((Context)CustomGalleryActivity.this, "Please select only 10 images at a time");
                } else {
                    Intent data = new Intent().putExtra("all_path", allPath);
                    CustomGalleryActivity.this.setResult(-1, data);
                    CustomGalleryActivity.this.finish();
                }
            } else {
                CustomGalleryActivity.this.showAlertDialog((Context)CustomGalleryActivity.this, "Please select an image.");
            }
        }
    };
    AdapterView.OnItemClickListener mItemMulClickListener = new AdapterView.OnItemClickListener(){

        public void onItemClick(AdapterView<?> l, View v, int position, long id2) {
            CustomGalleryActivity.this.adapter.changeSelection(v, position);
            String[] allPath = CustomGalleryActivity.this.adapter.getSelectedStringArray();
            if (allPath != null && allPath.length > 10) {
                CustomGalleryActivity.this.showAlertDialog((Context)CustomGalleryActivity.this, "Please select only 10 images at a time");
                CustomGalleryActivity.this.adapter.changeSelection(v, position);
            }
        }
    };
    AdapterView.OnItemClickListener mItemSingleClickListener = new AdapterView.OnItemClickListener(){

        public void onItemClick(AdapterView<?> l, View v, int position, long id2) {
            CustomGallery item = CustomGalleryActivity.this.adapter.getItem(position);
            String[] allPath = new String[]{item.sdcardPath};
            Intent data = new Intent().putExtra("all_path", allPath);
            CustomGalleryActivity.this.setResult(-1, data);
            CustomGalleryActivity.this.finish();
        }
    };
    private ImageLoader imageLoader;
    private FrameLayout btnGalleryCancel;
    private AlertDialog alertDialog;

    void showAlertDialog(Context mContext, String text) {
        this.alertDialog = new AlertDialog.Builder(mContext).setMessage((CharSequence)text).setCancelable(false).setPositiveButton((CharSequence)"OK", new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                CustomGalleryActivity.this.alertDialog.dismiss();
            }
        }).create();
        this.alertDialog.show();
    }

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.requestWindowFeature(1);
        this.setContentView(R.layout.gallery);
        this.action = this.getIntent().getAction();
        if (this.action == null) {
            this.finish();
        }
        this.initImageLoader();
        this.init();
    }

    private void initImageLoader() {
        try {
            String CACHE_DIR = Environment.getExternalStorageDirectory().getAbsolutePath() + "/.temp_tmp";
            new File(CACHE_DIR).mkdirs();
            File cacheDir = StorageUtils.getOwnCacheDirectory((Context)this.getBaseContext(), (String)CACHE_DIR);
            DisplayImageOptions defaultOptions = new DisplayImageOptions.Builder().cacheOnDisk(true).imageScaleType(ImageScaleType.EXACTLY).bitmapConfig(Bitmap.Config.RGB_565).build();
            ImageLoaderConfiguration.Builder builder = new ImageLoaderConfiguration.Builder(this.getBaseContext()).defaultDisplayImageOptions(defaultOptions).diskCache((DiskCache)new UnlimitedDiscCache(cacheDir)).memoryCache((MemoryCache)new WeakMemoryCache());
            ImageLoaderConfiguration config = builder.build();
            this.imageLoader = ImageLoader.getInstance();
            this.imageLoader.init(config);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void init() {
        this.handler = new Handler();
        this.gridGallery = (GridView)this.findViewById(R.id.gridGallery);
        this.gridGallery.setFastScrollEnabled(true);
        this.adapter = new GalleryAdapter(this.getApplicationContext(), this.imageLoader);
        PauseOnScrollListener listener = new PauseOnScrollListener(this.imageLoader, true, true);
        this.gridGallery.setOnScrollListener((AbsListView.OnScrollListener)listener);
        if (this.action.equalsIgnoreCase("luminous.ACTION_MULTIPLE_PICK")) {
            this.findViewById(R.id.llBottomContainer).setVisibility(0);
            this.gridGallery.setOnItemClickListener(this.mItemMulClickListener);
            this.adapter.setMultiplePick(true);
        } else if (this.action.equalsIgnoreCase("luminous.ACTION_PICK")) {
            this.findViewById(R.id.llBottomContainer).setVisibility(8);
            this.gridGallery.setOnItemClickListener(this.mItemSingleClickListener);
            this.adapter.setMultiplePick(false);
        }
        this.gridGallery.setAdapter((ListAdapter)this.adapter);
        this.imgNoMedia = (ImageView)this.findViewById(R.id.imgNoMedia);
        this.btnGalleryOk = (FrameLayout)this.findViewById(R.id.btn_done);
        this.btnGalleryCancel = (FrameLayout)this.findViewById(R.id.btn_cancel);
        this.btnGalleryCancel.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                Intent data = new Intent();
                CustomGalleryActivity.this.setResult(0, data);
                CustomGalleryActivity.this.finish();
            }
        });
        this.btnGalleryOk.setOnClickListener(this.mOkClickListener);
        new Thread(){

            @Override
            public void run() {
                Looper.prepare();
                CustomGalleryActivity.this.handler.post(new Runnable(){

                    @Override
                    public void run() {
                        CustomGalleryActivity.this.adapter.addAll(CustomGalleryActivity.this.getGalleryPhotos());
                        CustomGalleryActivity.this.checkImageStatus();
                    }
                });
                Looper.loop();
            }
        }.start();
    }

    private void checkImageStatus() {
        if (this.adapter.isEmpty()) {
            this.imgNoMedia.setVisibility(0);
        } else {
            this.imgNoMedia.setVisibility(8);
        }
    }

    private ArrayList<CustomGallery> getGalleryPhotos() {
        ArrayList<CustomGallery> galleryList = new ArrayList<CustomGallery>();
        try {
            String[] columns = new String[]{"_data", "_id"};
            String orderBy = "_id";
            Cursor imagecursor = this.managedQuery(MediaStore.Images.Media.EXTERNAL_CONTENT_URI, columns, null, null, "_id");
            if (imagecursor != null && imagecursor.getCount() > 0) {
                while (imagecursor.moveToNext()) {
                    CustomGallery item = new CustomGallery();
                    int dataColumnIndex = imagecursor.getColumnIndex("_data");
                    item.sdcardPath = imagecursor.getString(dataColumnIndex);
                    galleryList.add(item);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        Collections.reverse(galleryList);
        return galleryList;
    }
}

