/*
 * Decompiled with CFR 0.152.
 */
package com.luminous.pick;

import android.app.Activity;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.graphics.Bitmap;
import android.net.Uri;
import android.os.Bundle;
import android.os.Environment;
import android.support.v4.view.PagerAdapter;
import android.support.v4.view.ViewPager;
import android.support.v7.app.AlertDialog;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AdapterView;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.luminous.pick.CustomGallery;
import com.luminous.pick.CustomGalleryActivity;
import com.luminous.pick.ImageListRecycleAdapter;
import com.luminous.pick.R;
import com.luminous.pick.utils.ViewPagerSwipeLess;
import com.nostra13.universalimageloader.cache.disc.DiskCache;
import com.nostra13.universalimageloader.cache.disc.impl.UnlimitedDiscCache;
import com.nostra13.universalimageloader.core.DisplayImageOptions;
import com.nostra13.universalimageloader.core.ImageLoader;
import com.nostra13.universalimageloader.core.ImageLoaderConfiguration;
import com.nostra13.universalimageloader.core.assist.ImageScaleType;
import com.nostra13.universalimageloader.core.listener.ImageLoadingListener;
import com.nostra13.universalimageloader.core.listener.SimpleImageLoadingListener;
import com.nostra13.universalimageloader.utils.StorageUtils;
import crop.Crop;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;

public class MultipleImagePreviewActivity
extends Activity {
    private static final int PICK_IMAGE = 200;
    private static AlertDialog alertDialog;
    String action = "luminous.ACTION_PICK";
    private ImageLoader imageLoader;
    private ViewPagerSwipeLess mPager;
    private HashMap<String, CustomGallery> dataT;
    private CustomPagerAdapter adapter;
    private ImageListRecycleAdapter mImageListAdapter;

    public static void showAlertDialog(Context mContext, String text) {
        alertDialog = new AlertDialog.Builder(mContext).setMessage((CharSequence)text).setCancelable(false).setPositiveButton((CharSequence)"OK", new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                alertDialog.dismiss();
            }
        }).create();
        alertDialog.show();
    }

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.activity_multiimage_preview);
        this.initImageLoader();
        this.mPager = (ViewPagerSwipeLess)this.findViewById(R.id.pager);
        this.dataT = new HashMap();
        this.adapter = new CustomPagerAdapter(this.dataT);
        this.mPager.setAdapter(this.adapter);
        this.mPager.setOnPageChangeListener(new ViewPager.OnPageChangeListener(){

            public void onPageScrolled(int position, float positionOffset, int positionOffsetPixels) {
            }

            public void onPageSelected(int position) {
            }

            public void onPageScrollStateChanged(int state) {
            }
        });
        this.mImageListAdapter = new ImageListRecycleAdapter((Context)this, this.dataT);
        RecyclerView mRecycleView = (RecyclerView)this.findViewById(R.id.image_hlistview);
        mRecycleView.setLayoutManager((RecyclerView.LayoutManager)new LinearLayoutManager((Context)this, 0, false));
        mRecycleView.setAdapter((RecyclerView.Adapter)this.mImageListAdapter);
        this.mImageListAdapter.setOnItemClickListener(new AdapterView.OnItemClickListener(){

            public void onItemClick(AdapterView<?> parent, View view, int position, long id2) {
                MultipleImagePreviewActivity.this.mPager.setCurrentItem(position);
            }
        });
        this.findViewById(R.id.navigate_crop).setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (MultipleImagePreviewActivity.this.adapter != null && MultipleImagePreviewActivity.this.adapter.getCount() > 0) {
                    String imagePath = ((MultipleImagePreviewActivity)MultipleImagePreviewActivity.this).mImageListAdapter.mItems.get((int)((MultipleImagePreviewActivity)MultipleImagePreviewActivity.this).mPager.getCurrentItem()).sdcardPath;
                    Crop.of(Uri.parse((String)("file://" + imagePath)), Uri.parse((String)("file://" + imagePath))).asSquare().start(MultipleImagePreviewActivity.this);
                }
            }
        });
        this.findViewById(R.id.add_image_navigate).setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                Intent i = new Intent((Context)MultipleImagePreviewActivity.this, CustomGalleryActivity.class);
                i.setAction(MultipleImagePreviewActivity.this.action);
                MultipleImagePreviewActivity.this.startActivityForResult(i, 200);
            }
        });
        this.findViewById(R.id.btn_cancel).setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                Intent data2 = new Intent();
                MultipleImagePreviewActivity.this.setResult(0, data2);
                MultipleImagePreviewActivity.this.finish();
            }
        });
        ((TextView)this.findViewById(R.id.btn_done_text)).setText((CharSequence)"Send");
        this.findViewById(R.id.btn_done).setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                ArrayList mArrayList = new ArrayList(MultipleImagePreviewActivity.this.dataT.values());
                if (mArrayList.size() > 0) {
                    String[] allPath = new String[mArrayList.size()];
                    for (int i = 0; i < allPath.length; ++i) {
                        allPath[i] = ((CustomGallery)mArrayList.get((int)i)).sdcardPath;
                    }
                    Intent data = new Intent().putExtra("all_path", allPath);
                    MultipleImagePreviewActivity.this.setResult(-1, data);
                    MultipleImagePreviewActivity.this.finish();
                } else {
                    MultipleImagePreviewActivity.showAlertDialog((Context)MultipleImagePreviewActivity.this, "Please select an image.");
                }
            }
        });
        try {
            boolean isCrop = this.getIntent().getExtras().getBoolean("crop");
            if (isCrop) {
                this.findViewById(R.id.navigate_crop).setVisibility(0);
            } else {
                this.findViewById(R.id.navigate_crop).setVisibility(8);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        Intent i = new Intent((Context)this, CustomGalleryActivity.class);
        if (this.getIntent().getAction() != null) {
            this.action = this.getIntent().getAction();
        }
        i.setAction(this.action);
        this.startActivityForResult(i, 200);
    }

    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        if (resultCode == -1) {
            if (requestCode == 200 && this.action.equals("luminous.ACTION_MULTIPLE_PICK")) {
                String[] all_path;
                for (String string2 : all_path = data.getStringArrayExtra("all_path")) {
                    if (string2 == null) continue;
                    CustomGallery item = new CustomGallery();
                    item.sdcardPath = string2;
                    item.sdCardUri = Uri.parse((String)string2);
                    this.dataT.put(string2, item);
                }
                this.adapter.customNotify(this.dataT);
                this.mImageListAdapter.customNotify(this.dataT);
            } else if (requestCode == 200 && this.action.equals("luminous.ACTION_PICK")) {
                String single_path = data.getExtras().getString("single_path");
                this.dataT.clear();
                if (single_path != null) {
                    CustomGallery item = new CustomGallery();
                    item.sdcardPath = single_path;
                    item.sdCardUri = Uri.parse((String)single_path);
                    this.dataT.put(single_path, item);
                }
                this.adapter.customNotify(this.dataT);
                this.mImageListAdapter.customNotify(this.dataT);
            } else if (requestCode == 6709) {
                try {
                    Uri mTargetImageUri = (Uri)data.getExtras().get("output");
                    CustomGallery item = new CustomGallery();
                    item.sdcardPath = mTargetImageUri.getPath();
                    item.sdCardUri = mTargetImageUri;
                    this.imageLoader.clearDiskCache();
                    this.imageLoader.getDiskCache().remove("file://" + item.sdcardPath);
                    this.imageLoader.getMemoryCache().remove((Object)("file://" + item.sdcardPath));
                    this.dataT.put(mTargetImageUri.getPath(), item);
                    this.adapter.customNotify(this.dataT);
                    this.mImageListAdapter.customNotify(this.dataT);
                }
                catch (Exception e) {
                    String invalidImageText = (String)data.getExtras().get("invalid_image");
                    if (invalidImageText != null) {
                        MultipleImagePreviewActivity.showAlertDialog((Context)this, invalidImageText);
                    }
                }
            }
        } else if (this.dataT == null || this.dataT.size() <= 0) {
            Intent data2 = new Intent();
            this.setResult(0, data2);
            this.finish();
        }
    }

    private void initImageLoader() {
        try {
            String CACHE_DIR = Environment.getExternalStorageDirectory().getAbsolutePath() + "/.temp_tmp";
            new File(CACHE_DIR).mkdirs();
            File cacheDir = StorageUtils.getOwnCacheDirectory((Context)this.getBaseContext(), (String)CACHE_DIR);
            DisplayImageOptions defaultOptions = new DisplayImageOptions.Builder().cacheOnDisk(true).imageScaleType(ImageScaleType.EXACTLY).bitmapConfig(Bitmap.Config.RGB_565).build();
            ImageLoaderConfiguration.Builder builder = new ImageLoaderConfiguration.Builder(this.getBaseContext()).defaultDisplayImageOptions(defaultOptions).diskCache((DiskCache)new UnlimitedDiscCache(cacheDir));
            ImageLoaderConfiguration config = builder.build();
            this.imageLoader = ImageLoader.getInstance();
            this.imageLoader.init(config);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    class CustomPagerAdapter
    extends PagerAdapter {
        LayoutInflater mLayoutInflater;
        ArrayList<CustomGallery> dataT;

        public CustomPagerAdapter(HashMap<String, CustomGallery> dataT) {
            this.dataT = new ArrayList<CustomGallery>(dataT.values());
            this.mLayoutInflater = (LayoutInflater)MultipleImagePreviewActivity.this.getSystemService("layout_inflater");
        }

        public void customNotify(HashMap<String, CustomGallery> dataHashmap) {
            this.dataT.clear();
            ArrayList<CustomGallery> dataT2 = new ArrayList<CustomGallery>(dataHashmap.values());
            this.dataT.addAll(dataT2);
            this.notifyDataSetChanged();
        }

        public int getCount() {
            return this.dataT.size();
        }

        public boolean isViewFromObject(View view, Object object) {
            return view == (LinearLayout)object;
        }

        public int getItemPosition(Object object) {
            return -2;
        }

        public Object instantiateItem(ViewGroup container, int position) {
            View itemView = this.mLayoutInflater.inflate(R.layout.image_pager_item, container, false);
            final ImageView imageView = (ImageView)itemView.findViewById(R.id.full_screen_image);
            MultipleImagePreviewActivity.this.imageLoader.displayImage("file://" + this.dataT.get((int)position).sdcardPath, imageView, (ImageLoadingListener)new SimpleImageLoadingListener(){

                public void onLoadingStarted(String imageUri, View view) {
                    imageView.setImageResource(R.drawable.placeholder_470x352);
                    super.onLoadingStarted(imageUri, view);
                }
            });
            container.addView(itemView);
            return itemView;
        }

        public void destroyItem(ViewGroup container, int position, Object object) {
            container.removeView((View)((LinearLayout)object));
        }
    }
}

