/*
 * Decompiled with CFR 0.152.
 */
package com.cronutils.model.definition;

import com.cronutils.model.CronType;
import com.cronutils.model.definition.CronConstraint;
import com.cronutils.model.definition.CronConstraintsFactory;
import com.cronutils.model.definition.CronDefinition;
import com.cronutils.model.field.CronFieldName;
import com.cronutils.model.field.definition.FieldDayOfWeekDefinitionBuilder;
import com.cronutils.model.field.definition.FieldDefinition;
import com.cronutils.model.field.definition.FieldDefinitionBuilder;
import com.cronutils.model.field.definition.FieldQuestionMarkDefinitionBuilder;
import com.cronutils.model.field.definition.FieldSpecialCharsDefinitionBuilder;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class CronDefinitionBuilder {
    private final Map<CronFieldName, FieldDefinition> fields = new EnumMap<CronFieldName, FieldDefinition>(CronFieldName.class);
    private final Set<CronConstraint> cronConstraints = new HashSet<CronConstraint>();
    private boolean enforceStrictRanges;
    private boolean matchDayOfWeekAndDayOfMonth;

    private CronDefinitionBuilder() {
    }

    public static CronDefinitionBuilder defineCron() {
        return new CronDefinitionBuilder();
    }

    public FieldDefinitionBuilder withSeconds() {
        return new FieldDefinitionBuilder(this, CronFieldName.SECOND);
    }

    public FieldDefinitionBuilder withMinutes() {
        return new FieldDefinitionBuilder(this, CronFieldName.MINUTE);
    }

    public FieldDefinitionBuilder withHours() {
        return new FieldDefinitionBuilder(this, CronFieldName.HOUR);
    }

    public FieldSpecialCharsDefinitionBuilder withDayOfMonth() {
        return new FieldSpecialCharsDefinitionBuilder(this, CronFieldName.DAY_OF_MONTH);
    }

    public FieldDefinitionBuilder withMonth() {
        return new FieldDefinitionBuilder(this, CronFieldName.MONTH);
    }

    public FieldDayOfWeekDefinitionBuilder withDayOfWeek() {
        return new FieldDayOfWeekDefinitionBuilder(this, CronFieldName.DAY_OF_WEEK);
    }

    public FieldDefinitionBuilder withYear() {
        return new FieldDefinitionBuilder(this, CronFieldName.YEAR);
    }

    public FieldQuestionMarkDefinitionBuilder withDayOfYear() {
        return new FieldQuestionMarkDefinitionBuilder(this, CronFieldName.DAY_OF_YEAR);
    }

    public CronDefinitionBuilder enforceStrictRanges() {
        this.enforceStrictRanges = true;
        return this;
    }

    public CronDefinitionBuilder matchDayOfWeekAndDayOfMonth() {
        this.matchDayOfWeekAndDayOfMonth = true;
        return this;
    }

    public CronDefinitionBuilder withCronValidation(CronConstraint validation) {
        this.cronConstraints.add(validation);
        return this;
    }

    public void register(FieldDefinition definition) {
        boolean hasOptionalField = false;
        for (FieldDefinition fieldDefinition : this.fields.values()) {
            if (!fieldDefinition.isOptional()) continue;
            hasOptionalField = true;
            break;
        }
        if (!definition.isOptional() && hasOptionalField) {
            throw new IllegalArgumentException("Can't register mandatory definition after a optional definition.");
        }
        this.fields.put(definition.getFieldName(), definition);
    }

    public CronDefinition instance() {
        HashSet<CronConstraint> validations = new HashSet<CronConstraint>();
        validations.addAll(this.cronConstraints);
        ArrayList<FieldDefinition> values = new ArrayList<FieldDefinition>(this.fields.values());
        values.sort(FieldDefinition.createFieldDefinitionComparator());
        return new CronDefinition(values, validations, this.enforceStrictRanges, this.matchDayOfWeekAndDayOfMonth);
    }

    private static CronDefinition cron4j() {
        return CronDefinitionBuilder.defineCron().withMinutes().and().withHours().and().withDayOfMonth().supportsL().and().withMonth().and().withDayOfWeek().withValidRange(0, 6).withMondayDoWValue(1).and().enforceStrictRanges().matchDayOfWeekAndDayOfMonth().instance();
    }

    private static CronDefinition quartz() {
        return CronDefinitionBuilder.defineCron().withSeconds().and().withMinutes().and().withHours().and().withDayOfMonth().withValidRange(1, 32).supportsL().supportsW().supportsLW().supportsQuestionMark().and().withMonth().withValidRange(1, 13).and().withDayOfWeek().withValidRange(1, 7).withMondayDoWValue(2).supportsHash().supportsL().supportsQuestionMark().and().withYear().withValidRange(1970, 2099).optional().and().withCronValidation(CronConstraintsFactory.ensureEitherDayOfWeekOrDayOfMonth()).instance();
    }

    private static CronDefinition spring() {
        return CronDefinitionBuilder.defineCron().withSeconds().and().withMinutes().and().withHours().and().withDayOfMonth().supportsQuestionMark().and().withMonth().and().withDayOfWeek().withValidRange(1, 7).withMondayDoWValue(2).supportsQuestionMark().and().instance();
    }

    private static CronDefinition unixCrontab() {
        return CronDefinitionBuilder.defineCron().withMinutes().and().withHours().and().withDayOfMonth().and().withMonth().and().withDayOfWeek().withValidRange(0, 7).withMondayDoWValue(1).withIntMapping(7, 0).and().enforceStrictRanges().instance();
    }

    public static CronDefinition instanceDefinitionFor(CronType cronType) {
        switch (cronType) {
            case CRON4J: {
                return CronDefinitionBuilder.cron4j();
            }
            case QUARTZ: {
                return CronDefinitionBuilder.quartz();
            }
            case UNIX: {
                return CronDefinitionBuilder.unixCrontab();
            }
            case SPRING: {
                return CronDefinitionBuilder.spring();
            }
        }
        throw new IllegalArgumentException(String.format("No cron definition found for %s", new Object[]{cronType}));
    }
}

