/*
 * Decompiled with CFR 0.152.
 */
package com.cronutils.mapper;

import com.cronutils.Function;
import com.cronutils.mapper.ConstantsMapper;
import com.cronutils.mapper.CronMapper$$Lambda$1;
import com.cronutils.mapper.CronMapper$$Lambda$2;
import com.cronutils.mapper.CronMapper$$Lambda$3;
import com.cronutils.mapper.CronMapper$$Lambda$4;
import com.cronutils.mapper.CronMapper$$Lambda$5;
import com.cronutils.mapper.CronMapper$$Lambda$6;
import com.cronutils.mapper.CronMapper$$Lambda$7;
import com.cronutils.mapper.CronMapper$$Lambda$8;
import com.cronutils.model.Cron;
import com.cronutils.model.CronType;
import com.cronutils.model.definition.CronDefinition;
import com.cronutils.model.definition.CronDefinitionBuilder;
import com.cronutils.model.field.CronField;
import com.cronutils.model.field.CronFieldName;
import com.cronutils.model.field.constraint.FieldConstraints;
import com.cronutils.model.field.constraint.FieldConstraintsBuilder;
import com.cronutils.model.field.definition.DayOfWeekFieldDefinition;
import com.cronutils.model.field.definition.FieldDefinition;
import com.cronutils.model.field.expression.Always;
import com.cronutils.model.field.expression.FieldExpression;
import com.cronutils.model.field.expression.On;
import com.cronutils.model.field.expression.QuestionMark;
import com.cronutils.model.field.expression.visitor.ValueMappingFieldExpressionVisitor;
import com.cronutils.model.field.value.FieldValue;
import com.cronutils.model.field.value.IntegerFieldValue;
import com.cronutils.model.field.value.SpecialChar;
import com.cronutils.utils.Preconditions;
import com.cronutils.utils.VisibleForTesting;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class CronMapper {
    private Map<CronFieldName, Function<CronField, CronField>> mappings;
    private Function<Cron, Cron> cronRules;
    private CronDefinition to;

    public CronMapper(CronDefinition from, CronDefinition to, Function<Cron, Cron> cronRules) {
        Preconditions.checkNotNull(from, "Source CronDefinition must not be null");
        this.to = Preconditions.checkNotNull(to, "Destination CronDefinition must not be null");
        this.cronRules = Preconditions.checkNotNull(cronRules, "CronRules must not be null");
        this.mappings = new HashMap<CronFieldName, Function<CronField, CronField>>();
        this.buildMappings(from, to);
    }

    public Cron map(Cron cron) {
        Preconditions.checkNotNull(cron, "Cron must not be null");
        ArrayList<CronField> fields = new ArrayList<CronField>();
        for (CronFieldName name : CronFieldName.values()) {
            if (!this.mappings.containsKey((Object)name)) continue;
            fields.add(this.mappings.get((Object)name).apply(cron.retrieve(name)));
        }
        return this.cronRules.apply(new Cron(this.to, fields)).validate();
    }

    public static CronMapper fromCron4jToQuartz() {
        return new CronMapper(CronDefinitionBuilder.instanceDefinitionFor(CronType.CRON4J), CronDefinitionBuilder.instanceDefinitionFor(CronType.QUARTZ), CronMapper.setQuestionMark());
    }

    public static CronMapper fromQuartzToCron4j() {
        return new CronMapper(CronDefinitionBuilder.instanceDefinitionFor(CronType.QUARTZ), CronDefinitionBuilder.instanceDefinitionFor(CronType.CRON4J), CronMapper.sameCron());
    }

    public static CronMapper fromQuartzToUnix() {
        return new CronMapper(CronDefinitionBuilder.instanceDefinitionFor(CronType.QUARTZ), CronDefinitionBuilder.instanceDefinitionFor(CronType.UNIX), CronMapper.sameCron());
    }

    public static CronMapper fromUnixToQuartz() {
        return new CronMapper(CronDefinitionBuilder.instanceDefinitionFor(CronType.UNIX), CronDefinitionBuilder.instanceDefinitionFor(CronType.QUARTZ), CronMapper.setQuestionMark());
    }

    public static CronMapper sameCron(CronDefinition cronDefinition) {
        return new CronMapper(cronDefinition, cronDefinition, CronMapper.sameCron());
    }

    private static Function<Cron, Cron> sameCron() {
        return CronMapper$$Lambda$1.lambdaFactory$();
    }

    private static Function<Cron, Cron> setQuestionMark() {
        return CronMapper$$Lambda$2.lambdaFactory$();
    }

    private void buildMappings(CronDefinition from, CronDefinition to) {
        HashMap<CronFieldName, FieldDefinition> sourceFieldDefinitions = new HashMap<CronFieldName, FieldDefinition>();
        HashMap<CronFieldName, FieldDefinition> destFieldDefinitions = new HashMap<CronFieldName, FieldDefinition>();
        for (FieldDefinition fieldDefinition : from.getFieldDefinitions()) {
            sourceFieldDefinitions.put(fieldDefinition.getFieldName(), fieldDefinition);
        }
        for (FieldDefinition fieldDefinition : to.getFieldDefinitions()) {
            destFieldDefinitions.put(fieldDefinition.getFieldName(), fieldDefinition);
        }
        boolean startedDestMapping = false;
        boolean startedSourceMapping = false;
        for (CronFieldName name : CronFieldName.values()) {
            if (destFieldDefinitions.get((Object)name) != null) {
                startedDestMapping = true;
            }
            if (sourceFieldDefinitions.get((Object)name) != null) {
                startedSourceMapping = true;
            }
            if (startedDestMapping && destFieldDefinitions.get((Object)name) == null) break;
            if (!startedSourceMapping && sourceFieldDefinitions.get((Object)name) == null && destFieldDefinitions.get((Object)name) != null) {
                this.mappings.put(name, CronMapper.returnOnZeroExpression(name));
            }
            if (startedSourceMapping && sourceFieldDefinitions.get((Object)name) == null && destFieldDefinitions.get((Object)name) != null) {
                this.mappings.put(name, CronMapper.returnAlwaysExpression(name));
            }
            if (sourceFieldDefinitions.get((Object)name) == null || destFieldDefinitions.get((Object)name) == null) continue;
            if (CronFieldName.DAY_OF_WEEK.equals((Object)name)) {
                this.mappings.put(name, CronMapper.dayOfWeekMapping((DayOfWeekFieldDefinition)sourceFieldDefinitions.get((Object)name), (DayOfWeekFieldDefinition)destFieldDefinitions.get((Object)name)));
                continue;
            }
            if (CronFieldName.DAY_OF_MONTH.equals((Object)name)) {
                this.mappings.put(name, CronMapper.dayOfMonthMapping((FieldDefinition)sourceFieldDefinitions.get((Object)name), (FieldDefinition)destFieldDefinitions.get((Object)name)));
                continue;
            }
            this.mappings.put(name, CronMapper.returnSameExpression());
        }
    }

    @VisibleForTesting
    static Function<CronField, CronField> returnSameExpression() {
        return CronMapper$$Lambda$3.lambdaFactory$();
    }

    @VisibleForTesting
    static Function<CronField, CronField> returnOnZeroExpression(CronFieldName name) {
        return CronMapper$$Lambda$4.lambdaFactory$(name);
    }

    @VisibleForTesting
    static Function<CronField, CronField> returnAlwaysExpression(CronFieldName name) {
        return CronMapper$$Lambda$5.lambdaFactory$(name);
    }

    @VisibleForTesting
    static Function<CronField, CronField> dayOfWeekMapping(DayOfWeekFieldDefinition sourceDef, DayOfWeekFieldDefinition targetDef) {
        return CronMapper$$Lambda$6.lambdaFactory$(sourceDef, targetDef);
    }

    @VisibleForTesting
    static Function<CronField, CronField> dayOfMonthMapping(FieldDefinition sourceDef, FieldDefinition targetDef) {
        return CronMapper$$Lambda$7.lambdaFactory$(targetDef);
    }

    static /* synthetic */ CronField lambda$dayOfMonthMapping$7(FieldDefinition targetDef, CronField field) {
        FieldExpression expression;
        FieldExpression dest = expression = field.getExpression();
        if (expression instanceof QuestionMark && !targetDef.getConstraints().getSpecialChars().contains((Object)SpecialChar.QUESTION_MARK)) {
            dest = new Always();
        }
        return new CronField(CronFieldName.DAY_OF_MONTH, dest, targetDef.getConstraints());
    }

    static /* synthetic */ CronField lambda$dayOfWeekMapping$6(DayOfWeekFieldDefinition sourceDef, DayOfWeekFieldDefinition targetDef, CronField field) {
        FieldExpression expression = field.getExpression();
        FieldExpression dest = null;
        dest = expression.accept(new ValueMappingFieldExpressionVisitor(CronMapper$$Lambda$8.lambdaFactory$(sourceDef, targetDef)));
        if (expression instanceof QuestionMark && !targetDef.getConstraints().getSpecialChars().contains((Object)SpecialChar.QUESTION_MARK)) {
            dest = new Always();
        }
        return new CronField(CronFieldName.DAY_OF_WEEK, dest, targetDef.getConstraints());
    }

    static /* synthetic */ FieldValue lambda$null$5(DayOfWeekFieldDefinition sourceDef, DayOfWeekFieldDefinition targetDef, FieldValue fieldValue) {
        if (fieldValue instanceof IntegerFieldValue) {
            return new IntegerFieldValue(ConstantsMapper.weekDayMapping(sourceDef.getMondayDoWValue(), targetDef.getMondayDoWValue(), ((IntegerFieldValue)fieldValue).getValue()));
        }
        return fieldValue;
    }

    static /* synthetic */ CronField lambda$returnAlwaysExpression$4(CronFieldName name, CronField field) {
        return new CronField(name, new Always(), FieldConstraintsBuilder.instance().forField(name).createConstraintsInstance());
    }

    static /* synthetic */ CronField lambda$returnOnZeroExpression$3(CronFieldName name, CronField field) {
        FieldConstraints constraints = FieldConstraintsBuilder.instance().forField(name).createConstraintsInstance();
        return new CronField(name, new On(new IntegerFieldValue(0)), constraints);
    }

    static /* synthetic */ CronField lambda$returnSameExpression$2(CronField field) {
        return field;
    }

    static /* synthetic */ Cron lambda$setQuestionMark$1(Cron cron) {
        CronField dow = cron.retrieve(CronFieldName.DAY_OF_WEEK);
        CronField dom = cron.retrieve(CronFieldName.DAY_OF_MONTH);
        if (dow != null && dom != null) {
            if (dow.getExpression() instanceof QuestionMark || dom.getExpression() instanceof QuestionMark) {
                return cron;
            }
            HashMap<CronFieldName, CronField> fields = new HashMap<CronFieldName, CronField>();
            fields.putAll(cron.retrieveFieldsAsMap());
            if (dow.getExpression() instanceof Always) {
                fields.put(CronFieldName.DAY_OF_WEEK, new CronField(CronFieldName.DAY_OF_WEEK, new QuestionMark(), ((CronField)fields.get((Object)CronFieldName.DAY_OF_WEEK)).getConstraints()));
            } else if (dom.getExpression() instanceof Always) {
                fields.put(CronFieldName.DAY_OF_MONTH, new CronField(CronFieldName.DAY_OF_MONTH, new QuestionMark(), ((CronField)fields.get((Object)CronFieldName.DAY_OF_MONTH)).getConstraints()));
            } else {
                cron.validate();
            }
            return new Cron(cron.getCronDefinition(), new ArrayList<CronField>(fields.values()));
        }
        return cron;
    }

    static /* synthetic */ Cron lambda$sameCron$0(Cron cron) {
        return cron;
    }
}

