/*
 * Decompiled with CFR 0.152.
 */
package com.cronutils.parser;

import com.cronutils.model.field.CronField;
import com.cronutils.model.field.CronFieldName;
import com.cronutils.model.field.constraint.FieldConstraints;
import com.cronutils.parser.FieldParser;
import com.cronutils.utils.Preconditions;
import java.util.Comparator;

public class CronParserField {
    private final CronFieldName field;
    private final FieldConstraints constraints;
    private final FieldParser parser;

    public CronParserField(CronFieldName fieldName, FieldConstraints constraints) {
        this.field = Preconditions.checkNotNull(fieldName, "CronFieldName must not be null");
        this.constraints = Preconditions.checkNotNull(constraints, "FieldConstraints must not be null");
        this.parser = new FieldParser(constraints);
    }

    public CronFieldName getField() {
        return this.field;
    }

    public CronField parse(String expression) {
        return new CronField(this.field, this.parser.parse(expression), this.constraints);
    }

    public static Comparator<CronParserField> createFieldTypeComparator() {
        return (o1, o2) -> o1.getField().getOrder() - o2.getField().getOrder();
    }
}

