/*
 * Decompiled with CFR 0.152.
 */
package com.cronutils.builder;

import com.cronutils.model.Cron;
import com.cronutils.model.definition.CronDefinition;
import com.cronutils.model.field.CronField;
import com.cronutils.model.field.CronFieldName;
import com.cronutils.model.field.constraint.FieldConstraints;
import com.cronutils.model.field.expression.FieldExpression;
import com.cronutils.model.field.expression.visitor.ValidationFieldExpressionVisitor;
import com.cronutils.utils.Preconditions;
import com.cronutils.utils.VisibleForTesting;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class CronBuilder {
    private final Map<CronFieldName, CronField> fields = new HashMap<CronFieldName, CronField>();
    private CronDefinition definition;

    private CronBuilder(CronDefinition definition) {
        this.definition = definition;
    }

    public static CronBuilder cron(CronDefinition definition) {
        return new CronBuilder(definition);
    }

    public CronBuilder withYear(FieldExpression expression) {
        return this.addField(CronFieldName.YEAR, expression);
    }

    public CronBuilder withDoM(FieldExpression expression) {
        return this.addField(CronFieldName.DAY_OF_MONTH, expression);
    }

    public CronBuilder withMonth(FieldExpression expression) {
        return this.addField(CronFieldName.MONTH, expression);
    }

    public CronBuilder withDoW(FieldExpression expression) {
        return this.addField(CronFieldName.DAY_OF_WEEK, expression);
    }

    public CronBuilder withHour(FieldExpression expression) {
        return this.addField(CronFieldName.HOUR, expression);
    }

    public CronBuilder withMinute(FieldExpression expression) {
        return this.addField(CronFieldName.MINUTE, expression);
    }

    public CronBuilder withSecond(FieldExpression expression) {
        return this.addField(CronFieldName.SECOND, expression);
    }

    public Cron instance() {
        return new Cron(this.definition, new ArrayList<CronField>(this.fields.values())).validate();
    }

    @VisibleForTesting
    CronBuilder addField(CronFieldName name, FieldExpression expression) {
        Preconditions.checkState(this.definition != null, "CronBuilder not initialized.", new Object[0]);
        FieldConstraints constraints = this.definition.getFieldDefinition(name).getConstraints();
        expression.accept(new ValidationFieldExpressionVisitor(constraints, this.definition.isStrictRanges()));
        this.fields.put(name, new CronField(name, expression, constraints));
        return this;
    }
}

