/*
 * Decompiled with CFR 0.152.
 */
package com.cronutils.model.time.generator;

import com.cronutils.mapper.ConstantsMapper;
import com.cronutils.mapper.WeekDay;
import com.cronutils.model.field.CronField;
import com.cronutils.model.field.CronFieldName;
import com.cronutils.model.field.expression.FieldExpression;
import com.cronutils.model.field.expression.On;
import com.cronutils.model.time.generator.FieldValueGenerator;
import com.cronutils.model.time.generator.NoSuchValueException;
import com.google.common.collect.Lists;
import java.time.DayOfWeek;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.Validate;

class OnDayOfWeekValueGenerator
extends FieldValueGenerator {
    private int year;
    private int month;
    private WeekDay mondayDoWValue;

    public OnDayOfWeekValueGenerator(CronField cronField, int year, int month, WeekDay mondayDoWValue) {
        super(cronField);
        Validate.isTrue((boolean)CronFieldName.DAY_OF_WEEK.equals((Object)cronField.getField()), (String)"CronField does not belong to day of week", (Object[])new Object[0]);
        this.year = year;
        this.month = month;
        this.mondayDoWValue = mondayDoWValue;
    }

    @Override
    public int generateNextValue(int reference) throws NoSuchValueException {
        On on = (On)this.cronField.getExpression();
        int value = this.generateValue(on, this.year, this.month, reference);
        if (value <= reference) {
            throw new NoSuchValueException();
        }
        return value;
    }

    @Override
    public int generatePreviousValue(int reference) throws NoSuchValueException {
        On on = (On)this.cronField.getExpression();
        int value = this.generateValue(on, this.year, this.month, reference);
        if (value >= reference) {
            throw new NoSuchValueException();
        }
        return value;
    }

    @Override
    protected List<Integer> generateCandidatesNotIncludingIntervalExtremes(int start, int end) {
        ArrayList values = Lists.newArrayList();
        try {
            int reference = this.generateNextValue(start);
            while (reference < end) {
                values.add(reference);
                reference = this.generateNextValue(reference);
            }
        }
        catch (NoSuchValueException noSuchValueException) {
            // empty catch block
        }
        return values;
    }

    @Override
    public boolean isMatch(int value) {
        On on = (On)this.cronField.getExpression();
        try {
            return value == this.generateValue(on, this.year, this.month, value - 1);
        }
        catch (NoSuchValueException noSuchValueException) {
            return false;
        }
    }

    @Override
    protected boolean matchesFieldExpressionClass(FieldExpression fieldExpression) {
        return fieldExpression instanceof On;
    }

    private int generateValue(On on, int year, int month, int reference) throws NoSuchValueException {
        switch (on.getSpecialChar().getValue()) {
            case HASH: {
                return this.generateHashValues(on, year, month);
            }
            case L: {
                return this.generateLValues(on, year, month);
            }
            case NONE: {
                return this.generateNoneValues(on, year, month, reference);
            }
        }
        throw new NoSuchValueException();
    }

    private int generateHashValues(On on, int year, int month) {
        DayOfWeek dowForFirstDoM = LocalDate.of(year, month, 1).getDayOfWeek();
        int requiredDoW = ConstantsMapper.weekDayMapping(this.mondayDoWValue, ConstantsMapper.JAVA8, on.getTime().getValue());
        int requiredNth = on.getNth().getValue();
        int baseDay = 1;
        int diff = dowForFirstDoM.getValue() - requiredDoW;
        if (diff == 0) {
            // empty if block
        }
        if (diff < 0) {
            baseDay += Math.abs(diff);
        }
        if (diff > 0) {
            baseDay = baseDay + 7 - diff;
        }
        return (requiredNth - 1) * 7 + baseDay;
    }

    private int generateLValues(On on, int year, int month) throws NoSuchValueException {
        int requiredDoW;
        int lastDoM = LocalDate.of(year, month, 1).lengthOfMonth();
        LocalDate lastDoMDateTime = LocalDate.of(year, month, lastDoM);
        int dowForLastDoM = lastDoMDateTime.getDayOfWeek().getValue();
        int dowDiff = dowForLastDoM - (requiredDoW = ConstantsMapper.weekDayMapping(this.mondayDoWValue, ConstantsMapper.JAVA8, on.getTime().getValue()));
        if (dowDiff == 0) {
            return lastDoMDateTime.getDayOfMonth();
        }
        if (dowDiff < 0) {
            return lastDoMDateTime.minusDays(dowForLastDoM + (7 - requiredDoW)).getDayOfMonth();
        }
        if (dowDiff > 0) {
            return lastDoMDateTime.minusDays(dowDiff).getDayOfMonth();
        }
        throw new NoSuchValueException();
    }

    private int generateNoneValues(On on, int year, int month, int reference) {
        int dowForFirstDoM = LocalDate.of(year, month, 1).getDayOfWeek().getValue();
        int requiredDoW = ConstantsMapper.weekDayMapping(this.mondayDoWValue, ConstantsMapper.JAVA8, on.getTime().getValue());
        int baseDay = 1;
        int diff = dowForFirstDoM - requiredDoW;
        if (diff < 0) {
            baseDay += Math.abs(diff);
        }
        if (diff > 0) {
            baseDay = baseDay + 7 - diff;
        }
        if (reference < 1) {
            return baseDay;
        }
        while (baseDay <= reference) {
            baseDay += 7;
        }
        return baseDay;
    }
}

