/*
 * Decompiled with CFR 0.152.
 */
package com.cronutils.model.time.generator;

import com.cronutils.model.field.CronField;
import com.cronutils.model.field.CronFieldName;
import com.cronutils.model.field.expression.FieldExpression;
import com.cronutils.model.field.expression.On;
import com.cronutils.model.time.generator.FieldValueGenerator;
import com.cronutils.model.time.generator.NoSuchValueException;
import com.google.common.collect.Lists;
import java.time.DayOfWeek;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.Validate;

class OnDayOfMonthValueGenerator
extends FieldValueGenerator {
    private int year;
    private int month;

    public OnDayOfMonthValueGenerator(CronField cronField, int year, int month) {
        super(cronField);
        Validate.isTrue((boolean)CronFieldName.DAY_OF_MONTH.equals((Object)cronField.getField()), (String)"CronField does not belong to day of month", (Object[])new Object[0]);
        this.year = year;
        this.month = month;
    }

    @Override
    public int generateNextValue(int reference) throws NoSuchValueException {
        On on = (On)this.cronField.getExpression();
        int value = this.generateValue(on, this.year, this.month);
        if (value <= reference) {
            throw new NoSuchValueException();
        }
        return value;
    }

    @Override
    public int generatePreviousValue(int reference) throws NoSuchValueException {
        On on = (On)this.cronField.getExpression();
        int value = this.generateValue(on, this.year, this.month);
        if (value >= reference) {
            throw new NoSuchValueException();
        }
        return value;
    }

    @Override
    protected List<Integer> generateCandidatesNotIncludingIntervalExtremes(int start, int end) {
        ArrayList values = Lists.newArrayList();
        try {
            int reference = this.generateNextValue(start);
            while (reference < end) {
                values.add(reference);
                reference = this.generateNextValue(reference);
            }
        }
        catch (NoSuchValueException noSuchValueException) {
            // empty catch block
        }
        return values;
    }

    @Override
    public boolean isMatch(int value) {
        On on = (On)this.cronField.getExpression();
        try {
            return value == this.generateValue(on, this.year, this.month);
        }
        catch (NoSuchValueException noSuchValueException) {
            return false;
        }
    }

    @Override
    protected boolean matchesFieldExpressionClass(FieldExpression fieldExpression) {
        return fieldExpression instanceof On;
    }

    private int generateValue(On on, int year, int month) throws NoSuchValueException {
        int dayOfMonth = on.getTime().getValue();
        switch (on.getSpecialChar().getValue()) {
            case L: {
                return LocalDate.of(year, month, 1).lengthOfMonth();
            }
            case W: {
                LocalDate doM = LocalDate.of(year, month, dayOfMonth);
                if (doM.getDayOfWeek() == DayOfWeek.SATURDAY) {
                    if (dayOfMonth == 1) {
                        return 3;
                    }
                    return dayOfMonth - 1;
                }
                if (doM.getDayOfWeek() == DayOfWeek.SUNDAY && dayOfMonth + 1 <= doM.lengthOfMonth()) {
                    return dayOfMonth + 1;
                }
                return dayOfMonth;
            }
            case LW: {
                LocalDate lastDayOfMonth = LocalDate.of(year, month, LocalDate.of(year, month, 1).lengthOfMonth());
                int dow = lastDayOfMonth.getDayOfWeek().getValue();
                int diff = dow - 5;
                if (diff > 0) {
                    return lastDayOfMonth.minusDays(diff).getDayOfMonth();
                }
                return lastDayOfMonth.getDayOfMonth();
            }
        }
        throw new NoSuchValueException();
    }
}

