/*
 * Decompiled with CFR 0.152.
 */
package com.cronutils.descriptor;

import com.cronutils.descriptor.DescriptionStrategy;
import com.cronutils.descriptor.NominalDescriptionStrategy;
import com.cronutils.descriptor.TimeDescriptionStrategy;
import com.cronutils.model.field.expression.FieldExpression;
import com.cronutils.model.field.expression.On;
import com.google.common.base.Function;
import java.util.ResourceBundle;
import org.joda.time.DateTime;

class DescriptionStrategyFactory {
    private DescriptionStrategyFactory() {
    }

    public static DescriptionStrategy daysOfWeekInstance(final ResourceBundle bundle, FieldExpression expression) {
        Function<Integer, String> nominal = new Function<Integer, String>(){

            public String apply(Integer integer) {
                return new DateTime().withDayOfWeek(integer.intValue()).dayOfWeek().getAsText(bundle.getLocale());
            }
        };
        NominalDescriptionStrategy dow = new NominalDescriptionStrategy(bundle, nominal, expression);
        dow.addDescription(new Function<FieldExpression, String>((Function)nominal, bundle){
            final /* synthetic */ Function val$nominal;
            final /* synthetic */ ResourceBundle val$bundle;
            {
                this.val$nominal = function;
                this.val$bundle = resourceBundle;
            }

            public String apply(FieldExpression fieldExpression) {
                if (fieldExpression instanceof On) {
                    On on = (On)fieldExpression;
                    switch (on.getSpecialChar().getValue()) {
                        case HASH: {
                            return String.format("%s %s %s ", this.val$nominal.apply((Object)on.getTime().getValue()), on.getNth(), this.val$bundle.getString("of_every_month"));
                        }
                        case L: {
                            return String.format("%s %s %s ", this.val$bundle.getString("last"), this.val$nominal.apply((Object)on.getTime().getValue()), this.val$bundle.getString("of_every_month"));
                        }
                    }
                    return "";
                }
                return "";
            }
        });
        return dow;
    }

    public static DescriptionStrategy daysOfMonthInstance(final ResourceBundle bundle, FieldExpression expression) {
        NominalDescriptionStrategy dom = new NominalDescriptionStrategy(bundle, null, expression);
        dom.addDescription(new Function<FieldExpression, String>(){

            public String apply(FieldExpression fieldExpression) {
                if (fieldExpression instanceof On) {
                    On on = (On)fieldExpression;
                    switch (on.getSpecialChar().getValue()) {
                        case W: {
                            return String.format("%s %s %s ", bundle.getString("the_nearest_weekday_to_the"), on.getTime().getValue(), bundle.getString("of_the_month"));
                        }
                        case L: {
                            return bundle.getString("last_day_of_month");
                        }
                        case LW: {
                            return bundle.getString("last_weekday_of_month");
                        }
                    }
                    return "";
                }
                return "";
            }
        });
        return dom;
    }

    public static DescriptionStrategy monthsInstance(final ResourceBundle bundle, FieldExpression expression) {
        return new NominalDescriptionStrategy(bundle, new Function<Integer, String>(){

            public String apply(Integer integer) {
                return new DateTime().withMonthOfYear(integer.intValue()).monthOfYear().getAsText(bundle.getLocale());
            }
        }, expression);
    }

    public static DescriptionStrategy plainInstance(ResourceBundle bundle, FieldExpression expression) {
        return new NominalDescriptionStrategy(bundle, null, expression);
    }

    public static DescriptionStrategy hhMMssInstance(ResourceBundle bundle, FieldExpression hours, FieldExpression minutes, FieldExpression seconds) {
        return new TimeDescriptionStrategy(bundle, hours, minutes, seconds);
    }
}

