/*
 * Decompiled with CFR 0.152.
 */
package com.cronutils.parser;

import com.cronutils.StringValidations;
import com.cronutils.model.field.constraint.FieldConstraints;
import com.cronutils.model.field.expression.Always;
import com.cronutils.model.field.expression.And;
import com.cronutils.model.field.expression.Between;
import com.cronutils.model.field.expression.Every;
import com.cronutils.model.field.expression.FieldExpression;
import com.cronutils.model.field.expression.On;
import com.cronutils.model.field.expression.QuestionMark;
import com.cronutils.model.field.value.FieldValue;
import com.cronutils.model.field.value.IntegerFieldValue;
import com.cronutils.model.field.value.SpecialChar;
import com.cronutils.model.field.value.SpecialCharFieldValue;
import com.google.common.annotations.VisibleForTesting;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;

public class FieldParser {
    private final char[] specialCharsMinusStar = new char[]{'/', '-', ','};
    private Pattern lPattern = Pattern.compile("[0-9]L", 2);
    private Pattern wPattern = Pattern.compile("[0-9]W", 2);
    private FieldConstraints fieldConstraints;

    public FieldParser(FieldConstraints constraints) {
        this.fieldConstraints = (FieldConstraints)Validate.notNull((Object)constraints, (String)"FieldConstraints must not be null", (Object[])new Object[0]);
    }

    public FieldExpression parse(String expression) {
        if (!StringUtils.containsAny((CharSequence)expression, (char[])this.specialCharsMinusStar)) {
            if ("*".equals(expression)) {
                return new Always();
            }
            if ("?".equals(expression)) {
                return new QuestionMark();
            }
            return this.parseOn(expression);
        }
        String[] array = expression.split(",");
        if (array.length > 1) {
            And and = new And();
            for (String exp : array) {
                and.and(this.parse(exp));
            }
            return and;
        }
        array = expression.split("-");
        if (array.length > 1) {
            return this.parseBetween(array);
        }
        String[] values = expression.split("/");
        if (values.length == 2) {
            String start = values[0];
            String value = values[1];
            if ("*".equals(start.trim()) || "".equals(start.trim())) {
                return new Every(new IntegerFieldValue(Integer.parseInt(value)));
            }
            return new Every(new On(new IntegerFieldValue(Integer.parseInt(start))), new IntegerFieldValue(Integer.parseInt(value)));
        }
        if (values.length == 1) {
            throw new IllegalArgumentException("Missing steps for expression: " + expression);
        }
        throw new IllegalArgumentException("Invalid expression: " + expression);
    }

    @VisibleForTesting
    FieldExpression parseBetween(String[] array) {
        if (array[1].contains("/")) {
            String[] every = array[1].split("/");
            return new Every(new Between(this.map(array[0]), this.map(every[0])), this.mapToIntegerFieldValue(every[1]));
        }
        return new Between(this.map(array[0]), this.map(array[1]));
    }

    @VisibleForTesting
    On parseOn(String exp) {
        if ("?".equals(exp)) {
            return this.parseOnWithQuestionMark(exp);
        }
        if (exp.contains("#")) {
            return this.parseOnWithHash(exp);
        }
        if (exp.contains("LW")) {
            return this.parseOnWithLW(exp);
        }
        if (this.lPattern.matcher(exp).find() || exp.equalsIgnoreCase("L")) {
            return this.parseOnWithL(exp);
        }
        if (this.wPattern.matcher(exp).find()) {
            return this.parseOnWithW(exp);
        }
        return new On(this.mapToIntegerFieldValue(exp), new SpecialCharFieldValue(SpecialChar.NONE), new IntegerFieldValue(-1));
    }

    @VisibleForTesting
    On parseOnWithHash(String exp) {
        SpecialCharFieldValue specialChar = new SpecialCharFieldValue(SpecialChar.HASH);
        String[] array = exp.split("#");
        IntegerFieldValue nth = this.mapToIntegerFieldValue(array[1]);
        if (array[0].isEmpty()) {
            throw new IllegalArgumentException("Time should be specified!");
        }
        return new On(this.mapToIntegerFieldValue(array[0]), specialChar, nth);
    }

    @VisibleForTesting
    On parseOnWithQuestionMark(String exp) {
        SpecialCharFieldValue specialChar = new SpecialCharFieldValue(SpecialChar.QUESTION_MARK);
        if ("".equals(exp = exp.replace("?", ""))) {
            return new On(new IntegerFieldValue(-1), specialChar, new IntegerFieldValue(-1));
        }
        throw new IllegalArgumentException(String.format("Expected: '?', found: %s", exp));
    }

    @VisibleForTesting
    On parseOnWithLW(String exp) {
        SpecialCharFieldValue specialChar = new SpecialCharFieldValue(SpecialChar.LW);
        if ("".equals(exp = exp.replace("LW", ""))) {
            return new On(new IntegerFieldValue(-1), specialChar, new IntegerFieldValue(-1));
        }
        throw new IllegalArgumentException(String.format("Expected: LW, found: %s", exp));
    }

    @VisibleForTesting
    On parseOnWithL(String exp) {
        SpecialCharFieldValue specialChar = new SpecialCharFieldValue(SpecialChar.L);
        exp = exp.replace("L", "");
        IntegerFieldValue time = new IntegerFieldValue(-1);
        if (!"".equals(exp)) {
            time = this.mapToIntegerFieldValue(exp);
        }
        return new On(time, specialChar, new IntegerFieldValue(-1));
    }

    @VisibleForTesting
    On parseOnWithW(String exp) {
        return new On(this.mapToIntegerFieldValue(exp.replace("W", "")), new SpecialCharFieldValue(SpecialChar.W), new IntegerFieldValue(-1));
    }

    @VisibleForTesting
    IntegerFieldValue mapToIntegerFieldValue(String string) {
        try {
            return new IntegerFieldValue(this.intToInt(this.stringToInt(string)));
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException(String.format("Invalid value. Expected some integer, found %s", string));
        }
    }

    @VisibleForTesting
    FieldValue map(String string) {
        for (SpecialChar sc : SpecialChar.values()) {
            if (!sc.toString().equals(string)) continue;
            return new SpecialCharFieldValue(sc);
        }
        return new IntegerFieldValue(this.stringToInt(string));
    }

    int stringToInt(String exp) {
        if (this.fieldConstraints.getStringMapping().containsKey(exp)) {
            return this.fieldConstraints.getStringMapping().get(exp);
        }
        try {
            return Integer.parseInt(exp);
        }
        catch (NumberFormatException e) {
            String invalidChars = new StringValidations(this.fieldConstraints).removeValidChars(exp);
            throw new IllegalArgumentException(String.format("Invalid chars in expression! Expression: %s Invalid chars: %s", exp, invalidChars));
        }
    }

    int intToInt(Integer exp) {
        if (this.fieldConstraints.getIntMapping().containsKey(exp)) {
            return this.fieldConstraints.getIntMapping().get(exp);
        }
        return exp;
    }
}

