/*
 * Decompiled with CFR 0.152.
 */
package com.cronutils.model.field.expression.visitor;

import com.cronutils.StringValidations;
import com.cronutils.model.field.constraint.FieldConstraints;
import com.cronutils.model.field.expression.Always;
import com.cronutils.model.field.expression.And;
import com.cronutils.model.field.expression.Between;
import com.cronutils.model.field.expression.Every;
import com.cronutils.model.field.expression.FieldExpression;
import com.cronutils.model.field.expression.On;
import com.cronutils.model.field.expression.QuestionMark;
import com.cronutils.model.field.expression.visitor.FieldExpressionVisitor;
import com.cronutils.model.field.value.FieldValue;
import com.cronutils.model.field.value.IntegerFieldValue;
import com.cronutils.model.field.value.SpecialChar;
import com.cronutils.model.field.value.SpecialCharFieldValue;
import com.google.common.annotations.VisibleForTesting;

public class ValidationFieldExpressionVisitor
implements FieldExpressionVisitor {
    private static final String OORANGE = "Value %s not in range [%s, %s]";
    private FieldConstraints constraints;
    private StringValidations stringValidations;
    private boolean strictRanges;

    public ValidationFieldExpressionVisitor(FieldConstraints constraints, boolean strictRanges) {
        this.constraints = constraints;
        this.stringValidations = new StringValidations(constraints);
        this.strictRanges = strictRanges;
    }

    protected ValidationFieldExpressionVisitor(FieldConstraints constraints, StringValidations stringValidations, boolean strictRanges) {
        this.constraints = constraints;
        this.stringValidations = stringValidations;
        this.strictRanges = strictRanges;
    }

    @Override
    public FieldExpression visit(FieldExpression expression) {
        String unsupportedChars = this.stringValidations.removeValidChars(expression.asString());
        if ("".equals(unsupportedChars)) {
            if (expression instanceof Always) {
                return this.visit((Always)expression);
            }
            if (expression instanceof And) {
                return this.visit((And)expression);
            }
            if (expression instanceof Between) {
                return this.visit((Between)expression);
            }
            if (expression instanceof Every) {
                return this.visit((Every)expression);
            }
            if (expression instanceof On) {
                return this.visit((On)expression);
            }
            if (expression instanceof QuestionMark) {
                return this.visit((QuestionMark)expression);
            }
        }
        throw new IllegalArgumentException(String.format("Invalid chars in expression! Expression: %s Invalid chars: %s", expression.asString(), unsupportedChars));
    }

    @Override
    public Always visit(Always always) {
        return always;
    }

    @Override
    public And visit(And and) {
        for (FieldExpression exp : and.getExpressions()) {
            this.visit(exp);
        }
        return and;
    }

    @Override
    public Between visit(Between between) {
        int to;
        int from;
        this.isInRange(between.getFrom());
        this.isInRange(between.getTo());
        if (this.isSpecialCharNotL(between.getFrom()) || this.isSpecialCharNotL(between.getTo())) {
            throw new IllegalArgumentException("No special characters allowed in range, except for 'L'");
        }
        if (this.strictRanges && between.getFrom() instanceof IntegerFieldValue && between.getTo() instanceof IntegerFieldValue && (from = ((IntegerFieldValue)between.getFrom()).getValue().intValue()) > (to = ((IntegerFieldValue)between.getTo()).getValue().intValue())) {
            throw new IllegalArgumentException(String.format("Invalid range! [%s,%s]", from, to));
        }
        return between;
    }

    @Override
    public Every visit(Every every) {
        if (every.getExpression() instanceof Between) {
            this.visit((Between)every.getExpression());
        }
        if (every.getExpression() instanceof On) {
            this.visit((On)every.getExpression());
        }
        this.isInRange(every.getPeriod());
        return every;
    }

    @Override
    public On visit(On on) {
        if (!this.isDefault(on.getTime())) {
            this.isInRange(on.getTime());
        }
        if (!this.isDefault(on.getNth())) {
            this.isInRange(on.getNth());
        }
        return on;
    }

    @Override
    public QuestionMark visit(QuestionMark questionMark) {
        return questionMark;
    }

    @VisibleForTesting
    void isInRange(FieldValue fieldValue) {
        int value;
        if (fieldValue instanceof IntegerFieldValue && !this.constraints.isInRange(value = ((IntegerFieldValue)fieldValue).getValue().intValue())) {
            throw new IllegalArgumentException(String.format(OORANGE, value, this.constraints.getStartRange(), this.constraints.getEndRange()));
        }
    }

    @VisibleForTesting
    boolean isDefault(FieldValue fieldValue) {
        return fieldValue instanceof IntegerFieldValue && ((IntegerFieldValue)fieldValue).getValue() == -1;
    }

    boolean isSpecialCharNotL(FieldValue fieldValue) {
        return fieldValue instanceof SpecialCharFieldValue && !SpecialChar.L.equals(fieldValue.getValue());
    }
}

