/*
 * Decompiled with CFR 0.152.
 */
package com.cronutils;

import com.cronutils.model.field.constraint.FieldConstraints;
import com.cronutils.model.field.value.SpecialChar;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class StringValidations {
    private FieldConstraints constraints;
    private Pattern stringToIntKeysPattern;
    private Pattern numsAndCharsPattern;
    private Pattern lwPattern;
    private boolean strictRanges;

    public StringValidations(FieldConstraints constraints) {
        this.lwPattern = this.buildLWPattern(constraints.getSpecialChars());
        this.stringToIntKeysPattern = this.buildStringToIntPattern(constraints.getStringMapping().keySet());
        this.numsAndCharsPattern = Pattern.compile("[#\\?/\\*0-9]");
    }

    @VisibleForTesting
    Pattern buildStringToIntPattern(Set<String> strings) {
        return this.buildWordsPattern(strings);
    }

    @VisibleForTesting
    public String removeValidChars(String exp) {
        exp = exp.toUpperCase();
        Matcher numsAndCharsMatcher = this.numsAndCharsPattern.matcher(exp);
        Matcher stringToIntKeysMatcher = this.stringToIntKeysPattern.matcher(numsAndCharsMatcher.replaceAll(""));
        Matcher specialWordsMatcher = this.lwPattern.matcher(stringToIntKeysMatcher.replaceAll(""));
        return specialWordsMatcher.replaceAll("").replaceAll("\\s+", "").replaceAll(",", "").replaceAll("-", "");
    }

    @VisibleForTesting
    Pattern buildLWPattern(Set<SpecialChar> specialChars) {
        HashSet scs = Sets.newHashSet();
        for (SpecialChar sc : new SpecialChar[]{SpecialChar.L, SpecialChar.LW, SpecialChar.W}) {
            if (!specialChars.contains((Object)sc)) continue;
            scs.add(sc.name());
        }
        return this.buildWordsPattern(scs);
    }

    @VisibleForTesting
    Pattern buildWordsPattern(Set<String> words) {
        StringBuilder builder = new StringBuilder("\\b(");
        boolean first = true;
        for (String word : words) {
            if (!first) {
                builder.append("|");
            } else {
                first = false;
            }
            builder.append(word);
        }
        builder.append(")\\b");
        return Pattern.compile(builder.toString());
    }
}

