/*
 * Decompiled with CFR 0.152.
 */
package com.cronutils.model.field.expression.visitor;

import com.cronutils.model.field.constraint.FieldConstraints;
import com.cronutils.model.field.expression.Always;
import com.cronutils.model.field.expression.And;
import com.cronutils.model.field.expression.Between;
import com.cronutils.model.field.expression.Every;
import com.cronutils.model.field.expression.FieldExpression;
import com.cronutils.model.field.expression.On;
import com.cronutils.model.field.expression.QuestionMark;
import com.cronutils.model.field.expression.visitor.FieldExpressionVisitor;
import com.cronutils.model.field.value.FieldValue;
import com.cronutils.model.field.value.IntegerFieldValue;
import com.cronutils.model.field.value.SpecialChar;
import com.cronutils.model.field.value.SpecialCharFieldValue;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ValidationFieldExpressionVisitor
implements FieldExpressionVisitor {
    private static final String OORANGE = "Value %s not in range [%s, %s]";
    private FieldConstraints constraints;
    private Pattern stringToIntKeysPattern;
    private Pattern numsAndCharsPattern;
    private Pattern lwPattern;
    private boolean strictRanges;

    public ValidationFieldExpressionVisitor(FieldConstraints constraints, boolean strictRanges) {
        this.constraints = constraints;
        this.lwPattern = this.buildLWPattern(constraints.getSpecialChars());
        this.stringToIntKeysPattern = this.buildStringToIntPattern(constraints.getStringMapping().keySet());
        this.numsAndCharsPattern = Pattern.compile("[#\\?/\\*0-9]");
        this.strictRanges = strictRanges;
    }

    @Override
    public FieldExpression visit(FieldExpression expression) {
        String unsupportedChars = this.removeValidChars(expression.asString()).toUpperCase();
        if ("".equals(unsupportedChars)) {
            if (expression instanceof Always) {
                return this.visit((Always)expression);
            }
            if (expression instanceof And) {
                return this.visit((And)expression);
            }
            if (expression instanceof Between) {
                return this.visit((Between)expression);
            }
            if (expression instanceof Every) {
                return this.visit((Every)expression);
            }
            if (expression instanceof On) {
                return this.visit((On)expression);
            }
            if (expression instanceof QuestionMark) {
                return this.visit((QuestionMark)expression);
            }
        }
        throw new RuntimeException(String.format("Expression contains unsupported chars: %s", unsupportedChars));
    }

    @Override
    public Always visit(Always always) {
        return always;
    }

    @Override
    public And visit(And and) {
        return and;
    }

    @Override
    public Between visit(Between between) {
        int to;
        int from;
        this.isInRange(between.getFrom());
        this.isInRange(between.getTo());
        if (this.isSpecialCharNotL(between.getFrom()) || this.isSpecialCharNotL(between.getTo())) {
            throw new IllegalArgumentException("No special characters allowed in range, except for 'L'");
        }
        if (this.strictRanges && between.getFrom() instanceof IntegerFieldValue && between.getTo() instanceof IntegerFieldValue && (from = ((IntegerFieldValue)between.getFrom()).getValue().intValue()) > (to = ((IntegerFieldValue)between.getTo()).getValue().intValue())) {
            throw new IllegalArgumentException(String.format("Invalid range! [%s,%s]", from, to));
        }
        return between;
    }

    @Override
    public Every visit(Every every) {
        if (every.getExpression() instanceof Between) {
            this.visit((Between)every.getExpression());
        }
        if (every.getExpression() instanceof On) {
            this.visit((On)every.getExpression());
        }
        this.isInRange(every.getPeriod());
        return every;
    }

    @Override
    public On visit(On on) {
        if (!this.isDefault(on.getTime())) {
            this.isInRange(on.getTime());
        }
        if (!this.isDefault(on.getNth())) {
            this.isInRange(on.getNth());
        }
        return on;
    }

    @Override
    public QuestionMark visit(QuestionMark questionMark) {
        return questionMark;
    }

    @VisibleForTesting
    Pattern buildStringToIntPattern(Set<String> strings) {
        return this.buildWordsPattern(strings);
    }

    @VisibleForTesting
    String removeValidChars(String exp) {
        Matcher numsAndCharsMatcher = this.numsAndCharsPattern.matcher(exp);
        Matcher stringToIntKeysMatcher = this.stringToIntKeysPattern.matcher(numsAndCharsMatcher.replaceAll(""));
        Matcher specialWordsMatcher = this.lwPattern.matcher(stringToIntKeysMatcher.replaceAll(""));
        return specialWordsMatcher.replaceAll("").replaceAll("\\s+", "").replaceAll(",", "").replaceAll("-", "");
    }

    @VisibleForTesting
    Pattern buildLWPattern(Set<SpecialChar> specialChars) {
        HashSet scs = Sets.newHashSet();
        for (SpecialChar sc : new SpecialChar[]{SpecialChar.L, SpecialChar.LW, SpecialChar.W}) {
            if (!specialChars.contains((Object)sc)) continue;
            scs.add(sc.name());
        }
        return this.buildWordsPattern(scs);
    }

    @VisibleForTesting
    Pattern buildWordsPattern(Set<String> words) {
        StringBuilder builder = new StringBuilder("\\b(");
        boolean first = true;
        for (String word : words) {
            if (!first) {
                builder.append("|");
            } else {
                first = false;
            }
            builder.append(word);
        }
        builder.append(")\\b");
        return Pattern.compile(builder.toString());
    }

    @VisibleForTesting
    void isInRange(FieldValue fieldValue) {
        int value;
        if (fieldValue instanceof IntegerFieldValue && !this.constraints.isInRange(value = ((IntegerFieldValue)fieldValue).getValue().intValue())) {
            throw new IllegalArgumentException(String.format(OORANGE, value, this.constraints.getStartRange(), this.constraints.getEndRange()));
        }
    }

    @VisibleForTesting
    boolean isDefault(FieldValue fieldValue) {
        if (fieldValue instanceof IntegerFieldValue) {
            return ((IntegerFieldValue)fieldValue).getValue() == -1;
        }
        return false;
    }

    boolean isSpecialCharNotL(FieldValue fieldValue) {
        if (fieldValue instanceof SpecialCharFieldValue) {
            return !SpecialChar.L.equals(fieldValue.getValue());
        }
        return false;
    }
}

