/*
 * Decompiled with CFR 0.152.
 */
package com.cronutils.model.time.generator;

import com.cronutils.model.field.Between;
import com.cronutils.model.field.FieldExpression;
import com.cronutils.model.time.generator.EveryFieldValueGenerator;
import com.cronutils.model.time.generator.FieldValueGenerator;
import com.cronutils.model.time.generator.NoSuchValueException;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;

class BetweenFieldValueGenerator
extends FieldValueGenerator {
    public BetweenFieldValueGenerator(FieldExpression expression) {
        super(expression);
    }

    @Override
    public int generateNextValue(int reference) throws NoSuchValueException {
        Between between = (Between)this.expression;
        int candidate = new EveryFieldValueGenerator(between.getEvery()).generateNextValue(reference);
        if (candidate > between.getTo()) {
            throw new NoSuchValueException();
        }
        return candidate;
    }

    @Override
    public int generatePreviousValue(int reference) throws NoSuchValueException {
        Between between = (Between)this.expression;
        int candidate = new EveryFieldValueGenerator(between.getEvery()).generatePreviousValue(reference);
        if (candidate < between.getFrom()) {
            throw new NoSuchValueException();
        }
        return candidate;
    }

    @Override
    protected List<Integer> generateCandidatesNotIncludingIntervalExtremes(int start, int end) {
        ArrayList values = Lists.newArrayList();
        Between between = (Between)this.expression;
        if (start <= between.getTo() && between.getFrom() <= end) {
            if (between.getTo() < end) {
                end = between.getTo();
            }
            if (between.getFrom() > start) {
                start = between.getFrom();
            }
            try {
                int reference = this.generateNextValue(start);
                while (reference < end) {
                    values.add(reference);
                    reference = this.generateNextValue(reference);
                }
            }
            catch (NoSuchValueException e) {
                // empty catch block
            }
        }
        return values;
    }

    @Override
    public boolean isMatch(int value) {
        Between between = (Between)this.expression;
        if (value >= between.getFrom() && value <= between.getTo()) {
            return new EveryFieldValueGenerator(between.getEvery()).isMatch(value);
        }
        return false;
    }

    @Override
    protected boolean matchesFieldExpressionClass(FieldExpression fieldExpression) {
        return fieldExpression instanceof Between;
    }
}

