/*
 * Decompiled with CFR 0.152.
 */
package com.cronutils.descriptor;

import com.cronutils.descriptor.DescriptionStrategyFactory;
import com.cronutils.model.Cron;
import com.cronutils.model.field.CronField;
import com.cronutils.model.field.CronFieldName;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import org.apache.commons.lang3.Validate;

public class CronDescriptor {
    public static final Locale DEFAULT_LOCALE = Locale.UK;
    private static final String BUNDLE = "CronUtilsI18N";
    private ResourceBundle bundle;

    private CronDescriptor(Locale locale) {
        this.bundle = ResourceBundle.getBundle(BUNDLE, locale);
    }

    private CronDescriptor() {
        this.bundle = ResourceBundle.getBundle(BUNDLE, DEFAULT_LOCALE);
    }

    public String describe(Cron cron) {
        Validate.notNull((Object)cron, (String)"Cron must not be null", (Object[])new Object[0]);
        Map<CronFieldName, CronField> expressions = cron.retrieveFieldsAsMap();
        return (this.describeHHmmss(expressions) + " " + this.describeDayOfMonth(expressions) + " " + this.describeMonth(expressions) + " " + this.describeDayOfWeek(expressions) + " " + this.describeYear(expressions)).replaceAll("\\s+", " ").trim();
    }

    private String describeHHmmss(Map<CronFieldName, CronField> fields) {
        return DescriptionStrategyFactory.hhMMssInstance(this.bundle, fields.containsKey((Object)CronFieldName.HOUR) ? fields.get((Object)CronFieldName.HOUR).getExpression() : null, fields.containsKey((Object)CronFieldName.MINUTE) ? fields.get((Object)CronFieldName.MINUTE).getExpression() : null, fields.containsKey((Object)CronFieldName.SECOND) ? fields.get((Object)CronFieldName.SECOND).getExpression() : null).describe();
    }

    private String describeDayOfMonth(Map<CronFieldName, CronField> fields) {
        return String.format(DescriptionStrategyFactory.daysOfMonthInstance(this.bundle, fields.containsKey((Object)CronFieldName.DAY_OF_MONTH) ? fields.get((Object)CronFieldName.DAY_OF_MONTH).getExpression() : null).describe(), this.bundle.getString("day"));
    }

    private String describeMonth(Map<CronFieldName, CronField> fields) {
        return String.format(DescriptionStrategyFactory.monthsInstance(this.bundle, fields.containsKey((Object)CronFieldName.MONTH) ? fields.get((Object)CronFieldName.MONTH).getExpression() : null).describe(), this.bundle.getString("month"));
    }

    private String describeDayOfWeek(Map<CronFieldName, CronField> fields) {
        return String.format(DescriptionStrategyFactory.daysOfWeekInstance(this.bundle, fields.containsKey((Object)CronFieldName.DAY_OF_WEEK) ? fields.get((Object)CronFieldName.DAY_OF_WEEK).getExpression() : null).describe(), this.bundle.getString("day"));
    }

    private String describeYear(Map<CronFieldName, CronField> fields) {
        return String.format(DescriptionStrategyFactory.plainInstance(this.bundle, fields.containsKey((Object)CronFieldName.YEAR) ? fields.get((Object)CronFieldName.YEAR).getExpression() : null).describe(), this.bundle.getString("year"));
    }

    public static CronDescriptor instance() {
        return new CronDescriptor();
    }

    public static CronDescriptor instance(Locale locale) {
        return new CronDescriptor(locale);
    }
}

