/*
 * Decompiled with CFR 0.152.
 */
package com.cronutils.model.field.constraint;

import com.cronutils.model.field.SpecialChar;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.Validate;

public class FieldConstraints {
    private Map<String, Integer> stringMapping;
    private Map<Integer, Integer> intMapping;
    private Set<SpecialChar> specialChars;
    private int startRange;
    private int endRange;

    public FieldConstraints(Map<String, Integer> stringMapping, Map<Integer, Integer> intMapping, Set<SpecialChar> specialChars, int startRange, int endRange) {
        this.stringMapping = Collections.unmodifiableMap((Map)Validate.notNull(stringMapping, (String)"String mapping must not be null", (Object[])new Object[0]));
        this.intMapping = Collections.unmodifiableMap((Map)Validate.notNull(intMapping, (String)"Integer mapping must not be null", (Object[])new Object[0]));
        this.specialChars = Collections.unmodifiableSet((Set)Validate.notNull(specialChars, (String)"Special (non-standard) chars set must not be null", (Object[])new Object[0]));
        this.startRange = startRange;
        this.endRange = endRange;
    }

    public int stringToInt(String exp) {
        if (this.stringMapping.containsKey(exp)) {
            return this.stringMapping.get(exp);
        }
        return Integer.parseInt(exp);
    }

    public int intToInt(Integer exp) {
        if (this.intMapping.containsKey(exp)) {
            return this.intMapping.get(exp);
        }
        return exp;
    }

    public int validateInRange(int number) {
        if (this.isInRange(number)) {
            return number;
        }
        throw new RuntimeException(String.format("Number %s out of range [%s,%s]", number, this.startRange, this.endRange));
    }

    public boolean isInRange(int number) {
        return number >= this.startRange && number <= this.endRange;
    }

    public void validateSpecialCharAllowed(SpecialChar specialChar) {
        if (!this.isSpecialCharAllowed(specialChar)) {
            throw new RuntimeException(String.format("Special char %s not supported!", new Object[]{specialChar}));
        }
    }

    public boolean isSpecialCharAllowed(SpecialChar specialChar) {
        return this.specialChars.contains((Object)specialChar);
    }
}

