/*
 * Decompiled with CFR 0.152.
 */
package com.crescentflare.appconfig.view;

import android.content.Context;
import android.content.res.ColorStateList;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.RippleDrawable;
import android.graphics.drawable.StateListDrawable;
import android.os.Build;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.crescentflare.appconfig.helper.AppConfigResourceHelper;
import com.crescentflare.appconfig.helper.AppConfigViewHelper;

public class AppConfigClickableCell
extends FrameLayout {
    private TextView labelView;
    private TextView valueView;

    public AppConfigClickableCell(Context context) {
        super(context);
        this.init(context, null);
    }

    public AppConfigClickableCell(Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.init(context, attrs);
    }

    public AppConfigClickableCell(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs);
        this.init(context, attrs);
    }

    public AppConfigClickableCell(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs);
        this.init(context, attrs);
    }

    private void init(Context context, AttributeSet attrs) {
        LinearLayout container = new LinearLayout(context);
        container.setOrientation(0);
        container.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -2));
        container.setMinimumHeight(this.dp(60));
        container.setPadding(this.dp(12), this.dp(12), this.dp(12), this.dp(12));
        AppConfigViewHelper.setBackgroundDrawable((View)container, this.generateSelectionBackgroundDrawable());
        this.addView((View)container);
        LinearLayout.LayoutParams layoutParams = new LinearLayout.LayoutParams(0, -2);
        layoutParams.weight = 1.0f;
        layoutParams.gravity = 16;
        this.labelView = new TextView(context);
        container.addView((View)this.labelView);
        this.labelView.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        this.labelView.setTextSize(18.0f);
        layoutParams = new LinearLayout.LayoutParams(-2, -2);
        layoutParams.gravity = 16;
        this.valueView = new TextView(context);
        container.addView((View)this.valueView);
        this.valueView.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        this.valueView.setPadding(this.dp(8), 0, 0, 0);
        this.valueView.setTextSize(14.0f);
        this.valueView.setTextColor(-3355444);
        this.valueView.setVisibility(8);
    }

    public void setText(String text) {
        this.labelView.setText((CharSequence)text);
    }

    public String getText() {
        return this.labelView.getText().toString();
    }

    public void setValue(String value) {
        this.valueView.setText((CharSequence)value);
        this.valueView.setVisibility(TextUtils.isEmpty((CharSequence)value) ? 8 : 0);
    }

    private Drawable generateSelectionBackgroundDrawable() {
        if (Build.VERSION.SDK_INT >= 21) {
            int[][] states = new int[][]{{16842908}, {16842919}, {16842910}, {-16842910}};
            int[] colors = new int[]{AppConfigResourceHelper.getColor(this.getContext(), "app_config_background"), AppConfigResourceHelper.getColor(this.getContext(), "app_config_background"), -1, -1};
            return new RippleDrawable(new ColorStateList((int[][])states, colors), null, null);
        }
        StateListDrawable stateDrawable = new StateListDrawable();
        stateDrawable.addState(new int[]{16842908}, (Drawable)new ColorDrawable(AppConfigResourceHelper.getColor(this.getContext(), "app_config_background")));
        stateDrawable.addState(new int[]{16842919}, (Drawable)new ColorDrawable(AppConfigResourceHelper.getColor(this.getContext(), "app_config_background")));
        stateDrawable.addState(new int[]{16842910}, (Drawable)new ColorDrawable(-1));
        stateDrawable.addState(new int[]{-16842910}, (Drawable)new ColorDrawable(-1));
        return stateDrawable;
    }

    private int dp(int dp) {
        return AppConfigViewHelper.dp(dp);
    }
}

