/*
 * Decompiled with CFR 0.152.
 */
package com.crescentflare.appconfig.view;

import android.content.Context;
import android.graphics.Typeface;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.GradientDrawable;
import android.support.annotation.Nullable;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.crescentflare.appconfig.helper.AppConfigResourceHelper;
import com.crescentflare.appconfig.helper.AppConfigViewHelper;
import com.crescentflare.appconfig.view.AppConfigEditableCell;

public class AppConfigCellList
extends LinearLayout {
    private View previousItemView = null;

    public AppConfigCellList(Context context) {
        super(context);
        this.init(context, null);
    }

    public AppConfigCellList(Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.init(context, attrs);
    }

    public AppConfigCellList(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs);
        this.init(context, attrs);
    }

    public AppConfigCellList(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs);
        this.init(context, attrs);
    }

    private void init(Context context, AttributeSet attrs) {
        this.setOrientation(1);
    }

    public void startSection(String headerText) {
        if (this.getChildCount() > 0) {
            View topLineView = new View(this.getContext());
            topLineView.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, 1));
            topLineView.setBackgroundColor(AppConfigResourceHelper.getColor(this.getContext(), "app_config_section_divider_line"));
            this.addView(topLineView);
        }
        LinearLayout createdView = new LinearLayout(this.getContext());
        createdView.setOrientation(1);
        createdView.setBackgroundColor(-1);
        TextView labelView = new TextView(this.getContext());
        createdView.addView((View)labelView);
        labelView.setPadding(this.dp(12), this.dp(12), this.dp(12), this.dp(12));
        labelView.setTypeface(Typeface.DEFAULT_BOLD);
        labelView.setTextColor(AppConfigResourceHelper.getAccentColor(this.getContext()));
        labelView.setText((CharSequence)headerText);
        this.addView((View)createdView);
        this.previousItemView = null;
    }

    public void endSection() {
        View topLineView = new View(this.getContext());
        topLineView.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, 1));
        topLineView.setBackgroundColor(AppConfigResourceHelper.getColor(this.getContext(), "app_config_section_divider_line"));
        this.addView(topLineView);
        View gradientView = new View(this.getContext());
        int[] colors = new int[]{AppConfigResourceHelper.getColor(this.getContext(), "app_config_section_gradient_start"), AppConfigResourceHelper.getColor(this.getContext(), "app_config_section_gradient_end"), AppConfigResourceHelper.getColor(this.getContext(), "app_config_background")};
        GradientDrawable drawable = new GradientDrawable(GradientDrawable.Orientation.TOP_BOTTOM, colors);
        gradientView.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, this.dp(8)));
        AppConfigViewHelper.setBackgroundDrawable(gradientView, (Drawable)drawable);
        this.addView(gradientView);
    }

    public void addSectionItem(View view) {
        if (!(this.previousItemView == null || this.previousItemView instanceof AppConfigEditableCell && view instanceof AppConfigEditableCell)) {
            View topLineView = new View(this.getContext());
            topLineView.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, 1));
            topLineView.setBackgroundColor(AppConfigResourceHelper.getColor(this.getContext(), "app_config_section_divider_line"));
            this.addView(topLineView);
        }
        view.setBackgroundColor(-1);
        this.addView(view);
        this.previousItemView = view;
    }

    public void removeAllViews() {
        super.removeAllViews();
        this.previousItemView = null;
    }

    private int dp(int dp) {
        return AppConfigViewHelper.dp(dp);
    }
}

